/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/StackTraceElementSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/lang/StackTraceElement;", "Lnet/corda/serialization/internal/amqp/custom/StackTraceElementSerializer$StackTraceElementProxy;", "factory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "(Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "StackTraceElementProxy", "serialization"})
public final class StackTraceElementSerializer
extends CustomSerializer.Proxy<StackTraceElement, StackTraceElementProxy> {
    @Override
    @NotNull
    protected StackTraceElementProxy toProxy(@NotNull StackTraceElement obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = obj.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.className");
        String string2 = obj.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"obj.methodName");
        return new StackTraceElementProxy(string, string2, obj.getFileName(), obj.getLineNumber());
    }

    @Override
    @NotNull
    protected StackTraceElement fromProxy(@NotNull StackTraceElementProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        return new StackTraceElement(proxy.getDeclaringClass(), proxy.getMethodName(), proxy.getFileName(), proxy.getLineNumber());
    }

    public StackTraceElementSerializer(@NotNull LocalSerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(StackTraceElement.class, StackTraceElementProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lnet/corda/serialization/internal/amqp/custom/StackTraceElementSerializer$StackTraceElementProxy;", "", "declaringClass", "", "methodName", "fileName", "lineNumber", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getDeclaringClass", "()Ljava/lang/String;", "getFileName", "getLineNumber", "()I", "getMethodName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "serialization"})
    @KeepForDJVM
    public static final class StackTraceElementProxy {
        @NotNull
        private final String declaringClass;
        @NotNull
        private final String methodName;
        @Nullable
        private final String fileName;
        private final int lineNumber;

        @NotNull
        public final String getDeclaringClass() {
            return this.declaringClass;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @Nullable
        public final String getFileName() {
            return this.fileName;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public StackTraceElementProxy(@NotNull String declaringClass, @NotNull String methodName, @Nullable String fileName, int lineNumber) {
            Intrinsics.checkParameterIsNotNull((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @NotNull
        public final String component1() {
            return this.declaringClass;
        }

        @NotNull
        public final String component2() {
            return this.methodName;
        }

        @Nullable
        public final String component3() {
            return this.fileName;
        }

        public final int component4() {
            return this.lineNumber;
        }

        @NotNull
        public final StackTraceElementProxy copy(@NotNull String declaringClass, @NotNull String methodName, @Nullable String fileName, int lineNumber) {
            Intrinsics.checkParameterIsNotNull((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            return new StackTraceElementProxy(declaringClass, methodName, fileName, lineNumber);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ StackTraceElementProxy copy$default(StackTraceElementProxy stackTraceElementProxy, String string, String string2, String string3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = stackTraceElementProxy.declaringClass;
            }
            if ((n2 & 2) != 0) {
                string2 = stackTraceElementProxy.methodName;
            }
            if ((n2 & 4) != 0) {
                string3 = stackTraceElementProxy.fileName;
            }
            if ((n2 & 8) != 0) {
                n = stackTraceElementProxy.lineNumber;
            }
            return stackTraceElementProxy.copy(string, string2, string3, n);
        }

        @NotNull
        public String toString() {
            return "StackTraceElementProxy(declaringClass=" + this.declaringClass + ", methodName=" + this.methodName + ", fileName=" + this.fileName + ", lineNumber=" + this.lineNumber + ")";
        }

        public int hashCode() {
            String string = this.declaringClass;
            String string2 = this.methodName;
            String string3 = this.fileName;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + Integer.hashCode(this.lineNumber);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StackTraceElementProxy)) break block3;
                    StackTraceElementProxy stackTraceElementProxy = (StackTraceElementProxy)object;
                    if (!Intrinsics.areEqual((Object)this.declaringClass, (Object)stackTraceElementProxy.declaringClass) || !Intrinsics.areEqual((Object)this.methodName, (Object)stackTraceElementProxy.methodName) || !Intrinsics.areEqual((Object)this.fileName, (Object)stackTraceElementProxy.fileName) || !(this.lineNumber == stackTraceElementProxy.lineNumber)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

