/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/LocalDateSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/time/LocalDate;", "Lnet/corda/serialization/internal/amqp/custom/LocalDateSerializer$LocalDateProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "LocalDateProxy", "serialization"})
public final class LocalDateSerializer
extends CustomSerializer.Proxy<LocalDate, LocalDateProxy> {
    @Override
    @NotNull
    protected LocalDateProxy toProxy(@NotNull LocalDate obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return new LocalDateProxy(obj.getYear(), (byte)obj.getMonthValue(), (byte)obj.getDayOfMonth());
    }

    @Override
    @NotNull
    protected LocalDate fromProxy(@NotNull LocalDateProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        LocalDate localDate = LocalDate.of(proxy.getYear(), proxy.getMonth(), (int)proxy.getDay());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.of(proxy.year,\u2026Int(), proxy.day.toInt())");
        return localDate;
    }

    public LocalDateSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(LocalDate.class, LocalDateProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lnet/corda/serialization/internal/amqp/custom/LocalDateSerializer$LocalDateProxy;", "", "year", "", "month", "", "day", "(IBB)V", "getDay", "()B", "getMonth", "getYear", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "serialization"})
    @KeepForDJVM
    public static final class LocalDateProxy {
        private final int year;
        private final byte month;
        private final byte day;

        public final int getYear() {
            return this.year;
        }

        public final byte getMonth() {
            return this.month;
        }

        public final byte getDay() {
            return this.day;
        }

        public LocalDateProxy(int year, byte month, byte day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public final int component1() {
            return this.year;
        }

        public final byte component2() {
            return this.month;
        }

        public final byte component3() {
            return this.day;
        }

        @NotNull
        public final LocalDateProxy copy(int year, byte month, byte day) {
            return new LocalDateProxy(year, month, day);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LocalDateProxy copy$default(LocalDateProxy localDateProxy, int n, byte by, byte by2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = localDateProxy.year;
            }
            if ((n2 & 2) != 0) {
                by = localDateProxy.month;
            }
            if ((n2 & 4) != 0) {
                by2 = localDateProxy.day;
            }
            return localDateProxy.copy(n, by, by2);
        }

        @NotNull
        public String toString() {
            return "LocalDateProxy(year=" + this.year + ", month=" + this.month + ", day=" + this.day + ")";
        }

        public int hashCode() {
            return (Integer.hashCode(this.year) * 31 + Byte.hashCode(this.month)) * 31 + Byte.hashCode(this.day);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LocalDateProxy)) break block3;
                    LocalDateProxy localDateProxy = (LocalDateProxy)object;
                    if (!(this.year == localDateProxy.year) || !(this.month == localDateProxy.month) || !(this.day == localDateProxy.day)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

