/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.io.InputStream;
import java.security.PublicKey;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.ContractAttachment;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.MissingAttachmentsException;
import net.corda.serialization.internal.GeneratedAttachment;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/ContractAttachmentSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Lnet/corda/core/contracts/ContractAttachment;", "Lnet/corda/serialization/internal/amqp/custom/ContractAttachmentSerializer$ContractAttachmentProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "ContractAttachmentProxy", "serialization"})
public final class ContractAttachmentSerializer
extends CustomSerializer.Proxy<ContractAttachment, ContractAttachmentProxy> {
    @Override
    @NotNull
    protected ContractAttachmentProxy toProxy(@NotNull ContractAttachment obj) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        try {
            byArray = InternalUtils.readFully((InputStream)obj.getAttachment().open());
        }
        catch (Exception e) {
            throw (Throwable)new MissingAttachmentsException(CollectionsKt.listOf((Object)obj.getId()));
        }
        byte[] bytes = byArray;
        return new ContractAttachmentProxy((Attachment)new GeneratedAttachment(bytes, obj.getUploader()), obj.getContract(), obj.getAdditionalContracts(), obj.getUploader(), obj.getSignerKeys(), obj.getVersion());
    }

    @Override
    @NotNull
    protected ContractAttachment fromProxy(@NotNull ContractAttachmentProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        return ContractAttachment.Companion.create(proxy.getAttachment(), proxy.getContract(), proxy.getContracts(), proxy.getUploader(), proxy.getSigners(), proxy.getVersion());
    }

    public ContractAttachmentSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(ContractAttachment.class, ContractAttachmentProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001c\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\u0013\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\bH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\u000eH\u00c6\u0003J[\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0012\b\u0002\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u000eH\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lnet/corda/serialization/internal/amqp/custom/ContractAttachmentSerializer$ContractAttachmentProxy;", "", "attachment", "Lnet/corda/core/contracts/Attachment;", "contract", "", "Lnet/corda/core/contracts/ContractClassName;", "contracts", "", "uploader", "signers", "", "Ljava/security/PublicKey;", "version", "", "(Lnet/corda/core/contracts/Attachment;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Ljava/util/List;I)V", "getAttachment", "()Lnet/corda/core/contracts/Attachment;", "getContract", "()Ljava/lang/String;", "getContracts", "()Ljava/util/Set;", "getSigners", "()Ljava/util/List;", "getUploader", "getVersion", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "serialization"})
    @KeepForDJVM
    public static final class ContractAttachmentProxy {
        @NotNull
        private final Attachment attachment;
        @NotNull
        private final String contract;
        @NotNull
        private final Set<String> contracts;
        @Nullable
        private final String uploader;
        @NotNull
        private final List<PublicKey> signers;
        private final int version;

        @NotNull
        public final Attachment getAttachment() {
            return this.attachment;
        }

        @NotNull
        public final String getContract() {
            return this.contract;
        }

        @NotNull
        public final Set<String> getContracts() {
            return this.contracts;
        }

        @Nullable
        public final String getUploader() {
            return this.uploader;
        }

        @NotNull
        public final List<PublicKey> getSigners() {
            return this.signers;
        }

        public final int getVersion() {
            return this.version;
        }

        public ContractAttachmentProxy(@NotNull Attachment attachment, @NotNull String contract, @NotNull Set<String> contracts, @Nullable String uploader, @NotNull List<? extends PublicKey> signers, int version) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)contract, (String)"contract");
            Intrinsics.checkParameterIsNotNull(contracts, (String)"contracts");
            Intrinsics.checkParameterIsNotNull(signers, (String)"signers");
            this.attachment = attachment;
            this.contract = contract;
            this.contracts = contracts;
            this.uploader = uploader;
            this.signers = signers;
            this.version = version;
        }

        @NotNull
        public final Attachment component1() {
            return this.attachment;
        }

        @NotNull
        public final String component2() {
            return this.contract;
        }

        @NotNull
        public final Set<String> component3() {
            return this.contracts;
        }

        @Nullable
        public final String component4() {
            return this.uploader;
        }

        @NotNull
        public final List<PublicKey> component5() {
            return this.signers;
        }

        public final int component6() {
            return this.version;
        }

        @NotNull
        public final ContractAttachmentProxy copy(@NotNull Attachment attachment, @NotNull String contract, @NotNull Set<String> contracts, @Nullable String uploader, @NotNull List<? extends PublicKey> signers, int version) {
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            Intrinsics.checkParameterIsNotNull((Object)contract, (String)"contract");
            Intrinsics.checkParameterIsNotNull(contracts, (String)"contracts");
            Intrinsics.checkParameterIsNotNull(signers, (String)"signers");
            return new ContractAttachmentProxy(attachment, contract, contracts, uploader, signers, version);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ContractAttachmentProxy copy$default(ContractAttachmentProxy contractAttachmentProxy, Attachment attachment, String string, Set set, String string2, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                attachment = contractAttachmentProxy.attachment;
            }
            if ((n2 & 2) != 0) {
                string = contractAttachmentProxy.contract;
            }
            if ((n2 & 4) != 0) {
                set = contractAttachmentProxy.contracts;
            }
            if ((n2 & 8) != 0) {
                string2 = contractAttachmentProxy.uploader;
            }
            if ((n2 & 0x10) != 0) {
                list = contractAttachmentProxy.signers;
            }
            if ((n2 & 0x20) != 0) {
                n = contractAttachmentProxy.version;
            }
            return contractAttachmentProxy.copy(attachment, string, set, string2, list, n);
        }

        @NotNull
        public String toString() {
            return "ContractAttachmentProxy(attachment=" + this.attachment + ", contract=" + this.contract + ", contracts=" + this.contracts + ", uploader=" + this.uploader + ", signers=" + this.signers + ", version=" + this.version + ")";
        }

        public int hashCode() {
            Attachment attachment = this.attachment;
            String string = this.contract;
            Set<String> set = this.contracts;
            String string2 = this.uploader;
            List<PublicKey> list = this.signers;
            return (((((attachment != null ? attachment.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.version);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ContractAttachmentProxy)) break block3;
                    ContractAttachmentProxy contractAttachmentProxy = (ContractAttachmentProxy)object;
                    if (!Intrinsics.areEqual((Object)this.attachment, (Object)contractAttachmentProxy.attachment) || !Intrinsics.areEqual((Object)this.contract, (Object)contractAttachmentProxy.contract) || !Intrinsics.areEqual(this.contracts, contractAttachmentProxy.contracts) || !Intrinsics.areEqual((Object)this.uploader, (Object)contractAttachmentProxy.uploader) || !Intrinsics.areEqual(this.signers, contractAttachmentProxy.signers) || !(this.version == contractAttachmentProxy.version)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

