/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/CertPathSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/security/cert/CertPath;", "Lnet/corda/serialization/internal/amqp/custom/CertPathSerializer$CertPathProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "CertPathProxy", "serialization"})
public final class CertPathSerializer
extends CustomSerializer.Proxy<CertPath, CertPathProxy> {
    @Override
    @NotNull
    protected CertPathProxy toProxy(@NotNull CertPath obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = obj.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.type");
        byte[] byArray = obj.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"obj.encoded");
        return new CertPathProxy(string, byArray);
    }

    @Override
    @NotNull
    protected CertPath fromProxy(@NotNull CertPathProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        try {
            CertificateFactory cf = CertificateFactory.getInstance(proxy.getType());
            byte[] byArray = proxy.getEncoded();
            CertificateFactory certificateFactory = cf;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertPath certPath = certificateFactory.generateCertPath(byteArrayInputStream);
            Intrinsics.checkExpressionValueIsNotNull((Object)certPath, (String)"cf.generateCertPath(proxy.encoded.inputStream())");
            return certPath;
        }
        catch (CertificateException ce) {
            NotSerializableException nse = new NotSerializableException("java.security.cert.CertPath: " + this.getType());
            nse.initCause(ce);
            throw (Throwable)nse;
        }
    }

    public CertPathSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(CertPath.class, CertPathProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/serialization/internal/amqp/custom/CertPathSerializer$CertPathProxy;", "", "type", "", "encoded", "", "(Ljava/lang/String;[B)V", "getEncoded", "()[B", "getType", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "serialization"})
    @KeepForDJVM
    public static final class CertPathProxy {
        @NotNull
        private final String type;
        @NotNull
        private final byte[] encoded;

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final byte[] getEncoded() {
            return this.encoded;
        }

        public CertPathProxy(@NotNull String type, @NotNull byte[] encoded) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            this.type = type;
            this.encoded = encoded;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final byte[] component2() {
            return this.encoded;
        }

        @NotNull
        public final CertPathProxy copy(@NotNull String type, @NotNull byte[] encoded) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            return new CertPathProxy(type, encoded);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CertPathProxy copy$default(CertPathProxy certPathProxy, String string, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = certPathProxy.type;
            }
            if ((n & 2) != 0) {
                byArray = certPathProxy.encoded;
            }
            return certPathProxy.copy(string, byArray);
        }

        @NotNull
        public String toString() {
            return "CertPathProxy(type=" + this.type + ", encoded=" + Arrays.toString(this.encoded) + ")";
        }

        public int hashCode() {
            String string = this.type;
            return (string != null ? string.hashCode() : 0) * 31 + (this.encoded != null ? Arrays.hashCode(this.encoded) : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CertPathProxy)) break block3;
                    CertPathProxy certPathProxy = (CertPathProxy)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)certPathProxy.type) || !Intrinsics.areEqual((Object)this.encoded, (Object)certPathProxy.encoded)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

