/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.CompositeType;
import net.corda.serialization.internal.amqp.Descriptor;
import net.corda.serialization.internal.amqp.Field;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0017\u001a\u00020\f*\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lnet/corda/serialization/internal/amqp/TypeNotationGenerator;", "", "()V", "defaultValues", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "amqpTypeName", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "getAmqpTypeName", "(Lnet/corda/serialization/internal/model/LocalTypeInformation;)Ljava/lang/String;", "getTypeNotation", "Lnet/corda/serialization/internal/amqp/CompositeType;", "typeInformation", "typeDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "getField", "Lnet/corda/serialization/internal/amqp/Field;", "Lnet/corda/serialization/internal/model/LocalPropertyInformation;", "name", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Abstract;", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AnInterface;", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Composable;", "makeCompositeType", "interfaces", "", "properties", "serialization"})
public final class TypeNotationGenerator {
    private static final Map<TypeIdentifier, String> defaultValues;
    public static final TypeNotationGenerator INSTANCE;

    @NotNull
    public final CompositeType getTypeNotation(@NotNull LocalTypeInformation typeInformation, @NotNull Symbol typeDescriptor2) {
        CompositeType compositeType;
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        Intrinsics.checkParameterIsNotNull((Object)typeDescriptor2, (String)"typeDescriptor");
        LocalTypeInformation localTypeInformation = typeInformation;
        if (localTypeInformation instanceof LocalTypeInformation.AnInterface) {
            compositeType = this.getTypeNotation((LocalTypeInformation.AnInterface)typeInformation, typeDescriptor2);
        } else if (localTypeInformation instanceof LocalTypeInformation.Composable) {
            compositeType = this.getTypeNotation((LocalTypeInformation.Composable)typeInformation, typeDescriptor2);
        } else if (localTypeInformation instanceof LocalTypeInformation.Abstract) {
            compositeType = this.getTypeNotation((LocalTypeInformation.Abstract)typeInformation, typeDescriptor2);
        } else {
            throw (Throwable)new NotSerializableException("Cannot generate type notation for " + typeInformation);
        }
        return compositeType;
    }

    private final String getAmqpTypeName(@NotNull LocalTypeInformation $receiver) {
        return AMQPTypeIdentifiers.INSTANCE.nameForType($receiver.getTypeIdentifier());
    }

    private final CompositeType getTypeNotation(@NotNull LocalTypeInformation.AnInterface $receiver, Symbol typeDescriptor2) {
        return this.makeCompositeType($receiver, SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new LocalTypeInformation.AnInterface[]{$receiver}), (Sequence)CollectionsKt.asSequence((Iterable)$receiver.getInterfaces()))), $receiver.getProperties(), typeDescriptor2);
    }

    private final CompositeType getTypeNotation(@NotNull LocalTypeInformation.Composable $receiver, Symbol typeDescriptor2) {
        return this.makeCompositeType($receiver, $receiver.getInterfaces(), $receiver.getProperties(), typeDescriptor2);
    }

    private final CompositeType getTypeNotation(@NotNull LocalTypeInformation.Abstract $receiver, Symbol typeDescriptor2) {
        return this.makeCompositeType($receiver, $receiver.getInterfaces(), $receiver.getProperties(), typeDescriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeType makeCompositeType(@NotNull LocalTypeInformation $receiver, List<? extends LocalTypeInformation> interfaces, Map<String, ? extends LocalPropertyInformation> properties2, Symbol typeDescriptor2) {
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        Object object2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)interfaces;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            object2 = (LocalTypeInformation)item$iv$iv;
            collection = destination$iv$iv;
            object = INSTANCE.getAmqpTypeName((LocalTypeInformation)it);
            collection.add(object);
        }
        List provides = (List)destination$iv$iv;
        Map<String, ? extends LocalPropertyInformation> $receiver$iv2 = properties2;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList($receiver$iv2.size());
        void var10_9 = $receiver$iv$iv;
        object2 = var10_9.entrySet().iterator();
        while (object2.hasNext()) {
            void $name_property;
            Map.Entry item$iv$iv;
            Map.Entry $i$f$mapTo = item$iv$iv = (Map.Entry)object2.next();
            collection = destination$iv$iv2;
            void var14_16 = $name_property;
            String name = (String)var14_16.getKey();
            var14_16 = $name_property;
            LocalPropertyInformation property = (LocalPropertyInformation)var14_16.getValue();
            object = INSTANCE.getField(property, name);
            collection.add(object);
        }
        List fields = (List)destination$iv$iv2;
        return new CompositeType(this.getAmqpTypeName($receiver), null, provides, new Descriptor(typeDescriptor2, null, 2, null), fields);
    }

    /*
     * WARNING - void declaration
     */
    private final Field getField(@NotNull LocalPropertyInformation $receiver, String name) {
        void typeName2;
        LocalTypeInformation localTypeInformation = $receiver.getType();
        Pair pair = localTypeInformation instanceof LocalTypeInformation.AnInterface || localTypeInformation instanceof LocalTypeInformation.ACollection || localTypeInformation instanceof LocalTypeInformation.AMap ? TuplesKt.to((Object)"*", (Object)CollectionsKt.listOf((Object)this.getAmqpTypeName($receiver.getType()))) : TuplesKt.to((Object)this.getAmqpTypeName($receiver.getType()), (Object)CollectionsKt.emptyList());
        String string = (String)pair.component1();
        List requires = (List)pair.component2();
        String defaultValue = defaultValues.get($receiver.getType().getTypeIdentifier());
        return new Field(name, (String)typeName2, requires, defaultValue, null, $receiver.isMandatory(), false);
    }

    private TypeNotationGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        TypeNotationGenerator typeNotationGenerator;
        INSTANCE = typeNotationGenerator = new TypeNotationGenerator();
        Sequence $receiver$iv = SequencesKt.sequenceOf((Object[])new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)"false"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Byte.TYPE), (Object)"0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)"0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Character.TYPE), (Object)"&#0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Short.TYPE), (Object)"0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)"0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Float.TYPE), (Object)"0"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Double.TYPE), (Object)"0")});
        Sequence sequence = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            Pair $type_value = (Pair)element$iv$iv;
            KClass type = (KClass)$type_value.component1();
            String value = (String)$type_value.component2();
            Class clazz = JvmClassMappingKt.getJavaPrimitiveType((KClass)type);
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            Pair pair = TuplesKt.to((Object)TypeIdentifier.Companion.forClass(clazz), (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        defaultValues = var3_3;
    }
}

