/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.corda.core.KeepForDJVM;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationEncoding;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.serialization.internal.ByteBufferOutputStream;
import net.corda.serialization.internal.ByteBufferStreams;
import net.corda.serialization.internal.CordaSerializationEncoding;
import net.corda.serialization.internal.SectionId;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.AMQPStreams;
import net.corda.serialization.internal.amqp.BytesAndSchemas;
import net.corda.serialization.internal.amqp.Envelope;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.ReferencedObject;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.TransformsSchema;
import net.corda.serialization.internal.amqp.TypeNotation;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0017\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b\u001fJ+\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0018J+\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00130\"\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010#J7\u0010$\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010'\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b(J%\u0010$\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b(J7\u0010)\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&H\u0016J#\u00101\u001a\u0002022\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n04\"\u00020\nH\u0010\u00a2\u0006\u0004\b5\u00106R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lnet/corda/serialization/internal/amqp/SerializationOutput;", "", "serializerFactory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "(Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;)V", "objectHistory", "", "", "schemaHistory", "", "Lnet/corda/serialization/internal/amqp/TypeNotation;", "getSchemaHistory$serialization", "()Ljava/util/Set;", "getSerializerFactory$serialization", "()Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "serializerHistory", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "_serialize", "Lnet/corda/core/serialization/SerializedBytes;", "T", "obj", "context", "Lnet/corda/core/serialization/SerializationContext;", "_serialize$serialization", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "andFinally", "", "andFinally$serialization", "requireSerializer", "type", "Ljava/lang/reflect/Type;", "requireSerializer$serialization", "serialize", "serializeAndReturnSchema", "Lnet/corda/serialization/internal/amqp/BytesAndSchemas;", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/serialization/internal/amqp/BytesAndSchemas;", "writeObject", "data", "Lorg/apache/qpid/proton/codec/Data;", "debugIndent", "writeObject$serialization", "writeObjectOrNull", "writeObjectOrNull$serialization", "writeSchema", "schema", "Lnet/corda/serialization/internal/amqp/Schema;", "writeTransformSchema", "transformsSchema", "Lnet/corda/serialization/internal/amqp/TransformsSchema;", "writeTypeNotations", "", "typeNotation", "", "writeTypeNotations$serialization", "([Lnet/corda/serialization/internal/amqp/TypeNotation;)Z", "Companion", "serialization"})
@KeepForDJVM
public class SerializationOutput {
    private final Map<Object, Integer> objectHistory;
    private final Set<AMQPSerializer<?>> serializerHistory;
    @NotNull
    private final Set<TypeNotation> schemaHistory;
    @NotNull
    private final LocalSerializerFactory serializerFactory;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final Set<TypeNotation> getSchemaHistory$serialization() {
        return this.schemaHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            SerializedBytes<T> serializedBytes = this._serialize$serialization(obj, context);
            return serializedBytes;
        }
        catch (AMQPNotSerializableException amqp) {
            amqp.log("Serialize", logger);
            throw (Throwable)new NotSerializableException(amqp.getMitigation());
        }
        finally {
            this.andFinally$serialization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> BytesAndSchemas<T> serializeAndReturnSchema(@NotNull T obj, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            SerializedBytes<T> blob = this._serialize$serialization(obj, context);
            Schema schema = new Schema(CollectionsKt.toList((Iterable)this.schemaHistory));
            BytesAndSchemas<T> bytesAndSchemas = new BytesAndSchemas<T>(blob, schema, TransformsSchema.Companion.build(schema, this.serializerFactory));
            return bytesAndSchemas;
        }
        finally {
            this.andFinally$serialization();
        }
    }

    public final void andFinally$serialization() {
        this.objectHistory.clear();
        this.serializerHistory.clear();
        this.schemaHistory.clear();
    }

    @NotNull
    public final <T> SerializedBytes<T> _serialize$serialization(@NotNull T obj, @NotNull SerializationContext context) {
        Data data;
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Data data2 = data = Data.Factory.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"data");
        SerializationHelperKt.withDescribed(data2, Envelope.Companion.getDESCRIPTOR_OBJECT(), (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(this, obj, context){
            final /* synthetic */ SerializationOutput this$0;
            final /* synthetic */ Object $obj;
            final /* synthetic */ SerializationContext $context;

            public final void invoke(@NotNull Data $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                SerializationHelperKt.withList($receiver, (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(this){
                    final /* synthetic */ _serialize.1 this$0;

                    public final void invoke(@NotNull Data $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        this.this$0.this$0.writeObject$serialization(this.this$0.$obj, $receiver, this.this$0.$context);
                        Schema schema = new Schema(CollectionsKt.toList((Iterable)this.this$0.this$0.getSchemaHistory$serialization()));
                        this.this$0.this$0.writeSchema(schema, $receiver);
                        this.this$0.this$0.writeTransformSchema(TransformsSchema.Companion.build(schema, this.this$0.this$0.getSerializerFactory$serialization()), $receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = serializationOutput;
                this.$obj = object;
                this.$context = serializationContext;
                super(1);
            }
        }));
        return new SerializedBytes(ByteBufferStreams.byteArrayOutput((Function1)new Function1<ByteBufferOutputStream, Long>(context, data){
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ Data $data;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final long invoke(@NotNull ByteBufferOutputStream it) {
                long l;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                try (OutputStream stream = it;){
                    SchemaKt.getAmqpMagic().writeTo(stream);
                    SerializationEncoding encoding = this.$context.getEncoding();
                    if (encoding != null) {
                        SectionId.ENCODING.writeTo(stream);
                        ((CordaSerializationEncoding)encoding).writeTo(stream);
                        stream = ((CordaSerializationEncoding)encoding).wrap(stream);
                    }
                    SectionId.DATA_AND_STOP.writeTo(stream);
                    l = ((Number)AMQPStreams.alsoAsByteBuffer(stream, (int)this.$data.encodedSize(), (Function1)new Function1<ByteBuffer, Long>(this.$data){

                        public final long invoke(ByteBuffer p1) {
                            return ((Data)this.receiver).encode(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Data.class);
                        }

                        public final String getName() {
                            return "encode";
                        }

                        public final String getSignature() {
                            return "encode(Ljava/nio/ByteBuffer;)J";
                        }
                    })).longValue();
                }
                return l;
            }
            {
                this.$context = serializationContext;
                this.$data = data;
                super(1);
            }
        }));
    }

    public final void writeObject$serialization(@NotNull Object obj, @NotNull Data data, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializationOutput.writeObject$serialization$default(this, obj, data, obj.getClass(), context, 0, 16, null);
    }

    public void writeSchema(@NotNull Schema schema, @NotNull Data data) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        data.putObject((Object)schema);
    }

    public void writeTransformSchema(@NotNull TransformsSchema transformsSchema, @NotNull Data data) {
        Intrinsics.checkParameterIsNotNull((Object)transformsSchema, (String)"transformsSchema");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        data.putObject((Object)transformsSchema);
    }

    public final void writeObjectOrNull$serialization(@Nullable Object obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationContext context, int debugIndent) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (obj == null) {
            data.putNull();
        } else {
            this.writeObject$serialization(obj, data, Intrinsics.areEqual((Object)type, (Object)TypeIdentifier.getLocalType$default(TypeIdentifier.UnknownType.INSTANCE, null, 1, null)) ? (Type)obj.getClass() : type, context, debugIndent);
        }
    }

    public final void writeObject$serialization(@NotNull Object obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationContext context, int debugIndent) {
        Integer retrievedRefCount;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AMQPSerializer<Object> serializer2 = this.serializerFactory.get(obj.getClass(), type);
        if (!this.serializerHistory.contains(serializer2)) {
            this.serializerHistory.add(serializer2);
            serializer2.writeClassInfo(this);
        }
        if ((retrievedRefCount = this.objectHistory.get(obj)) == null) {
            serializer2.writeObject(obj, data, type, this, context, debugIndent);
            if (this.serializerFactory.isSuitableForObjectReference(obj.getClass())) {
                Map<Object, Integer> map = this.objectHistory;
                Integer n = this.objectHistory.size();
                map.put(obj, n);
            }
        } else {
            SerializationHelperKt.writeReferencedObject(data, new ReferencedObject(retrievedRefCount));
        }
    }

    public static /* bridge */ /* synthetic */ void writeObject$serialization$default(SerializationOutput serializationOutput, Object object, Data data, Type type, SerializationContext serializationContext, int n, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeObject");
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        serializationOutput.writeObject$serialization(object, data, type, serializationContext, n);
    }

    public boolean writeTypeNotations$serialization(TypeNotation ... typeNotation2) {
        Intrinsics.checkParameterIsNotNull((Object)typeNotation2, (String)"typeNotation");
        return CollectionsKt.addAll((Collection)this.schemaHistory, (Object[])typeNotation2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requireSerializer$serialization(@NotNull Type type) {
        Type resolvedType;
        Type type2;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!(Intrinsics.areEqual((Object)type, Object.class) ^ true) || !(Intrinsics.areEqual((Object)type.getTypeName(), (Object)"?") ^ true)) return;
        Type type3 = type;
        if (type3 instanceof WildcardType) {
            if (((WildcardType)type).getUpperBounds().length != 1) throw (Throwable)new NotSerializableException("Cannot obtain upper bound for type " + type);
            type2 = ((WildcardType)type).getUpperBounds()[0];
        } else {
            type2 = type;
        }
        Type type4 = resolvedType = type2;
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"resolvedType");
        AMQPSerializer<Object> serializer2 = this.serializerFactory.get(type4);
        if (this.serializerHistory.contains(serializer2)) return;
        this.serializerHistory.add(serializer2);
        serializer2.writeClassInfo(this);
    }

    @NotNull
    public final LocalSerializerFactory getSerializerFactory$serialization() {
        return this.serializerFactory;
    }

    public SerializationOutput(@NotNull LocalSerializerFactory serializerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)serializerFactory, (String)"serializerFactory");
        this.serializerFactory = serializerFactory;
        this.objectHistory = new IdentityHashMap();
        this.serializerHistory = new LinkedHashSet();
        this.schemaHistory = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/SerializationOutput$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

