/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.PropertyDescriptorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/PropertyDescriptor;", "", "field", "Ljava/lang/reflect/Field;", "setter", "Ljava/lang/reflect/Method;", "getter", "(Ljava/lang/reflect/Field;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "getField", "()Ljava/lang/reflect/Field;", "getGetter", "()Ljava/lang/reflect/Method;", "getSetter", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "validate", "", "serialization"})
@KeepForDJVM
public final class PropertyDescriptor {
    @Nullable
    private final Field field;
    @Nullable
    private final Method setter;
    @Nullable
    private final Method getter;

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $receiver;
        StringBuilder stringBuilder2 = $receiver = (stringBuilder = new StringBuilder(""));
        StringBuilder stringBuilder3 = new StringBuilder().append("Property - ");
        Object object = this.field;
        if (object == null || (object = ((Field)object).getName()) == null) {
            object = "null field";
        }
        String string = stringBuilder3.append((String)object).append('\n').toString();
        StringBuilder stringBuilder4 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        stringBuilder2 = $receiver;
        StringBuilder stringBuilder5 = new StringBuilder().append("  getter - ");
        Object object2 = this.getter;
        if (object2 == null || (object2 = ((Method)object2).getName()) == null) {
            object2 = "no getter";
        }
        string = stringBuilder5.append((String)object2).toString();
        StringBuilder stringBuilder6 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        stringBuilder2 = $receiver;
        StringBuilder stringBuilder7 = new StringBuilder().append("  setter - ");
        Object object3 = this.setter;
        if (object3 == null || (object3 = ((Method)object3).getName()) == null) {
            object3 = "no setter";
        }
        string = stringBuilder7.append((String)object3).toString();
        StringBuilder stringBuilder8 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder8);
        return stringBuilder.toString();
    }

    public final void validate() {
        Method $receiver;
        Method method;
        Method method2 = this.getter;
        if (method2 != null) {
            $receiver = method = method2;
            Field field = this.field;
            if (field != null) {
                Field field2;
                Field $receiver2 = field2 = field;
                Class<?> clazz = this.getter.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"getter.returnType");
                Class<?> clazz2 = this.field.getType();
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"field.type");
                if (!PropertyDescriptorKt.access$boxesOrIsAssignableFrom(clazz, clazz2)) {
                    Class<?> clazz3 = $receiver2.getDeclaringClass();
                    Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"declaringClass");
                    throw (Throwable)new AMQPNotSerializableException(clazz3, "Defined getter for parameter " + $receiver2.getName() + " returns type " + this.getter.getReturnType() + ' ' + "yet underlying type is " + $receiver2.getGenericType(), null, null, 12, null);
                }
            }
        }
        Method method3 = this.setter;
        if (method3 != null) {
            Field $receiver3;
            AccessibleObject accessibleObject;
            $receiver = method = method3;
            Class<?> clazz = this.setter.getParameterTypes()[0];
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            Class<?> setterType = clazz;
            Field field = this.field;
            if (field != null) {
                $receiver3 = accessibleObject = field;
                Class<?> clazz4 = this.field.getType();
                Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"field.type");
                if (!PropertyDescriptorKt.access$boxesOrIsAssignableFrom(clazz4, setterType)) {
                    Class<?> clazz5 = $receiver3.getDeclaringClass();
                    Intrinsics.checkExpressionValueIsNotNull(clazz5, (String)"declaringClass");
                    throw (Throwable)new AMQPNotSerializableException(clazz5, "Defined setter for parameter " + $receiver3.getName() + " takes parameter of type " + setterType + ' ' + "yet underlying type is " + $receiver3.getGenericType(), null, null, 12, null);
                }
            }
            Method method4 = this.getter;
            if (method4 != null) {
                $receiver3 = accessibleObject = method4;
                Class<?> clazz6 = this.getter.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull(clazz6, (String)"getter.returnType");
                if (!PropertyDescriptorKt.access$boxesOrIsAssignableFrom(clazz6, setterType)) {
                    Class<?> clazz7 = ((Method)((Object)$receiver3)).getDeclaringClass();
                    Intrinsics.checkExpressionValueIsNotNull(clazz7, (String)"declaringClass");
                    throw (Throwable)new AMQPNotSerializableException(clazz7, "Defined setter for parameter " + ((Method)((Object)$receiver3)).getName() + " takes parameter of type " + setterType + ", " + "but getter returns " + ((Method)((Object)$receiver3)).getGenericReturnType(), null, null, 12, null);
                }
            }
        }
    }

    @Nullable
    public final Field getField() {
        return this.field;
    }

    @Nullable
    public final Method getSetter() {
        return this.setter;
    }

    @Nullable
    public final Method getGetter() {
        return this.getter;
    }

    public PropertyDescriptor(@Nullable Field field, @Nullable Method setter, @Nullable Method getter) {
        this.field = field;
        this.setter = setter;
        this.getter = getter;
    }

    @Nullable
    public final Field component1() {
        return this.field;
    }

    @Nullable
    public final Method component2() {
        return this.setter;
    }

    @Nullable
    public final Method component3() {
        return this.getter;
    }

    @NotNull
    public final PropertyDescriptor copy(@Nullable Field field, @Nullable Method setter, @Nullable Method getter) {
        return new PropertyDescriptor(field, setter, getter);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PropertyDescriptor copy$default(PropertyDescriptor propertyDescriptor, Field field, Method method, Method method2, int n, Object object) {
        if ((n & 1) != 0) {
            field = propertyDescriptor.field;
        }
        if ((n & 2) != 0) {
            method = propertyDescriptor.setter;
        }
        if ((n & 4) != 0) {
            method2 = propertyDescriptor.getter;
        }
        return propertyDescriptor.copy(field, method, method2);
    }

    public int hashCode() {
        Field field = this.field;
        Method method = this.setter;
        Method method2 = this.getter;
        return ((field != null ? ((Object)field).hashCode() : 0) * 31 + (method != null ? ((Object)method).hashCode() : 0)) * 31 + (method2 != null ? ((Object)method2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PropertyDescriptor)) break block3;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
                if (!Intrinsics.areEqual((Object)this.field, (Object)propertyDescriptor.field) || !Intrinsics.areEqual((Object)this.setter, (Object)propertyDescriptor.setter) || !Intrinsics.areEqual((Object)this.getter, (Object)propertyDescriptor.getter)) break block3;
            }
            return true;
        }
        return false;
    }
}

