/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.internal.MissingSerializerException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.AbstractObjectSerializer;
import net.corda.serialization.internal.amqp.ComposableObjectReader;
import net.corda.serialization.internal.amqp.ComposableObjectSerializer;
import net.corda.serialization.internal.amqp.ComposableObjectWriter;
import net.corda.serialization.internal.amqp.ComposableTypePropertySerializer;
import net.corda.serialization.internal.amqp.CompositeType;
import net.corda.serialization.internal.amqp.Field;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.ObjectBuilder;
import net.corda.serialization.internal.amqp.PropertySerializer;
import net.corda.serialization.internal.amqp.TypeNotationGenerator;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/ObjectSerializer;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "fields", "", "Lnet/corda/serialization/internal/amqp/Field;", "getFields", "()Ljava/util/List;", "propertySerializers", "", "", "Lnet/corda/serialization/internal/amqp/PropertySerializer;", "getPropertySerializers", "()Ljava/util/Map;", "Companion", "serialization"})
public interface ObjectSerializer
extends AMQPSerializer<Object> {
    public static final Companion Companion = net.corda.serialization.internal.amqp.ObjectSerializer$Companion.$$INSTANCE;

    @NotNull
    public Map<String, PropertySerializer> getPropertySerializers();

    @NotNull
    public List<Field> getFields();

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u00060\u0014j\u0002`\u0017\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lnet/corda/serialization/internal/amqp/ObjectSerializer$Companion;", "", "()V", "make", "Lnet/corda/serialization/internal/amqp/ObjectSerializer;", "typeInformation", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "factory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "makeForAbstract", "Lnet/corda/serialization/internal/amqp/AbstractObjectSerializer;", "typeNotation", "Lnet/corda/serialization/internal/amqp/CompositeType;", "typeDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "makeForComposable", "Lnet/corda/serialization/internal/amqp/ComposableObjectSerializer;", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Composable;", "makePropertySerializers", "", "", "Lnet/corda/serialization/internal/amqp/PropertySerializer;", "properties", "Lnet/corda/serialization/internal/model/PropertyName;", "Lnet/corda/serialization/internal/model/LocalPropertyInformation;", "nonComposableExceptionMessage", "Lnet/corda/serialization/internal/model/LocalTypeInformation$NonComposable;", "serialization"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ObjectSerializer make(@NotNull LocalTypeInformation typeInformation, @NotNull LocalSerializerFactory factory) {
            ObjectSerializer objectSerializer;
            Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            if (typeInformation instanceof LocalTypeInformation.NonComposable) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)((LocalTypeInformation.NonComposable)typeInformation).getNonComposableTypes();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    LocalTypeInformation.NonComposable nonComposable = (LocalTypeInformation.NonComposable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = it.getObservedType().getTypeName();
                    collection.add(string);
                }
                List typeNames = (List)destination$iv$iv;
                throw (Throwable)new MissingSerializerException(this.nonComposableExceptionMessage((LocalTypeInformation.NonComposable)typeInformation, factory), typeNames);
            }
            Symbol typeDescriptor2 = factory.createDescriptor(typeInformation);
            CompositeType typeNotation2 = TypeNotationGenerator.INSTANCE.getTypeNotation(typeInformation, typeDescriptor2);
            LocalTypeInformation localTypeInformation = typeInformation;
            if (localTypeInformation instanceof LocalTypeInformation.Composable) {
                objectSerializer = this.makeForComposable((LocalTypeInformation.Composable)typeInformation, typeNotation2, typeDescriptor2, factory);
            } else if (localTypeInformation instanceof LocalTypeInformation.AnInterface || localTypeInformation instanceof LocalTypeInformation.Abstract) {
                objectSerializer = this.makeForAbstract(typeNotation2, typeInformation, typeDescriptor2, factory);
            } else {
                throw (Throwable)new NotSerializableException("Cannot build object serializer for " + typeInformation);
            }
            return objectSerializer;
        }

        /*
         * WARNING - void declaration
         */
        private final String nonComposableExceptionMessage(LocalTypeInformation.NonComposable typeInformation, LocalSerializerFactory factory) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)factory.getCustomSerializerNames();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string2 = "Serializer: " + (String)it;
                collection.add(string2);
            }
            List list = (List)destination$iv$iv;
            List serializers = list;
            Collection collection = serializers;
            String serializerInformation = !collection.isEmpty() ? "Registered custom serializers:\n    " + CollectionsKt.joinToString$default((Iterable)serializers, (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null) : "No custom serializers registered.";
            return "Unable to create an object serializer for type " + typeInformation.getObservedType() + ":\n" + typeInformation.getReason() + "\n\n" + typeInformation.getRemedy() + "\n\n" + serializerInformation + '\n';
        }

        private final AbstractObjectSerializer makeForAbstract(CompositeType typeNotation2, LocalTypeInformation typeInformation, Symbol typeDescriptor2, LocalSerializerFactory factory) {
            Map<String, PropertySerializer> propertySerializers = this.makePropertySerializers(typeInformation.getPropertiesOrEmptyMap(), factory);
            ComposableObjectWriter writer = new ComposableObjectWriter(typeNotation2, typeInformation.getInterfacesOrEmptyList(), propertySerializers);
            return new AbstractObjectSerializer(typeInformation.getObservedType(), typeDescriptor2, propertySerializers, typeNotation2.getFields(), writer);
        }

        private final ComposableObjectSerializer makeForComposable(LocalTypeInformation.Composable typeInformation, CompositeType typeNotation2, Symbol typeDescriptor2, LocalSerializerFactory factory) {
            Map<String, PropertySerializer> propertySerializers = this.makePropertySerializers(typeInformation.getProperties(), factory);
            ComposableObjectReader reader = new ComposableObjectReader(typeInformation.getTypeIdentifier(), propertySerializers, (Function0<? extends ObjectBuilder>)((Function0)ObjectBuilder.Companion.makeProvider(typeInformation)));
            ComposableObjectWriter writer = new ComposableObjectWriter(typeNotation2, typeInformation.getInterfaces(), propertySerializers);
            return new ComposableObjectSerializer(typeInformation.getObservedType(), typeDescriptor2, propertySerializers, typeNotation2.getFields(), reader, writer);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, PropertySerializer> makePropertySerializers(Map<String, ? extends LocalPropertyInformation> properties2, LocalSerializerFactory factory) {
            void $receiver$iv$iv;
            Map<String, ? extends LocalPropertyInformation> $receiver$iv;
            Map<String, ? extends LocalPropertyInformation> map = $receiver$iv = properties2;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void $name_property;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map3 = map2;
                void var13_13 = $name_property;
                String name = (String)var13_13.getKey();
                var13_13 = $name_property;
                LocalPropertyInformation property = (LocalPropertyInformation)var13_13.getValue();
                PropertySerializer propertySerializer = ComposableTypePropertySerializer.Companion.make(name, property, factory);
                map3.put(k2, propertySerializer);
            }
            return destination$iv$iv;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

