/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.EvolutionSerializerFactory;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.RemoteTypeInformation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R(\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/NoEvolutionSerializerFactory;", "Lnet/corda/serialization/internal/amqp/EvolutionSerializerFactory;", "()V", "primitiveTypes", "", "Ljava/lang/Class;", "getPrimitiveTypes", "()Ljava/util/Map;", "getEvolutionSerializer", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "remote", "Lnet/corda/serialization/internal/model/RemoteTypeInformation;", "local", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "serialization"})
public final class NoEvolutionSerializerFactory
implements EvolutionSerializerFactory {
    @NotNull
    private static final Map<Class<?>, Class<?>> primitiveTypes;
    public static final NoEvolutionSerializerFactory INSTANCE;

    @Override
    @NotNull
    public AMQPSerializer<Object> getEvolutionSerializer(@NotNull RemoteTypeInformation remote, @NotNull LocalTypeInformation local) {
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
        throw (Throwable)new NotSerializableException("\nEvolution not permitted.\n\nRemote:\n" + remote.prettyPrint(false) + "\n\nLocal:\n" + local.prettyPrint(false) + "\n        ");
    }

    @Override
    @NotNull
    public Map<Class<?>, Class<?>> getPrimitiveTypes() {
        return primitiveTypes;
    }

    private NoEvolutionSerializerFactory() {
    }

    static {
        NoEvolutionSerializerFactory noEvolutionSerializerFactory;
        INSTANCE = noEvolutionSerializerFactory = new NoEvolutionSerializerFactory();
        primitiveTypes = MapsKt.emptyMap();
    }
}

