/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.StubOutForDJVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0003*D\b\u0002\u0010\u0006\"\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00072\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007\u00a8\u0006\t"}, d2={"checkDictionary", "", "Ljava/lang/Class;", "checkHashMap", "checkSupportedMapType", "checkWeakHashMap", "MapCreationFunction", "Lkotlin/Function1;", "", "serialization"})
public final class MapSerializerKt {
    public static final void checkSupportedMapType(@NotNull Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        MapSerializerKt.checkHashMap($receiver);
        MapSerializerKt.checkWeakHashMap($receiver);
        MapSerializerKt.checkDictionary($receiver);
    }

    private static final void checkHashMap(@NotNull Class<?> $receiver) {
        if (HashMap.class.isAssignableFrom($receiver) && !LinkedHashMap.class.isAssignableFrom($receiver)) {
            throw (Throwable)new IllegalArgumentException("Map type " + $receiver + " is unstable under iteration. Suggested fix: use java.util.LinkedHashMap instead.");
        }
    }

    @StubOutForDJVM
    private static final void checkWeakHashMap(@NotNull Class<?> $receiver) {
        if (WeakHashMap.class.isAssignableFrom($receiver)) {
            throw (Throwable)new IllegalArgumentException("Weak references with map types not supported. Suggested fix: use java.util.LinkedHashMap instead.");
        }
    }

    private static final void checkDictionary(@NotNull Class<?> $receiver) {
        if (Dictionary.class.isAssignableFrom($receiver)) {
            throw (Throwable)new IllegalArgumentException("Unable to serialise deprecated type " + $receiver + ". Suggested fix: prefer java.util.map implementations");
        }
    }
}

