/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.AMQPDescriptorRegistry;
import net.corda.serialization.internal.amqp.AMQPNoTypeNotSerializableException;
import net.corda.serialization.internal.amqp.Descriptor;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.TransformsSchema;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lnet/corda/serialization/internal/amqp/Envelope;", "Lorg/apache/qpid/proton/amqp/DescribedType;", "obj", "", "schema", "Lnet/corda/serialization/internal/amqp/Schema;", "transformsSchema", "Lnet/corda/serialization/internal/amqp/TransformsSchema;", "(Ljava/lang/Object;Lnet/corda/serialization/internal/amqp/Schema;Lnet/corda/serialization/internal/amqp/TransformsSchema;)V", "getObj", "()Ljava/lang/Object;", "getSchema", "()Lnet/corda/serialization/internal/amqp/Schema;", "getTransformsSchema", "()Lnet/corda/serialization/internal/amqp/TransformsSchema;", "component1", "component2", "component3", "copy", "equals", "", "other", "getDescribed", "getDescriptor", "hashCode", "", "toString", "", "Companion", "serialization"})
@KeepForDJVM
public final class Envelope
implements DescribedType {
    @Nullable
    private final Object obj;
    @NotNull
    private final Schema schema;
    @NotNull
    private final TransformsSchema transformsSchema;
    @NotNull
    private static final UnsignedLong DESCRIPTOR;
    @NotNull
    private static final Descriptor DESCRIPTOR_OBJECT;
    private static final int ENVELOPE_WITHOUT_TRANSFORMS = 2;
    private static final int ENVELOPE_WITH_TRANSFORMS = 3;
    private static final int BLOB_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int TRANSFORMS_SCHEMA_IDX = 2;
    public static final Companion Companion;

    @NotNull
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @NotNull
    public Object getDescribed() {
        return CollectionsKt.listOf((Object[])new Object[]{this.obj, this.schema, this.transformsSchema});
    }

    @Nullable
    public final Object getObj() {
        return this.obj;
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final TransformsSchema getTransformsSchema() {
        return this.transformsSchema;
    }

    public Envelope(@Nullable Object obj, @NotNull Schema schema, @NotNull TransformsSchema transformsSchema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)transformsSchema, (String)"transformsSchema");
        this.obj = obj;
        this.schema = schema;
        this.transformsSchema = transformsSchema;
    }

    static {
        Companion = new Companion(null);
        DESCRIPTOR = AMQPDescriptorRegistry.ENVELOPE.getAmqpDescriptor();
        DESCRIPTOR_OBJECT = new Descriptor(null, DESCRIPTOR);
    }

    @Nullable
    public final Object component1() {
        return this.obj;
    }

    @NotNull
    public final Schema component2() {
        return this.schema;
    }

    @NotNull
    public final TransformsSchema component3() {
        return this.transformsSchema;
    }

    @NotNull
    public final Envelope copy(@Nullable Object obj, @NotNull Schema schema, @NotNull TransformsSchema transformsSchema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)transformsSchema, (String)"transformsSchema");
        return new Envelope(obj, schema, transformsSchema);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Envelope copy$default(Envelope envelope, Object object, Schema schema, TransformsSchema transformsSchema, int n, Object object2) {
        if ((n & 1) != 0) {
            object = envelope.obj;
        }
        if ((n & 2) != 0) {
            schema = envelope.schema;
        }
        if ((n & 4) != 0) {
            transformsSchema = envelope.transformsSchema;
        }
        return envelope.copy(object, schema, transformsSchema);
    }

    @NotNull
    public String toString() {
        return "Envelope(obj=" + this.obj + ", schema=" + this.schema + ", transformsSchema=" + this.transformsSchema + ")";
    }

    public int hashCode() {
        Object object = this.obj;
        Schema schema = this.schema;
        TransformsSchema transformsSchema = this.transformsSchema;
        return ((object != null ? object.hashCode() : 0) * 31 + (schema != null ? ((Object)schema).hashCode() : 0)) * 31 + (transformsSchema != null ? ((Object)transformsSchema).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Envelope)) break block3;
                Envelope envelope = (Envelope)object;
                if (!Intrinsics.areEqual((Object)this.obj, (Object)envelope.obj) || !Intrinsics.areEqual((Object)this.schema, (Object)envelope.schema) || !Intrinsics.areEqual((Object)this.transformsSchema, (Object)envelope.transformsSchema)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/Envelope$Companion;", "Lorg/apache/qpid/proton/codec/DescribedTypeConstructor;", "Lnet/corda/serialization/internal/amqp/Envelope;", "()V", "BLOB_IDX", "", "DESCRIPTOR", "Lorg/apache/qpid/proton/amqp/UnsignedLong;", "getDESCRIPTOR", "()Lorg/apache/qpid/proton/amqp/UnsignedLong;", "DESCRIPTOR_OBJECT", "Lnet/corda/serialization/internal/amqp/Descriptor;", "getDESCRIPTOR_OBJECT", "()Lnet/corda/serialization/internal/amqp/Descriptor;", "ENVELOPE_WITHOUT_TRANSFORMS", "ENVELOPE_WITH_TRANSFORMS", "SCHEMA_IDX", "TRANSFORMS_SCHEMA_IDX", "get", "data", "Lorg/apache/qpid/proton/codec/Data;", "getTypeClass", "Ljava/lang/Class;", "newInstance", "described", "", "serialization"})
    public static final class Companion
    implements DescribedTypeConstructor<Envelope> {
        @NotNull
        public final UnsignedLong getDESCRIPTOR() {
            return DESCRIPTOR;
        }

        @NotNull
        public final Descriptor getDESCRIPTOR_OBJECT() {
            return DESCRIPTOR_OBJECT;
        }

        @NotNull
        public final Envelope get(@NotNull Data data) {
            Object v2;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Object object = data.getObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.amqp.DescribedType");
            }
            DescribedType describedType = (DescribedType)object;
            if (Intrinsics.areEqual((Object)describedType.getDescriptor(), (Object)this.getDESCRIPTOR()) ^ true) {
                throw (Throwable)new AMQPNoTypeNotSerializableException("Unexpected descriptor " + describedType.getDescriptor() + ", should be " + this.getDESCRIPTOR() + '.', null, 2, null);
            }
            Object object2 = describedType.getDescribed();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List list = (List)object2;
            switch (list.size()) {
                case 2: {
                    v2 = null;
                    break;
                }
                case 3: {
                    v2 = list.get(2);
                    break;
                }
                default: {
                    throw (Throwable)new AMQPNoTypeNotSerializableException("Malformed list, bad length of " + list.size() + " (should be 2 or 3)", null, 2, null);
                }
            }
            Object transformSchema = v2;
            Object[] objectArray = new Object[3];
            objectArray[0] = list.get(0);
            Object e = list.get(1);
            if (e == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = Schema.Companion.get(e);
            objectArray[2] = TransformsSchema.Companion.newInstance(transformSchema);
            return this.newInstance(CollectionsKt.listOf((Object[])objectArray));
        }

        @NotNull
        public Envelope newInstance(@Nullable Object described) {
            TransformsSchema transformsSchema;
            Object object = described;
            if (!(object instanceof List)) {
                object = null;
            }
            List list = (List)object;
            if (list == null) {
                throw (Throwable)new IllegalStateException("Was expecting a list");
            }
            List list2 = list;
            switch (list2.size()) {
                case 2: {
                    transformsSchema = TransformsSchema.Companion.newInstance(null);
                    break;
                }
                case 3: {
                    Object e = list2.get(2);
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.TransformsSchema");
                    }
                    transformsSchema = (TransformsSchema)e;
                    break;
                }
                default: {
                    throw (Throwable)new AMQPNoTypeNotSerializableException("Malformed list, bad length of " + list2.size() + " (should be 2 or 3)", null, 2, null);
                }
            }
            TransformsSchema transformSchema = transformsSchema;
            Object e = list2.get(1);
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.amqp.Schema");
            }
            return new Envelope(list2.get(0), (Schema)e, transformSchema);
        }

        @NotNull
        public Class<?> getTypeClass() {
            return Envelope.class;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

