/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.AMQPDescriptorRegistry;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/Descriptor;", "Lorg/apache/qpid/proton/amqp/DescribedType;", "name", "", "(Ljava/lang/String;)V", "Lorg/apache/qpid/proton/amqp/Symbol;", "code", "Lorg/apache/qpid/proton/amqp/UnsignedLong;", "(Lorg/apache/qpid/proton/amqp/Symbol;Lorg/apache/qpid/proton/amqp/UnsignedLong;)V", "getCode", "()Lorg/apache/qpid/proton/amqp/UnsignedLong;", "getName", "()Lorg/apache/qpid/proton/amqp/Symbol;", "component1", "component2", "copy", "equals", "", "other", "", "getDescribed", "getDescriptor", "hashCode", "", "toString", "Companion", "serialization"})
@KeepForDJVM
public final class Descriptor
implements DescribedType {
    @Nullable
    private final Symbol name;
    @Nullable
    private final UnsignedLong code;
    @NotNull
    private static final UnsignedLong DESCRIPTOR;
    public static final Companion Companion;

    @NotNull
    public Object getDescriptor() {
        return DESCRIPTOR;
    }

    @NotNull
    public Object getDescribed() {
        return CollectionsKt.listOf((Object[])new Comparable[]{(Comparable)this.name, (Comparable)this.code});
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("<descriptor");
        if (this.name != null) {
            sb.append(" name=\"" + this.name + '\"');
        }
        if (this.code != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "0x%08x:0x%08x";
            Object[] objectArray = new Object[]{this.code.longValue() >> 32, this.code.longValue() & 0xFFFFL};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String code = string2;
            sb.append(" code=\"" + code + '\"');
        }
        sb.append("/>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Nullable
    public final Symbol getName() {
        return this.name;
    }

    @Nullable
    public final UnsignedLong getCode() {
        return this.code;
    }

    public Descriptor(@Nullable Symbol name, @Nullable UnsignedLong code) {
        this.name = name;
        this.code = code;
    }

    public /* synthetic */ Descriptor(Symbol symbol, UnsignedLong unsignedLong, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            unsignedLong = null;
        }
        this(symbol, unsignedLong);
    }

    public Descriptor(@Nullable String name) {
        this(Symbol.valueOf((String)name), null, 2, null);
    }

    static {
        Companion = new Companion(null);
        DESCRIPTOR = AMQPDescriptorRegistry.OBJECT_DESCRIPTOR.getAmqpDescriptor();
    }

    @Nullable
    public final Symbol component1() {
        return this.name;
    }

    @Nullable
    public final UnsignedLong component2() {
        return this.code;
    }

    @NotNull
    public final Descriptor copy(@Nullable Symbol name, @Nullable UnsignedLong code) {
        return new Descriptor(name, code);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Descriptor copy$default(Descriptor descriptor, Symbol symbol, UnsignedLong unsignedLong, int n, Object object) {
        if ((n & 1) != 0) {
            symbol = descriptor.name;
        }
        if ((n & 2) != 0) {
            unsignedLong = descriptor.code;
        }
        return descriptor.copy(symbol, unsignedLong);
    }

    public int hashCode() {
        Symbol symbol = this.name;
        UnsignedLong unsignedLong = this.code;
        return (symbol != null ? symbol.hashCode() : 0) * 31 + (unsignedLong != null ? unsignedLong.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Descriptor)) break block3;
                Descriptor descriptor = (Descriptor)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)descriptor.name) || !Intrinsics.areEqual((Object)this.code, (Object)descriptor.code)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0012\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/Descriptor$Companion;", "Lorg/apache/qpid/proton/codec/DescribedTypeConstructor;", "Lnet/corda/serialization/internal/amqp/Descriptor;", "()V", "DESCRIPTOR", "Lorg/apache/qpid/proton/amqp/UnsignedLong;", "getDESCRIPTOR", "()Lorg/apache/qpid/proton/amqp/UnsignedLong;", "get", "obj", "", "getTypeClass", "Ljava/lang/Class;", "newInstance", "described", "serialization"})
    public static final class Companion
    implements DescribedTypeConstructor<Descriptor> {
        @NotNull
        public final UnsignedLong getDESCRIPTOR() {
            return DESCRIPTOR;
        }

        @NotNull
        public final Descriptor get(@NotNull Object obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            DescribedType describedType = (DescribedType)obj;
            if (Intrinsics.areEqual((Object)describedType.getDescriptor(), (Object)this.getDESCRIPTOR()) ^ true) {
                throw (Throwable)new NotSerializableException("Unexpected descriptor " + describedType.getDescriptor() + '.');
            }
            return this.newInstance(describedType.getDescribed());
        }

        @NotNull
        public Class<?> getTypeClass() {
            return Descriptor.class;
        }

        @NotNull
        public Descriptor newInstance(@Nullable Object described) {
            Object object = described;
            if (!(object instanceof List)) {
                object = null;
            }
            List list = (List)object;
            if (list == null) {
                throw (Throwable)new IllegalStateException("Was expecting a list");
            }
            List list2 = list;
            Object e = list2.get(0);
            if (!(e instanceof Symbol)) {
                e = null;
            }
            Symbol symbol = (Symbol)e;
            Object e2 = list2.get(1);
            if (!(e2 instanceof UnsignedLong)) {
                e2 = null;
            }
            return new Descriptor(symbol, (UnsignedLong)e2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

