/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.ArraySerializer;
import net.corda.serialization.internal.amqp.CollectionSerializer;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.EnumSerializer;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.MapSerializer;
import net.corda.serialization.internal.amqp.MapSerializerKt;
import net.corda.serialization.internal.amqp.ObjectSerializer;
import net.corda.serialization.internal.amqp.PrimArraySerializer;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.SingletonSerializer;
import net.corda.serialization.internal.amqp.TypeParameterUtilsKt;
import net.corda.serialization.internal.model.DefaultCacheProvider;
import net.corda.serialization.internal.model.FingerPrinter;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeModel;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 F2\u00020\u0001:\u0002EFBm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r\u0012\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&H\u0016J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020&H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010+\u001a\u00020&H\u0016J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020/H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010&2\u0006\u00103\u001a\u00020\u001cH\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u00102\u001a\u00020/H\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010+\u001a\u000206H\u0002J*\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00100\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J*\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010.\u001a\u00020/2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010+\u001a\u00020:H\u0002J*\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010+\u001a\u00020&2\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0=H\u0002J*\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010>\u001a\u00020#2\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0=H\u0002J*\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u00102\u001a\u00020/2\u0006\u0010+\u001a\u00020&H\u0002J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00100\u001a\u000206H\u0002J*\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00100\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00100\u001a\u00020:H\u0002J*\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u00102\u001a\u00020/2\u0006\u0010+\u001a\u00020&2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006G"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultLocalSerializerFactory;", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "typeModel", "Lnet/corda/serialization/internal/model/LocalTypeModel;", "fingerPrinter", "Lnet/corda/serialization/internal/model/FingerPrinter;", "classloader", "Ljava/lang/ClassLoader;", "descriptorBasedSerializerRegistry", "Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;", "primitiveSerializerFactory", "Ljava/util/function/Function;", "Ljava/lang/Class;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "isPrimitiveType", "Ljava/util/function/Predicate;", "customSerializerRegistry", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "onlyCustomSerializers", "", "(Lnet/corda/core/serialization/ClassWhitelist;Lnet/corda/serialization/internal/model/LocalTypeModel;Lnet/corda/serialization/internal/model/FingerPrinter;Ljava/lang/ClassLoader;Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;Ljava/util/function/Function;Ljava/util/function/Predicate;Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;Z)V", "getClassloader", "()Ljava/lang/ClassLoader;", "customSerializerNames", "", "", "getCustomSerializerNames", "()Ljava/util/List;", "serializersByActualAndDeclaredType", "", "Lnet/corda/serialization/internal/amqp/DefaultLocalSerializerFactory$ActualAndDeclaredType;", "serializersByTypeId", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "typesByName", "Ljava/util/Optional;", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "createDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "typeInformation", "get", "actualClass", "declaredType", "Ljava/lang/reflect/Type;", "localTypeInformation", "getTypeInformation", "type", "typeName", "isSuitableForObjectReference", "makeActualCollection", "Lnet/corda/serialization/internal/model/LocalTypeInformation$ACollection;", "makeActualEnum", "declaredClass", "makeActualMap", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AMap;", "makeAndCache", "build", "Lkotlin/Function0;", "typeIdentifier", "makeClassSerializer", "clazz", "makeDeclaredCollection", "makeDeclaredEnum", "makeDeclaredMap", "makeNonCustomSerializer", "ActualAndDeclaredType", "Companion", "serialization"})
@ThreadSafe
public final class DefaultLocalSerializerFactory
implements LocalSerializerFactory {
    private final Map<ActualAndDeclaredType, AMQPSerializer<Object>> serializersByActualAndDeclaredType;
    private final Map<TypeIdentifier, AMQPSerializer<Object>> serializersByTypeId;
    private final Map<String, Optional<LocalTypeInformation>> typesByName;
    @NotNull
    private final ClassWhitelist whitelist;
    private final LocalTypeModel typeModel;
    private final FingerPrinter fingerPrinter;
    @NotNull
    private final ClassLoader classloader;
    private final DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry;
    private final Function<Class<?>, AMQPSerializer<Object>> primitiveSerializerFactory;
    private final Predicate<Class<?>> isPrimitiveType;
    private final CustomSerializerRegistry customSerializerRegistry;
    private final boolean onlyCustomSerializers;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<String> getCustomSerializerNames() {
        return this.customSerializerRegistry.getCustomSerializerNames();
    }

    @Override
    @NotNull
    public Symbol createDescriptor(@NotNull LocalTypeInformation typeInformation) {
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        Symbol symbol = Symbol.valueOf((String)("net.corda:" + this.fingerPrinter.fingerprint(typeInformation)));
        Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"Symbol.valueOf(\"$DESCRIP\u2026print(typeInformation)}\")");
        return symbol;
    }

    @Override
    @NotNull
    public LocalTypeInformation getTypeInformation(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.typeModel.inspect(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public LocalTypeInformation getTypeInformation(@NotNull String typeName2) {
        Optional<Object> optional;
        Intrinsics.checkParameterIsNotNull((Object)typeName2, (String)"typeName");
        Map<String, Optional<LocalTypeInformation>> $receiver$iv = this.typesByName;
        Optional<LocalTypeInformation> value$iv = $receiver$iv.get(typeName2);
        if (value$iv == null) {
            LocalTypeInformation localTypeInformation;
            Class<?> localType;
            Class<?> clazz;
            try {
                clazz = Class.forName(typeName2, false, this.getClassloader());
            }
            catch (ClassNotFoundException _) {
                clazz = null;
            }
            Class<?> clazz2 = localType = clazz;
            if (clazz2 != null) {
                Class<?> $receiver = clazz = clazz2;
                localTypeInformation = this.getTypeInformation($receiver);
            } else {
                localTypeInformation = null;
            }
            Optional<Object> optional2 = Optional.ofNullable(localTypeInformation);
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.ofNullable(loca\u2026tTypeInformation(this) })");
            Optional<Object> answer$iv = optional2;
            $receiver$iv.put(typeName2, answer$iv);
            optional = answer$iv;
        } else {
            void var3_3;
            optional = var3_3;
        }
        return ((Optional)optional).orElse(null);
    }

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull LocalTypeInformation typeInformation) {
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        return this.get(typeInformation.getObservedType(), typeInformation);
    }

    @Override
    public boolean isSuitableForObjectReference(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Class<?> clazz = SerializationHelperKt.asClass(type);
        return Intrinsics.areEqual((Object)type, byte[].class) ^ true && !this.isPrimitiveType.test(clazz);
    }

    private final AMQPSerializer<Object> makeAndCache(LocalTypeInformation typeInformation, Function0<? extends AMQPSerializer<? extends Object>> build2) {
        return this.makeAndCache(typeInformation.getTypeIdentifier(), build2);
    }

    private final AMQPSerializer<Object> makeAndCache(TypeIdentifier typeIdentifier, Function0<? extends AMQPSerializer<? extends Object>> build2) {
        AMQPSerializer aMQPSerializer;
        Map<TypeIdentifier, AMQPSerializer<Object>> $receiver$iv = this.serializersByTypeId;
        AMQPSerializer value$iv = $receiver$iv.get(typeIdentifier);
        if (value$iv == null) {
            Object object = build2.invoke();
            AMQPSerializer serializer2 = (AMQPSerializer)object;
            String string = serializer2.getTypeDescriptor().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serializer.typeDescriptor.toString()");
            this.descriptorBasedSerializerRegistry.set(string, serializer2);
            AMQPSerializer answer$iv = (AMQPSerializer)object;
            $receiver$iv.put(typeIdentifier, answer$iv);
            aMQPSerializer = answer$iv;
        } else {
            aMQPSerializer = value$iv;
        }
        return aMQPSerializer;
    }

    private final AMQPSerializer<Object> get(Type declaredType, LocalTypeInformation localTypeInformation) {
        Map<TypeIdentifier, AMQPSerializer<Object>> map = this.serializersByTypeId;
        TypeIdentifier typeIdentifier = localTypeInformation.getTypeIdentifier();
        AMQPSerializer<Object> aMQPSerializer = map.get(typeIdentifier);
        if (aMQPSerializer == null) {
            Object object;
            Class<?> declaredClass = SerializationHelperKt.asClass(declaredType);
            Type declaredGenericType = !(declaredType instanceof ParameterizedType) && localTypeInformation.getTypeIdentifier() instanceof TypeIdentifier.Parameterised && Intrinsics.areEqual(declaredClass, Class.class) ^ true ? localTypeInformation.getTypeIdentifier().getLocalType(this.getClassloader()) : declaredType;
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Get Serializer for " + declaredClass + ' ' + declaredGenericType.getTypeName();
                logger.trace(string);
            }
            AMQPSerializer<Object> aMQPSerializer2 = this.customSerializerRegistry.findCustomSerializer(declaredClass, declaredGenericType);
            if (aMQPSerializer2 != null) {
                object = aMQPSerializer2;
                AMQPSerializer<Object> $receiver = object;
                return $receiver;
            }
            object = localTypeInformation;
            aMQPSerializer = object instanceof LocalTypeInformation.ACollection ? this.makeDeclaredCollection((LocalTypeInformation.ACollection)localTypeInformation) : (object instanceof LocalTypeInformation.AMap ? this.makeDeclaredMap((LocalTypeInformation.AMap)localTypeInformation) : (object instanceof LocalTypeInformation.AnEnum ? this.makeDeclaredEnum(localTypeInformation, declaredType, declaredClass) : this.makeClassSerializer(declaredClass, declaredType, localTypeInformation)));
        }
        return aMQPSerializer;
    }

    private final AMQPSerializer<Object> makeDeclaredEnum(LocalTypeInformation localTypeInformation, Type declaredType, Class<?> declaredClass) {
        return this.makeAndCache(localTypeInformation, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<EnumSerializer>(this, declaredType, declaredClass){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ Type $declaredType;
            final /* synthetic */ Class $declaredClass;

            @NotNull
            public final EnumSerializer invoke() {
                SerializationHelperKt.requireWhitelisted(this.this$0.getWhitelist(), this.$declaredType);
                return new EnumSerializer(this.$declaredType, this.$declaredClass, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$declaredType = type;
                this.$declaredClass = clazz;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeActualEnum(LocalTypeInformation localTypeInformation, Type declaredType, Class<?> declaredClass) {
        return this.makeAndCache(localTypeInformation, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<EnumSerializer>(this, declaredType, declaredClass){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ Type $declaredType;
            final /* synthetic */ Class $declaredClass;

            @NotNull
            public final EnumSerializer invoke() {
                SerializationHelperKt.requireWhitelisted(this.this$0.getWhitelist(), this.$declaredType);
                return new EnumSerializer(this.$declaredType, this.$declaredClass, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$declaredType = type;
                this.$declaredClass = clazz;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeDeclaredCollection(LocalTypeInformation.ACollection localTypeInformation) {
        LocalTypeInformation.ACollection resolved = CollectionSerializer.Companion.resolveDeclared(localTypeInformation);
        return this.makeAndCache(resolved, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<CollectionSerializer>(this, resolved){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ LocalTypeInformation.ACollection $resolved;

            @NotNull
            public final CollectionSerializer invoke() {
                Type type = this.$resolved.getTypeIdentifier().getLocalType(this.this$0.getClassloader());
                if (type == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                return new CollectionSerializer((ParameterizedType)type, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$resolved = aCollection;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeDeclaredMap(LocalTypeInformation.AMap localTypeInformation) {
        LocalTypeInformation.AMap resolved = MapSerializer.Companion.resolveDeclared(localTypeInformation);
        return this.makeAndCache(resolved, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<MapSerializer>(this, resolved){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ LocalTypeInformation.AMap $resolved;

            @NotNull
            public final MapSerializer invoke() {
                Type type = this.$resolved.getTypeIdentifier().getLocalType(this.this$0.getClassloader());
                if (type == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                return new MapSerializer((ParameterizedType)type, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$resolved = aMap;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull Class<?> actualClass, @NotNull Type declaredType) {
        AMQPSerializer<Object> aMQPSerializer;
        Intrinsics.checkParameterIsNotNull(actualClass, (String)"actualClass");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        ActualAndDeclaredType actualAndDeclaredType = new ActualAndDeclaredType(actualClass, declaredType);
        Map<ActualAndDeclaredType, AMQPSerializer<Object>> $receiver$iv = this.serializersByActualAndDeclaredType;
        AMQPSerializer<Object> value$iv = $receiver$iv.get(actualAndDeclaredType);
        if (value$iv == null) {
            AMQPSerializer<Object> aMQPSerializer2;
            LocalTypeInformation actualTypeInformation;
            Object $receiver$iv2 = logger;
            if ($receiver$iv2.isTraceEnabled()) {
                Logger logger = $receiver$iv2;
                String string = "Get Serializer for " + actualClass + ' ' + declaredType.getTypeName();
                logger.trace(string);
            }
            AMQPSerializer<Object> aMQPSerializer3 = this.customSerializerRegistry.findCustomSerializer(actualClass, declaredType);
            if (aMQPSerializer3 != null) {
                Object $receiver = $receiver$iv2 = aMQPSerializer3;
                return $receiver;
            }
            Class<?> declaredClass = SerializationHelperKt.asClass(declaredType);
            Type type = TypeParameterUtilsKt.inferTypeVariables(actualClass, declaredClass, declaredType);
            if (type == null) {
                type = declaredType;
            }
            Type actualType = type;
            LocalTypeInformation declaredTypeInformation = this.typeModel.inspect(declaredType);
            LocalTypeInformation localTypeInformation = actualTypeInformation = this.typeModel.inspect(actualType);
            if (localTypeInformation instanceof LocalTypeInformation.ACollection) {
                LocalTypeInformation.ACollection aCollection;
                LocalTypeInformation localTypeInformation2 = declaredTypeInformation;
                if (!(localTypeInformation2 instanceof LocalTypeInformation.ACollection)) {
                    localTypeInformation2 = null;
                }
                if ((aCollection = (LocalTypeInformation.ACollection)localTypeInformation2) == null) {
                    aCollection = (LocalTypeInformation.ACollection)actualTypeInformation;
                }
                aMQPSerializer2 = this.makeActualCollection(actualClass, aCollection);
            } else if (localTypeInformation instanceof LocalTypeInformation.AMap) {
                LocalTypeInformation.AMap aMap;
                LocalTypeInformation localTypeInformation3 = declaredTypeInformation;
                if (!(localTypeInformation3 instanceof LocalTypeInformation.AMap)) {
                    localTypeInformation3 = null;
                }
                if ((aMap = (LocalTypeInformation.AMap)localTypeInformation3) == null) {
                    aMap = (LocalTypeInformation.AMap)actualTypeInformation;
                }
                aMQPSerializer2 = this.makeActualMap(declaredType, actualClass, aMap);
            } else {
                aMQPSerializer2 = localTypeInformation instanceof LocalTypeInformation.AnEnum ? this.makeActualEnum(actualTypeInformation, actualType, actualClass) : this.makeClassSerializer(actualClass, actualType, actualTypeInformation);
            }
            AMQPSerializer<Object> answer$iv = aMQPSerializer2;
            $receiver$iv.put(actualAndDeclaredType, answer$iv);
            aMQPSerializer = answer$iv;
        } else {
            aMQPSerializer = value$iv;
        }
        return aMQPSerializer;
    }

    private final AMQPSerializer<Object> makeActualMap(Type declaredType, Class<?> actualClass, LocalTypeInformation.AMap typeInformation) {
        MapSerializerKt.checkSupportedMapType(SerializationHelperKt.asClass(declaredType));
        LocalTypeInformation.AMap resolved = MapSerializer.Companion.resolveActual(actualClass, typeInformation);
        return this.makeAndCache(resolved, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<MapSerializer>(this, resolved){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ LocalTypeInformation.AMap $resolved;

            @NotNull
            public final MapSerializer invoke() {
                Type type = this.$resolved.getTypeIdentifier().getLocalType(this.this$0.getClassloader());
                if (type == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                return new MapSerializer((ParameterizedType)type, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$resolved = aMap;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeActualCollection(Class<?> actualClass, LocalTypeInformation.ACollection typeInformation) {
        LocalTypeInformation.ACollection resolved = CollectionSerializer.Companion.resolveActual(actualClass, typeInformation);
        return this.makeAndCache(resolved, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<CollectionSerializer>(this, resolved){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ LocalTypeInformation.ACollection $resolved;

            @NotNull
            public final CollectionSerializer invoke() {
                Type type = this.$resolved.getTypeIdentifier().getLocalType(this.this$0.getClassloader());
                if (type == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                return new CollectionSerializer((ParameterizedType)type, this.this$0);
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$resolved = aCollection;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeClassSerializer(Class<?> clazz, Type type, LocalTypeInformation typeInformation) {
        return this.makeAndCache(typeInformation, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<AMQPSerializer<? extends Object>>(this, clazz, type, typeInformation){
            final /* synthetic */ DefaultLocalSerializerFactory this$0;
            final /* synthetic */ Class $clazz;
            final /* synthetic */ Type $type;
            final /* synthetic */ LocalTypeInformation $typeInformation;

            @NotNull
            public final AMQPSerializer<Object> invoke() {
                AMQPSerializer aMQPSerializer;
                Logger $receiver$iv = DefaultLocalSerializerFactory.Companion.getLogger();
                if ($receiver$iv.isDebugEnabled()) {
                    Logger logger = $receiver$iv;
                    String string = "class=" + this.$clazz.getSimpleName() + ", type=" + this.$type + " is a composite type";
                    logger.debug(string);
                }
                if (this.$clazz.isSynthetic()) {
                    throw (Throwable)new AMQPNotSerializableException(this.$type, "Serializer does not support synthetic classes", null, null, 12, null);
                }
                if (AMQPTypeIdentifiers.INSTANCE.isPrimitive(this.$typeInformation.getTypeIdentifier())) {
                    R r = DefaultLocalSerializerFactory.access$getPrimitiveSerializerFactory$p(this.this$0).apply(this.$clazz);
                    Intrinsics.checkExpressionValueIsNotNull(r, (String)"primitiveSerializerFactory.apply(clazz)");
                    aMQPSerializer = (AMQPSerializer)r;
                } else {
                    aMQPSerializer = DefaultLocalSerializerFactory.access$makeNonCustomSerializer(this.this$0, this.$type, this.$typeInformation, this.$clazz);
                }
                return aMQPSerializer;
            }
            {
                this.this$0 = defaultLocalSerializerFactory;
                this.$clazz = clazz;
                this.$type = type;
                this.$typeInformation = localTypeInformation;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> makeNonCustomSerializer(Type type, LocalTypeInformation typeInformation, Class<?> clazz) {
        AMQPSerializer aMQPSerializer;
        if (this.onlyCustomSerializers) {
            throw (Throwable)new AMQPNotSerializableException(type, "Only allowing custom serializers", null, null, 12, null);
        }
        if (SerializationHelperKt.isArray(type)) {
            Class<?> clazz2 = clazz.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"clazz.componentType");
            aMQPSerializer = clazz2.isPrimitive() ? (AMQPSerializer)PrimArraySerializer.Companion.make(type, this) : ArraySerializer.Companion.make(type, this);
        } else {
            Object singleton = InternalUtils.getKotlinObjectInstance(clazz);
            if (singleton != null) {
                SerializationHelperKt.requireWhitelisted(this.getWhitelist(), clazz);
                aMQPSerializer = new SingletonSerializer(clazz, singleton, this);
            } else {
                SerializationHelperKt.requireWhitelisted(this.getWhitelist(), type);
                aMQPSerializer = ObjectSerializer.Companion.make(typeInformation, this);
            }
        }
        return aMQPSerializer;
    }

    @Override
    @NotNull
    public ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    @Override
    @NotNull
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public DefaultLocalSerializerFactory(@NotNull ClassWhitelist whitelist, @NotNull LocalTypeModel typeModel, @NotNull FingerPrinter fingerPrinter, @NotNull ClassLoader classloader, @NotNull DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry, @NotNull Function<Class<?>, AMQPSerializer<Object>> primitiveSerializerFactory, @NotNull Predicate<Class<?>> isPrimitiveType, @NotNull CustomSerializerRegistry customSerializerRegistry, boolean onlyCustomSerializers) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)typeModel, (String)"typeModel");
        Intrinsics.checkParameterIsNotNull((Object)fingerPrinter, (String)"fingerPrinter");
        Intrinsics.checkParameterIsNotNull((Object)classloader, (String)"classloader");
        Intrinsics.checkParameterIsNotNull((Object)descriptorBasedSerializerRegistry, (String)"descriptorBasedSerializerRegistry");
        Intrinsics.checkParameterIsNotNull(primitiveSerializerFactory, (String)"primitiveSerializerFactory");
        Intrinsics.checkParameterIsNotNull(isPrimitiveType, (String)"isPrimitiveType");
        Intrinsics.checkParameterIsNotNull((Object)customSerializerRegistry, (String)"customSerializerRegistry");
        this.whitelist = whitelist;
        this.typeModel = typeModel;
        this.fingerPrinter = fingerPrinter;
        this.classloader = classloader;
        this.descriptorBasedSerializerRegistry = descriptorBasedSerializerRegistry;
        this.primitiveSerializerFactory = primitiveSerializerFactory;
        this.isPrimitiveType = isPrimitiveType;
        this.customSerializerRegistry = customSerializerRegistry;
        this.onlyCustomSerializers = onlyCustomSerializers;
        this.serializersByActualAndDeclaredType = DefaultCacheProvider.INSTANCE.createCache();
        this.serializersByTypeId = DefaultCacheProvider.INSTANCE.createCache();
        this.typesByName = DefaultCacheProvider.INSTANCE.createCache();
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Function access$getPrimitiveSerializerFactory$p(DefaultLocalSerializerFactory $this) {
        return $this.primitiveSerializerFactory;
    }

    @NotNull
    public static final /* synthetic */ AMQPSerializer access$makeNonCustomSerializer(DefaultLocalSerializerFactory $this, @NotNull Type type, @NotNull LocalTypeInformation typeInformation, @NotNull Class clazz) {
        return $this.makeNonCustomSerializer(type, typeInformation, clazz);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultLocalSerializerFactory$ActualAndDeclaredType;", "", "actualType", "Ljava/lang/Class;", "declaredType", "Ljava/lang/reflect/Type;", "(Ljava/lang/Class;Ljava/lang/reflect/Type;)V", "getActualType", "()Ljava/lang/Class;", "getDeclaredType", "()Ljava/lang/reflect/Type;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    private static final class ActualAndDeclaredType {
        @NotNull
        private final Class<?> actualType;
        @NotNull
        private final Type declaredType;

        @NotNull
        public final Class<?> getActualType() {
            return this.actualType;
        }

        @NotNull
        public final Type getDeclaredType() {
            return this.declaredType;
        }

        public ActualAndDeclaredType(@NotNull Class<?> actualType, @NotNull Type declaredType) {
            Intrinsics.checkParameterIsNotNull(actualType, (String)"actualType");
            Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
            this.actualType = actualType;
            this.declaredType = declaredType;
        }

        @NotNull
        public final Class<?> component1() {
            return this.actualType;
        }

        @NotNull
        public final Type component2() {
            return this.declaredType;
        }

        @NotNull
        public final ActualAndDeclaredType copy(@NotNull Class<?> actualType, @NotNull Type declaredType) {
            Intrinsics.checkParameterIsNotNull(actualType, (String)"actualType");
            Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
            return new ActualAndDeclaredType(actualType, declaredType);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ActualAndDeclaredType copy$default(ActualAndDeclaredType actualAndDeclaredType, Class clazz, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = actualAndDeclaredType.actualType;
            }
            if ((n & 2) != 0) {
                type = actualAndDeclaredType.declaredType;
            }
            return actualAndDeclaredType.copy(clazz, type);
        }

        @NotNull
        public String toString() {
            return "ActualAndDeclaredType(actualType=" + this.actualType + ", declaredType=" + this.declaredType + ")";
        }

        public int hashCode() {
            Class<?> clazz = this.actualType;
            Type type = this.declaredType;
            return (clazz != null ? clazz.hashCode() : 0) * 31 + (type != null ? type.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActualAndDeclaredType)) break block3;
                    ActualAndDeclaredType actualAndDeclaredType = (ActualAndDeclaredType)object;
                    if (!Intrinsics.areEqual(this.actualType, actualAndDeclaredType.actualType) || !Intrinsics.areEqual((Object)this.declaredType, (Object)actualAndDeclaredType.declaredType)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultLocalSerializerFactory$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "serialization"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

