/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPExceptionsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.ObjectBuilder;
import net.corda.serialization.internal.amqp.PropertySerializer;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ&\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lnet/corda/serialization/internal/amqp/ComposableObjectReader;", "", "typeIdentifier", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "propertySerializers", "", "", "Lnet/corda/serialization/internal/model/PropertyName;", "Lnet/corda/serialization/internal/amqp/PropertySerializer;", "objectBuilderProvider", "Lkotlin/Function0;", "Lnet/corda/serialization/internal/amqp/ObjectBuilder;", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "readObject", "obj", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "input", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "context", "Lnet/corda/core/serialization/SerializationContext;", "serialization"})
public final class ComposableObjectReader {
    @NotNull
    private final TypeIdentifier typeIdentifier;
    private final Map<String, PropertySerializer> propertySerializers;
    private final Function0<ObjectBuilder> objectBuilderProvider;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            void $receiver$iv;
            if (!(obj instanceof List)) {
                throw (Throwable)new NotSerializableException("Body of described type is unexpected " + obj);
            }
            if (((List)obj).size() < this.propertySerializers.size()) {
                throw (Throwable)new NotSerializableException(((List)obj).size() + " objects to deserialize, but " + this.propertySerializers.size() + " properties in described type " + this.typeIdentifier.prettyPrint(false));
            }
            ObjectBuilder builder = (ObjectBuilder)this.objectBuilderProvider.invoke();
            builder.initialize();
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)obj)), (Sequence)CollectionsKt.asSequence((Iterable)this.propertySerializers.values())), (Function1)((Function1)new Function1<Pair<? extends Object, ? extends PropertySerializer>, Object>(this, obj, schemas, input, context){
                final /* synthetic */ ComposableObjectReader this$0;
                final /* synthetic */ Object $obj$inlined;
                final /* synthetic */ SerializationSchemas $schemas$inlined;
                final /* synthetic */ DeserializationInput $input$inlined;
                final /* synthetic */ SerializationContext $context$inlined;
                {
                    this.this$0 = composableObjectReader;
                    this.$obj$inlined = object;
                    this.$schemas$inlined = serializationSchemas;
                    this.$input$inlined = deserializationInput;
                    this.$context$inlined = serializationContext;
                    super(1);
                }

                @Nullable
                public final Object invoke(@NotNull Pair<? extends Object, ? extends PropertySerializer> $item_property) {
                    Intrinsics.checkParameterIsNotNull($item_property, (String)"<name for destructuring parameter 0>");
                    Object item = $item_property.component1();
                    PropertySerializer property = (PropertySerializer)$item_property.component2();
                    return property.readProperty(item, this.$schemas$inlined, this.$input$inlined, this.$context$inlined);
                }
            }));
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void propertyValue;
                int n = index$iv++;
                Object e = item$iv;
                int slot = n;
                builder.populate(slot, propertyValue);
            }
            return builder.build();
        }
        catch (Throwable th$iv) {
            Throwable throwable = th$iv;
            if (throwable instanceof AMQPNotSerializableException) {
                List<String> list = ((AMQPNotSerializableException)th$iv).getClassHierarchy();
                String string = this.typeIdentifier.prettyPrint(false);
                list.add(string);
            } else if (!(throwable instanceof ClassNotFoundException) && !(throwable instanceof NoClassDefFoundError)) {
                StringBuilder stringBuilder = new StringBuilder();
                Throwable throwable2 = th$iv;
                String string = this.typeIdentifier.prettyPrint(false);
                AMQPExceptionsKt.access$setMessage(throwable2, stringBuilder.append(string).append(" -> ").append(th$iv.getMessage()).toString());
            }
            throw th$iv;
        }
    }

    @NotNull
    public final TypeIdentifier getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public ComposableObjectReader(@NotNull TypeIdentifier typeIdentifier, @NotNull Map<String, ? extends PropertySerializer> propertySerializers, @NotNull Function0<? extends ObjectBuilder> objectBuilderProvider) {
        Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
        Intrinsics.checkParameterIsNotNull(propertySerializers, (String)"propertySerializers");
        Intrinsics.checkParameterIsNotNull(objectBuilderProvider, (String)"objectBuilderProvider");
        this.typeIdentifier = typeIdentifier;
        this.propertySerializers = propertySerializers;
        this.objectBuilderProvider = objectBuilderProvider;
    }
}

