/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.DeleteForDJVM;
import net.corda.core.KeepForDJVM;
import net.corda.core.cordapp.Cordapp;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ContextPropertyKeys;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.core.serialization.SerializationWhitelist;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.CordaSerializationMagic;
import net.corda.serialization.internal.SerializationScheme;
import net.corda.serialization.internal.amqp.AMQPSerializationScheme;
import net.corda.serialization.internal.amqp.AMQPSerializerFactories;
import net.corda.serialization.internal.amqp.AbstractAMQPSerializationScheme;
import net.corda.serialization.internal.amqp.AbstractAMQPSerializationScheme$WhenMappings;
import net.corda.serialization.internal.amqp.AccessOrderLinkedHashMap;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationFactoryCacheKey;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryFactory;
import net.corda.serialization.internal.amqp.custom.PublicKeySerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 32\u00020\u0001:\u00013B\u0015\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005BG\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J5\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001e0#2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%J\u0018\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H$J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H$J-\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001e00\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u00101\u001a\u0002H\u001e2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u00102R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lnet/corda/serialization/internal/amqp/AbstractAMQPSerializationScheme;", "Lnet/corda/serialization/internal/SerializationScheme;", "cordapps", "", "Lnet/corda/core/cordapp/Cordapp;", "(Ljava/util/List;)V", "cordappCustomSerializers", "", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "cordappSerializationWhitelists", "Lnet/corda/core/serialization/SerializationWhitelist;", "maybeNotConcurrentSerializerFactoriesForContexts", "", "Lnet/corda/serialization/internal/amqp/SerializationFactoryCacheKey;", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "sff", "Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;)V", "publicKeySerializer", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "getPublicKeySerializer", "()Lnet/corda/serialization/internal/amqp/CustomSerializer;", "serializerFactoriesForContexts", "getSff", "()Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;", "canDeserializeVersion", "", "magic", "Lnet/corda/serialization/internal/CordaSerializationMagic;", "deserialize", "T", "", "byteSequence", "Lnet/corda/core/utilities/ByteSequence;", "clazz", "Ljava/lang/Class;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "getRegisteredCustomSerializers", "getSerializerFactory", "registerCustomSerializers", "", "factory", "registerCustomWhitelists", "rpcClientSerializerFactory", "rpcServerSerializerFactory", "serialize", "Lnet/corda/core/serialization/SerializedBytes;", "obj", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "Companion", "serialization"})
@KeepForDJVM
public abstract class AbstractAMQPSerializationScheme
implements SerializationScheme {
    private final Map<SerializationFactoryCacheKey, SerializerFactory> serializerFactoriesForContexts;
    @NotNull
    private final CustomSerializer<?> publicKeySerializer;
    private final Set<SerializationCustomSerializer<?, ?>> cordappCustomSerializers;
    private final Set<SerializationWhitelist> cordappSerializationWhitelists;
    @NotNull
    private final SerializerFactoryFactory sff;
    private static final Lazy serializationWhitelists$delegate;
    public static final Companion Companion;

    @NotNull
    public final Set<SerializationCustomSerializer<?, ?>> getRegisteredCustomSerializers() {
        return this.cordappCustomSerializers;
    }

    private final void registerCustomSerializers(SerializationContext context, SerializerFactory factory) {
        SerializationCustomSerializer customSerializer;
        factory.register(this.getPublicKeySerializer());
        AMQPSerializationScheme.registerCustomSerializers(factory);
        Iterable $receiver$iv = context.getCustomSerializers();
        for (Object element$iv : $receiver$iv) {
            customSerializer = (SerializationCustomSerializer)element$iv;
            factory.registerExternal(new CorDappCustomSerializer(customSerializer, factory));
        }
        $receiver$iv = this.cordappCustomSerializers;
        for (Object element$iv : $receiver$iv) {
            customSerializer = (SerializationCustomSerializer)element$iv;
            if (!Intrinsics.areEqual((Object)customSerializer.getClass().getClassLoader(), (Object)context.getDeserializationClassLoader())) continue;
            factory.registerExternal(new CorDappCustomSerializer(customSerializer, factory));
        }
        Object v = context.getProperties().get(ContextPropertyKeys.SERIALIZERS);
        if (v != null) {
            Object v2;
            Object $receiver = v2 = v;
            Iterable $receiver$iv2 = (Iterable)InternalUtils.uncheckedCast($receiver);
            for (Object element$iv : $receiver$iv2) {
                CustomSerializer it = (CustomSerializer)element$iv;
                factory.register(it);
            }
        }
    }

    private final void registerCustomWhitelists(SerializerFactory factory) {
        SerializationWhitelist it;
        Iterable $receiver$iv = AbstractAMQPSerializationScheme.Companion.getSerializationWhitelists();
        for (Object element$iv : $receiver$iv) {
            it = (SerializationWhitelist)element$iv;
            AMQPSerializationScheme.addToWhitelist(factory, it.getWhitelist());
        }
        $receiver$iv = this.cordappSerializationWhitelists;
        for (Object element$iv : $receiver$iv) {
            it = (SerializationWhitelist)element$iv;
            AMQPSerializationScheme.addToWhitelist(factory, it.getWhitelist());
        }
    }

    @NotNull
    protected abstract SerializerFactory rpcClientSerializerFactory(@NotNull SerializationContext var1);

    @NotNull
    protected abstract SerializerFactory rpcServerSerializerFactory(@NotNull SerializationContext var1);

    @NotNull
    public CustomSerializer<?> getPublicKeySerializer() {
        return this.publicKeySerializer;
    }

    @NotNull
    public final SerializerFactory getSerializerFactory(@NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializationFactoryCacheKey key = new SerializationFactoryCacheKey(context.getWhitelist(), context.getDeserializationClassLoader(), context.getPreventDataLoss(), context.getCustomSerializers());
        SerializerFactory serializerFactory = this.serializerFactoriesForContexts.get(key);
        if (serializerFactory == null) {
            SerializerFactory serializerFactory2 = this.serializerFactoriesForContexts.computeIfAbsent(key, new Function<SerializationFactoryCacheKey, SerializerFactory>(this, context){
                final /* synthetic */ AbstractAMQPSerializationScheme this$0;
                final /* synthetic */ SerializationContext $context;

                @NotNull
                public final SerializerFactory apply(@NotNull SerializationFactoryCacheKey it) {
                    SerializerFactory serializerFactory;
                    SerializerFactory serializerFactory2;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    switch (AbstractAMQPSerializationScheme$WhenMappings.$EnumSwitchMapping$0[this.$context.getUseCase().ordinal()]) {
                        case 1: {
                            serializerFactory2 = this.this$0.rpcClientSerializerFactory(this.$context);
                            break;
                        }
                        case 2: {
                            serializerFactory2 = this.this$0.rpcServerSerializerFactory(this.$context);
                            break;
                        }
                        default: {
                            serializerFactory2 = this.this$0.getSff().make(this.$context);
                        }
                    }
                    SerializerFactory it2 = serializerFactory = serializerFactory2;
                    AbstractAMQPSerializationScheme.access$registerCustomSerializers(this.this$0, this.$context, it2);
                    AbstractAMQPSerializationScheme.access$registerCustomWhitelists(this.this$0, it2);
                    return serializerFactory;
                }
                {
                    this.this$0 = abstractAMQPSerializationScheme;
                    this.$context = serializationContext;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)serializerFactory2, (String)"serializerFactoriesForCo\u2026)\n            }\n        }");
            serializerFactory = serializerFactory2;
        }
        return serializerFactory;
    }

    @Override
    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new DeserializationInput(serializerFactory).deserialize(byteSequence, clazz, context);
    }

    @Override
    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new SerializationOutput(serializerFactory).serialize(obj, context);
    }

    protected final boolean canDeserializeVersion(@NotNull CordaSerializationMagic magic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)magic), (String)"magic");
        return Intrinsics.areEqual((Object)((Object)magic), (Object)((Object)SchemaKt.getAmqpMagic()));
    }

    @NotNull
    public final SerializerFactoryFactory getSff() {
        return this.sff;
    }

    public AbstractAMQPSerializationScheme(@NotNull Set<? extends SerializationCustomSerializer<?, ?>> cordappCustomSerializers, @NotNull Set<? extends SerializationWhitelist> cordappSerializationWhitelists, @NotNull Map<SerializationFactoryCacheKey, SerializerFactory> maybeNotConcurrentSerializerFactoriesForContexts, @NotNull SerializerFactoryFactory sff) {
        Map<SerializationFactoryCacheKey, SerializerFactory> map;
        Intrinsics.checkParameterIsNotNull(cordappCustomSerializers, (String)"cordappCustomSerializers");
        Intrinsics.checkParameterIsNotNull(cordappSerializationWhitelists, (String)"cordappSerializationWhitelists");
        Intrinsics.checkParameterIsNotNull(maybeNotConcurrentSerializerFactoriesForContexts, (String)"maybeNotConcurrentSerializerFactoriesForContexts");
        Intrinsics.checkParameterIsNotNull((Object)sff, (String)"sff");
        this.cordappCustomSerializers = cordappCustomSerializers;
        this.cordappSerializationWhitelists = cordappSerializationWhitelists;
        this.sff = sff;
        if (maybeNotConcurrentSerializerFactoriesForContexts instanceof AccessOrderLinkedHashMap) {
            Map<SerializationFactoryCacheKey, SerializerFactory> map2 = Collections.synchronizedMap(maybeNotConcurrentSerializerFactoriesForContexts);
            map = map2;
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.synchronized\u2026izerFactoriesForContexts)");
        } else {
            map = maybeNotConcurrentSerializerFactoriesForContexts;
        }
        this.serializerFactoriesForContexts = map;
        this.publicKeySerializer = PublicKeySerializer.INSTANCE;
    }

    public /* synthetic */ AbstractAMQPSerializationScheme(Set set, Set set2, Map map, SerializerFactoryFactory serializerFactoryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            serializerFactoryFactory = AMQPSerializerFactories.createSerializerFactoryFactory();
        }
        this(set, set2, map, serializerFactoryFactory);
    }

    @DeleteForDJVM
    public AbstractAMQPSerializationScheme(@NotNull List<? extends Cordapp> cordapps) {
        Intrinsics.checkParameterIsNotNull(cordapps, (String)"cordapps");
        this(Companion.getCustomSerializers(cordapps), Companion.getSerializationWhitelists(cordapps), InternalUtils.toSynchronised((Map)new AccessOrderLinkedHashMap(128)), null, 8, null);
    }

    static {
        Companion = new Companion(null);
        serializationWhitelists$delegate = LazyKt.lazy((Function0)Companion.serializationWhitelists.2.INSTANCE);
    }

    public static final /* synthetic */ void access$registerCustomSerializers(AbstractAMQPSerializationScheme $this, @NotNull SerializationContext context, @NotNull SerializerFactory factory) {
        $this.registerCustomSerializers(context, factory);
    }

    public static final /* synthetic */ void access$registerCustomWhitelists(AbstractAMQPSerializationScheme $this, @NotNull SerializerFactory factory) {
        $this.registerCustomWhitelists(factory);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R2\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b*\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\b\u0012\u0004\u0012\u00020\r0\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0006\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/AbstractAMQPSerializationScheme$Companion;", "", "()V", "serializationWhitelists", "", "Lnet/corda/core/serialization/SerializationWhitelist;", "getSerializationWhitelists", "()Ljava/util/List;", "serializationWhitelists$delegate", "Lkotlin/Lazy;", "customSerializers", "Ljava/util/LinkedHashSet;", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "Lnet/corda/core/cordapp/Cordapp;", "customSerializers$annotations", "(Ljava/util/List;)V", "getCustomSerializers", "(Ljava/util/List;)Ljava/util/LinkedHashSet;", "serializationWhitelists$annotations", "serialization"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "serializationWhitelists", "getSerializationWhitelists()Ljava/util/List;"))};
        }

        private final List<SerializationWhitelist> getSerializationWhitelists() {
            Lazy lazy = serializationWhitelists$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (List)lazy.getValue();
        }

        @DeleteForDJVM
        public static /* synthetic */ void customSerializers$annotations(List list) {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LinkedHashSet<SerializationCustomSerializer<?, ?>> getCustomSerializers(@NotNull List<? extends Cordapp> $receiver) {
            void var3_3;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Iterable iterable = $receiver;
            Collection destination$iv = new LinkedHashSet();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object receiver = element$iv = iterator.next();
                Iterable list$iv = ((Cordapp)receiver).getSerializationCustomSerializers();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (LinkedHashSet)var3_3;
        }

        @DeleteForDJVM
        public static /* synthetic */ void serializationWhitelists$annotations(List list) {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LinkedHashSet<SerializationWhitelist> getSerializationWhitelists(@NotNull List<? extends Cordapp> $receiver) {
            void var3_3;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Iterable iterable = $receiver;
            Collection destination$iv = new LinkedHashSet();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object receiver = element$iv = iterator.next();
                Iterable list$iv = ((Cordapp)receiver).getSerializationWhitelists();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (LinkedHashSet)var3_3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

