/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifiers;", "", "()V", "primitiveByteArrayType", "Lnet/corda/serialization/internal/model/TypeIdentifier$ArrayOf;", "primitiveTypeNamesByName", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "isPrimitive", "", "type", "Ljava/lang/reflect/Type;", "typeIdentifier", "nameForType", "primitiveTypeName", "serialization"})
public final class AMQPTypeIdentifiers {
    private static final Map<TypeIdentifier, String> primitiveTypeNamesByName;
    private static final TypeIdentifier.ArrayOf primitiveByteArrayType;
    public static final AMQPTypeIdentifiers INSTANCE;

    public final boolean isPrimitive(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.isPrimitive(TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, type, null, 2, null));
    }

    public final boolean isPrimitive(@NotNull TypeIdentifier typeIdentifier) {
        Map<TypeIdentifier, String> map;
        Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
        Map<TypeIdentifier, String> map2 = map = primitiveTypeNamesByName;
        return map2.containsKey(typeIdentifier);
    }

    @NotNull
    public final String primitiveTypeName(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        String string = primitiveTypeNamesByName.get(TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, type, null, 2, null));
        if (string == null) {
            throw (Throwable)new NotSerializableException("Primitive type name requested for non-primitive type " + type);
        }
        return string;
    }

    @NotNull
    public final String nameForType(@NotNull TypeIdentifier typeIdentifier) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
        TypeIdentifier typeIdentifier2 = typeIdentifier;
        if (typeIdentifier2 instanceof TypeIdentifier.Erased) {
            string = typeIdentifier.getName();
        } else if (typeIdentifier2 instanceof TypeIdentifier.Unparameterised) {
            string = primitiveTypeNamesByName.get(typeIdentifier);
            if (string == null) {
                string = typeIdentifier.getName();
            }
        } else if (typeIdentifier2 instanceof TypeIdentifier.UnknownType) {
            string = "?";
        } else if (typeIdentifier2 instanceof TypeIdentifier.TopType) {
            String string2 = Object.class.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Any::class.java.name");
        } else if (typeIdentifier2 instanceof TypeIdentifier.ArrayOf) {
            string = Intrinsics.areEqual((Object)typeIdentifier, (Object)primitiveByteArrayType) ? "binary" : this.nameForType(((TypeIdentifier.ArrayOf)typeIdentifier).getComponentType()) + (((TypeIdentifier.ArrayOf)typeIdentifier).getComponentType() instanceof TypeIdentifier.Unparameterised && ((TypeIdentifier.Unparameterised)((TypeIdentifier.ArrayOf)typeIdentifier).getComponentType()).isPrimitive() ? "[p]" : "[]");
        } else if (typeIdentifier2 instanceof TypeIdentifier.Parameterised) {
            string = typeIdentifier.getName() + CollectionsKt.joinToString$default((Iterable)((TypeIdentifier.Parameterised)typeIdentifier).getParameters(), (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)nameForType.1.INSTANCE, (int)24, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String nameForType(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.nameForType(TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, type, null, 2, null));
    }

    private AMQPTypeIdentifiers() {
    }

    static {
        AMQPTypeIdentifiers aMQPTypeIdentifiers;
        INSTANCE = aMQPTypeIdentifiers = new AMQPTypeIdentifiers();
        primitiveTypeNamesByName = MapsKt.toMap((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sequenceOf((Object[])new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Character.class), (Object)"char"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Character.TYPE), (Object)"char"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)"boolean"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Byte.TYPE), (Object)"byte"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UnsignedByte.class), (Object)"ubyte"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Short.TYPE), (Object)"short"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UnsignedShort.class), (Object)"ushort"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)"int"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UnsignedInteger.class), (Object)"uint"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)"long"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UnsignedLong.class), (Object)"ulong"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Float.TYPE), (Object)"float"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Double.TYPE), (Object)"double"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Decimal32.class), (Object)"decimal32"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Decimal64.class), (Object)"decimal64"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Decimal128.class), (Object)"decimal128"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Date.class), (Object)"timestamp"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UUID.class), (Object)"uuid"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(byte[].class), (Object)"binary"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)"string"), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Symbol.class), (Object)"symbol")}), (Function1)primitiveTypeNamesByName.1.INSTANCE));
        Class<Byte> clazz = Byte.TYPE;
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        primitiveByteArrayType = new TypeIdentifier.ArrayOf(TypeIdentifier.Companion.forClass(clazz));
    }
}

