/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.DeleteForDJVM;
import net.corda.core.KeepForDJVM;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ObjectWithCompatibleContext;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.serialization.internal.CustomSerializationSchemeUtils;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.CordaSerializationMagic;
import net.corda.serialization.internal.SerializationFactoryImpl;
import net.corda.serialization.internal.SerializationScheme;
import net.corda.serialization.internal.amqp.SchemaKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B%\u0012\u001e\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0004\u0012\u00020\b0\u0004\u00a2\u0006\u0002\u0010\tJ5\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ6\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001d\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bJ$\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007H\u0002J-\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00130*\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010+\u001a\u0002H\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020.H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/corda/serialization/internal/SerializationFactoryImpl;", "Lnet/corda/core/serialization/SerializationFactory;", "()V", "schemes", "", "Lkotlin/Pair;", "Lnet/corda/serialization/internal/CordaSerializationMagic;", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "Lnet/corda/serialization/internal/SerializationScheme;", "(Ljava/util/Map;)V", "creator", "", "Ljava/lang/StackTraceElement;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "registeredSchemes", "", "deserialize", "T", "", "byteSequence", "Lnet/corda/core/utilities/ByteSequence;", "clazz", "Ljava/lang/Class;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "deserializeWithCompatibleContext", "Lnet/corda/core/serialization/ObjectWithCompatibleContext;", "equals", "", "other", "getRegisteredSchemes", "hashCode", "", "registerScheme", "", "scheme", "schemeFor", "target", "serialize", "Lnet/corda/core/serialization/SerializedBytes;", "obj", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "toString", "", "Companion", "serialization"})
@KeepForDJVM
public class SerializationFactoryImpl
extends SerializationFactory {
    private final List<StackTraceElement> creator;
    private final Collection<SerializationScheme> registeredSchemes;
    private final Logger logger;
    private final Map<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme> schemes;
    private static final int magicSize;
    public static final Companion Companion;

    @NotNull
    public final Collection<SerializationScheme> getRegisteredSchemes() {
        return this.registeredSchemes;
    }

    private final Pair<SerializationScheme, CordaSerializationMagic> schemeFor(ByteSequence byteSequence, SerializationContext.UseCase target) {
        CordaSerializationMagic magic = new CordaSerializationMagic(InternalUtils.copyBytes((ByteBuffer)ByteSequence.slice$default((ByteSequence)byteSequence, (int)0, (int)magicSize, (int)1, null)));
        Pair lookupKey = TuplesKt.to((Object)((Object)magic), (Object)target);
        SerializationScheme serializationScheme = this.schemes.get(lookupKey);
        if (serializationScheme == null) {
            SerializationScheme serializationScheme2 = this.schemes.computeIfAbsent((Pair<CordaSerializationMagic, SerializationContext.UseCase>)lookupKey, (Function<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme>)new Function<Pair<? extends CordaSerializationMagic, ? extends SerializationContext.UseCase>, SerializationScheme>(this, magic, target, lookupKey){
                final /* synthetic */ SerializationFactoryImpl this$0;
                final /* synthetic */ CordaSerializationMagic $magic;
                final /* synthetic */ SerializationContext.UseCase $target;
                final /* synthetic */ Pair $lookupKey;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final SerializationScheme apply(@NotNull Pair<CordaSerializationMagic, ? extends SerializationContext.UseCase> it) {
                    void $receiver$iv$iv;
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Iterable $receiver$iv = SerializationFactoryImpl.access$getRegisteredSchemes$p(this.this$0);
                    Iterator<T> iterator = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        SerializationScheme it2 = (SerializationScheme)element$iv$iv;
                        if (!it2.canDeserializeVersion(this.$magic, this.$target)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    iterator = $receiver$iv.iterator();
                    if (iterator.hasNext()) {
                        E element$iv = iterator.next();
                        SerializationScheme it3 = (SerializationScheme)element$iv;
                        return it3;
                    }
                    SerializationFactoryImpl.access$getLogger$p(this.this$0).warn("Cannot find serialization scheme for: [" + this.$lookupKey + ", " + (Intrinsics.areEqual((Object)((Object)this.$magic), (Object)((Object)SchemaKt.getAmqpMagic())) ? "AMQP" : "UNKNOWN MAGIC") + "] registeredSchemes are: " + SerializationFactoryImpl.access$getRegisteredSchemes$p(this.this$0));
                    Integer n = CustomSerializationSchemeUtils.Companion.getSchemeIdIfCustomSerializationMagic((ByteSequence)this.$magic);
                    if (n == null) {
                        throw (Throwable)new UnsupportedOperationException("Serialization scheme" + ' ' + this.$lookupKey + " not supported.");
                    }
                    int schemeId = n;
                    throw (Throwable)new UnsupportedOperationException("Could not find custom serialization scheme with SchemeId = " + schemeId + '.');
                }
                {
                    this.this$0 = serializationFactoryImpl;
                    this.$magic = cordaSerializationMagic;
                    this.$target = useCase;
                    this.$lookupKey = pair;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)serializationScheme2, (String)"schemes.computeIfAbsent(\u2026 = $schemeId.\")\n        }");
            serializationScheme = serializationScheme2;
        }
        return TuplesKt.to((Object)serializationScheme, (Object)((Object)magic));
    }

    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (T)this.asCurrent(new Function1<SerializationFactory, T>(this, context, byteSequence, clazz){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ ByteSequence $byteSequence;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final T invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (T)$receiver.withCurrentContext(this.$context, (Function0)new Function0<T>(this){
                    final /* synthetic */ deserialize.1 this$0;

                    @NotNull
                    public final T invoke() {
                        return ((SerializationScheme)SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$byteSequence, this.this$0.$context.getUseCase()).getFirst()).deserialize(this.this$0.$byteSequence, this.this$0.$clazz, this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$byteSequence = byteSequence;
                this.$clazz = clazz;
                super(1);
            }
        });
    }

    @NotNull
    public <T> ObjectWithCompatibleContext<T> deserializeWithCompatibleContext(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (ObjectWithCompatibleContext)this.asCurrent(new Function1<SerializationFactory, ObjectWithCompatibleContext<? extends T>>(this, context, byteSequence, clazz){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ ByteSequence $byteSequence;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final ObjectWithCompatibleContext<T> invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (ObjectWithCompatibleContext)$receiver.withCurrentContext(this.$context, (Function0)new Function0<ObjectWithCompatibleContext<? extends T>>(this){
                    final /* synthetic */ deserializeWithCompatibleContext.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final ObjectWithCompatibleContext<T> invoke() {
                        void scheme;
                        Pair pair = SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$byteSequence, this.this$0.$context.getUseCase());
                        SerializationScheme serializationScheme = (SerializationScheme)pair.component1();
                        CordaSerializationMagic magic = (CordaSerializationMagic)((Object)pair.component2());
                        T deserializedObject = scheme.deserialize(this.this$0.$byteSequence, this.this$0.$clazz, this.this$0.$context);
                        return new ObjectWithCompatibleContext(deserializedObject, this.this$0.$context.withPreferredSerializationVersion((ByteSequence)magic));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$byteSequence = byteSequence;
                this.$clazz = clazz;
                super(1);
            }
        });
    }

    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (SerializedBytes)this.asCurrent(new Function1<SerializationFactory, SerializedBytes<T>>(this, context, obj){
            final /* synthetic */ SerializationFactoryImpl this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ Object $obj;

            @NotNull
            public final SerializedBytes<T> invoke(@NotNull SerializationFactory $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (SerializedBytes)$receiver.withCurrentContext(this.$context, (Function0)new Function0<SerializedBytes<T>>(this){
                    final /* synthetic */ serialize.1 this$0;

                    @NotNull
                    public final SerializedBytes<T> invoke() {
                        return ((SerializationScheme)SerializationFactoryImpl.access$schemeFor(this.this$0.this$0, this.this$0.$context.getPreferredSerializationVersion(), this.this$0.$context.getUseCase()).getFirst()).serialize(this.this$0.$obj, this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = serializationFactoryImpl;
                this.$context = serializationContext;
                this.$obj = object;
                super(1);
            }
        });
    }

    public final void registerScheme(@NotNull SerializationScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        boolean bl = this.schemes.isEmpty();
        if (!bl) {
            String string = "All serialization schemes must be registered before any scheme is used.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Collection<SerializationScheme> collection = this.registeredSchemes;
        collection.add(scheme);
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " registeredSchemes=" + this.registeredSchemes + ' ' + CollectionsKt.joinToString$default((Iterable)this.creator, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SerializationFactoryImpl && Intrinsics.areEqual(((SerializationFactoryImpl)((Object)other)).registeredSchemes, this.registeredSchemes);
    }

    public int hashCode() {
        return ((Object)this.registeredSchemes).hashCode();
    }

    public SerializationFactoryImpl(@NotNull Map<Pair<CordaSerializationMagic, SerializationContext.UseCase>, SerializationScheme> schemes) {
        Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
        this.schemes = schemes;
        Object[] objectArray = new Exception().getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Exception().stackTrace");
        this.creator = ArraysKt.asList((Object[])objectArray);
        SerializationFactoryImpl serializationFactoryImpl = this;
        List list = new ArrayList();
        Collection collection = Collections.synchronizedCollection(list);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.synchronized\u2026llection(mutableListOf())");
        serializationFactoryImpl.registeredSchemes = collection;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @DeleteForDJVM
    public SerializationFactoryImpl() {
        this(new ConcurrentHashMap());
    }

    static {
        Companion = new Companion(null);
        magicSize = SchemaKt.getAmqpMagic().getSize();
    }

    @NotNull
    public static final /* synthetic */ Collection access$getRegisteredSchemes$p(SerializationFactoryImpl $this) {
        return $this.registeredSchemes;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SerializationFactoryImpl $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Pair access$schemeFor(SerializationFactoryImpl $this, @NotNull ByteSequence byteSequence, @NotNull SerializationContext.UseCase target) {
        return $this.schemeFor(byteSequence, target);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/SerializationFactoryImpl$Companion;", "", "()V", "magicSize", "", "getMagicSize", "()I", "serialization"})
    public static final class Companion {
        public final int getMagicSize() {
            return magicSize;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

