/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.EOFException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.corda.core.KeepForDJVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/OrdinalReader;", "E", "", "values", "", "([Ljava/lang/Object;)V", "enumName", "", "kotlin.jvm.PlatformType", "range", "Lkotlin/ranges/IntRange;", "[Ljava/lang/Object;", "readFrom", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Ljava/lang/Object;", "serialization"})
@KeepForDJVM
public final class OrdinalReader<E> {
    private final String enumName;
    private final IntRange range;
    private final E[] values;

    @NotNull
    public final E readFrom(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        int ordinal = stream.read();
        if (ordinal == -1) {
            throw (Throwable)new EOFException("Expected a " + this.enumName + " ordinal.");
        }
        if (!this.range.contains(ordinal)) {
            throw (Throwable)new NoSuchElementException("No " + this.enumName + " with ordinal: " + ordinal);
        }
        return this.values[ordinal];
    }

    public OrdinalReader(@NotNull E[] values) {
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        this.values = values;
        this.enumName = this.values[0].getClass().getSimpleName();
        this.range = RangesKt.until((int)0, (int)this.values.length);
    }
}

