/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.DeleteForDJVM;
import net.corda.core.node.ServiceHub;
import net.corda.core.serialization.SerializeAsToken;
import net.corda.core.serialization.SerializeAsTokenContext;
import net.corda.core.serialization.internal.CheckpointSerializationContext;
import net.corda.core.serialization.internal.CheckpointSerializer;
import net.corda.serialization.internal.SerializeAsTokenContextImplKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB&\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0013H\u0016R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lnet/corda/serialization/internal/CheckpointSerializeAsTokenContextImpl;", "Lnet/corda/core/serialization/SerializeAsTokenContext;", "toBeTokenized", "", "serializer", "Lnet/corda/core/serialization/internal/CheckpointSerializer;", "context", "Lnet/corda/core/serialization/internal/CheckpointSerializationContext;", "serviceHub", "Lnet/corda/core/node/ServiceHub;", "(Ljava/lang/Object;Lnet/corda/core/serialization/internal/CheckpointSerializer;Lnet/corda/core/serialization/internal/CheckpointSerializationContext;Lnet/corda/core/node/ServiceHub;)V", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lnet/corda/core/node/ServiceHub;Lkotlin/jvm/functions/Function1;)V", "classNameToSingleton", "", "", "Lnet/corda/core/serialization/SerializeAsToken;", "readOnly", "", "getServiceHub", "()Lnet/corda/core/node/ServiceHub;", "getSingleton", "className", "putSingleton", "serialization"})
@DeleteForDJVM
public final class CheckpointSerializeAsTokenContextImpl
implements SerializeAsTokenContext {
    private final Map<String, SerializeAsToken> classNameToSingleton;
    private boolean readOnly;
    @NotNull
    private final ServiceHub serviceHub;

    public void putSingleton(@NotNull SerializeAsToken toBeTokenized) {
        Intrinsics.checkParameterIsNotNull((Object)toBeTokenized, (String)"toBeTokenized");
        String className = toBeTokenized.getClass().getName();
        Map<String, SerializeAsToken> map = this.classNameToSingleton;
        Object object = map;
        if (!object.containsKey(className)) {
            if (this.readOnly) {
                throw (Throwable)new UnsupportedOperationException("Attempt to write token for lazy registered " + className + ". All tokens should be registered during context construction.");
            }
            map = this.classNameToSingleton;
            String string = className;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
            object = string;
            SerializeAsToken serializeAsToken = toBeTokenized;
            map.put((String)object, serializeAsToken);
        }
    }

    @NotNull
    public SerializeAsToken getSingleton(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        SerializeAsToken serializeAsToken = this.classNameToSingleton.get(className);
        if (serializeAsToken == null) {
            throw (Throwable)new IllegalStateException("Unable to find tokenized instance of " + className + " in context " + this);
        }
        return serializeAsToken;
    }

    @NotNull
    public ServiceHub getServiceHub() {
        return this.serviceHub;
    }

    public CheckpointSerializeAsTokenContextImpl(@NotNull ServiceHub serviceHub, @NotNull Function1<? super SerializeAsTokenContext, Unit> init) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)serviceHub, (String)"serviceHub");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this.serviceHub = serviceHub;
        CheckpointSerializeAsTokenContextImpl checkpointSerializeAsTokenContextImpl = this;
        checkpointSerializeAsTokenContextImpl.classNameToSingleton = map = (Map)new LinkedHashMap();
        init.invoke((Object)this);
        this.readOnly = true;
    }

    public CheckpointSerializeAsTokenContextImpl(final @NotNull Object toBeTokenized, final @NotNull CheckpointSerializer serializer2, final @NotNull CheckpointSerializationContext context, @NotNull ServiceHub serviceHub) {
        Intrinsics.checkParameterIsNotNull((Object)toBeTokenized, (String)"toBeTokenized");
        Intrinsics.checkParameterIsNotNull((Object)serializer2, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)serviceHub, (String)"serviceHub");
        this(serviceHub, (Function1<? super SerializeAsTokenContext, Unit>)((Function1)new Function1<SerializeAsTokenContext, Unit>(){

            public final void invoke(@NotNull SerializeAsTokenContext $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                serializer2.serialize(toBeTokenized, SerializeAsTokenContextImplKt.withTokenContext(context, $receiver));
            }
        }));
    }
}

