/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.ClassLoadingUtilsKt;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.core.serialization.SerializationWhitelist;
import net.corda.core.serialization.internal.SerializationEnvironmentKt;
import net.corda.nodeapi.internal.rpc.client.AMQPClientSerializationScheme;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0016\u0010\u0007\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/client/rpc/internal/SerializationEnvironmentHelper;", "", "()V", "ensureEffectiveSerializationEnvSet", "", "classLoader", "Ljava/lang/ClassLoader;", "customSerializers", "", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "ensureEffectiveSerializationEnvSet$rpc", "rpc"})
public final class SerializationEnvironmentHelper {
    public static final SerializationEnvironmentHelper INSTANCE;

    public final void ensureEffectiveSerializationEnvSet$rpc(@Nullable ClassLoader classLoader, @Nullable Set<? extends SerializationCustomSerializer<?, ?>> customSerializers) {
        try {
            SerializationEnvironmentKt.getEffectiveSerializationEnv();
        }
        catch (IllegalStateException e) {
            try {
                Set set;
                ClassLoader serializationClassLoader;
                ConcurrentMap cache = Caffeine.newBuilder().maximumSize(128L).build().asMap();
                ClassLoader classLoader2 = classLoader;
                if (classLoader2 == null) {
                    classLoader2 = serializationClassLoader = this.getClass().getClassLoader();
                }
                if ((set = customSerializers) == null) {
                    ClassLoader classLoader3 = serializationClassLoader;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classLoader3, (String)"serializationClassLoader");
                    set = ClassLoadingUtilsKt.createInstancesOfClassesImplementing$default((ClassLoader)classLoader3, SerializationCustomSerializer.class, null, (int)4, null);
                }
                Set discoveredCustomSerializers = set;
                ServiceLoader<SerializationWhitelist> serviceLoader = ServiceLoader.load(SerializationWhitelist.class, serializationClassLoader);
                Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(\n    \u2026sLoader\n                )");
                Set serializationWhitelists = CollectionsKt.toSet((Iterable)serviceLoader);
                ConcurrentMap concurrentMap = cache;
                Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"cache");
                AMQPClientSerializationScheme.Companion.initialiseSerialization(serializationClassLoader, discoveredCustomSerializers, serializationWhitelists, (Map)concurrentMap);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private SerializationEnvironmentHelper() {
    }

    static {
        SerializationEnvironmentHelper serializationEnvironmentHelper;
        INSTANCE = serializationEnvironmentHelper = new SerializationEnvironmentHelper();
    }
}

