/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc.internal;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.nodeapi.RPCApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\n\u0010\u0007\u001a\u00020\u0004*\u00020\bJ\n\u0010\t\u001a\u00020\u0004*\u00020\nJ\n\u0010\u000b\u001a\u00020\u0004*\u00020\bJ\n\u0010\f\u001a\u00020\u0004*\u00020\b\u00a8\u0006\r"}, d2={"Lnet/corda/client/rpc/internal/RPCUtils;", "", "()V", "isShutdownMethodName", "", "methodName", "", "isShutdown", "Ljava/lang/reflect/Method;", "isShutdownCmd", "Lnet/corda/nodeapi/RPCApi$ClientToServer$RpcRequest;", "isStartFlow", "isStartFlowWithClientId", "rpc"})
public final class RPCUtils {
    public static final RPCUtils INSTANCE;

    public final boolean isShutdownMethodName(@NotNull String methodName) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        return StringsKt.equals((String)methodName, (String)"shutdown", (boolean)true) || StringsKt.equals((String)methodName, (String)"gracefulShutdown", (boolean)true) || StringsKt.equals((String)methodName, (String)"terminate", (boolean)true);
    }

    public final boolean isShutdownCmd(@NotNull RPCApi.ClientToServer.RpcRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.isShutdownMethodName($receiver.getMethodName());
    }

    public final boolean isShutdown(@NotNull Method $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return this.isShutdownMethodName(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isStartFlow(@NotNull Method $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        if (StringsKt.startsWith$default((String)string, (String)"startFlow", (boolean)false, (int)2, null)) return true;
        String string2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        if (!StringsKt.startsWith$default((String)string2, (String)"startTrackedFlow", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isStartFlowWithClientId(@NotNull Method $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)"startFlowWithClientId") || Intrinsics.areEqual((Object)$receiver.getName(), (Object)"startFlowDynamicWithClientId");
    }

    private RPCUtils() {
    }

    static {
        RPCUtils rPCUtils;
        INSTANCE = rPCUtils = new RPCUtils();
    }
}

