/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.rpc;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.client.rpc.CordaRPCClientConfiguration;
import net.corda.client.rpc.GracefulReconnect;
import net.corda.client.rpc.RPCConnection;
import net.corda.client.rpc.internal.ReconnectingCordaRPCOps;
import net.corda.core.CordaInternal;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.utilities.NetworkHostAndPort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\b\u0010\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0004B+\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0082\bJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lnet/corda/client/rpc/CordaRPCConnection;", "Lnet/corda/client/rpc/RPCConnection;", "Lnet/corda/core/messaging/CordaRPCOps;", "connection", "(Lnet/corda/client/rpc/RPCConnection;)V", "oneTimeConnection", "observersPool", "Ljava/util/concurrent/ExecutorService;", "reconnectingCordaRPCOps", "Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps;", "(Lnet/corda/client/rpc/RPCConnection;Ljava/util/concurrent/ExecutorService;Lnet/corda/client/rpc/internal/ReconnectingCordaRPCOps;)V", "actualConnection", "getActualConnection", "()Lnet/corda/client/rpc/RPCConnection;", "proxy", "getProxy", "()Lnet/corda/core/messaging/CordaRPCOps;", "serverProtocolVersion", "", "getServerProtocolVersion", "()I", "doCloseLogic", "", "close", "Lkotlin/Function0;", "forceClose", "notifyServerAndClose", "Companion", "rpc"})
public final class CordaRPCConnection
implements RPCConnection<CordaRPCOps> {
    private final RPCConnection<CordaRPCOps> oneTimeConnection;
    private final ExecutorService observersPool;
    private final ReconnectingCordaRPCOps reconnectingCordaRPCOps;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public CordaRPCOps getProxy() {
        CordaRPCOps cordaRPCOps;
        ReconnectingCordaRPCOps reconnectingCordaRPCOps = this.reconnectingCordaRPCOps;
        if (reconnectingCordaRPCOps != null) {
            cordaRPCOps = reconnectingCordaRPCOps;
        } else {
            RPCConnection<CordaRPCOps> rPCConnection = this.oneTimeConnection;
            if (rPCConnection == null) {
                Intrinsics.throwNpe();
            }
            cordaRPCOps = rPCConnection.getProxy();
        }
        return cordaRPCOps;
    }

    private final RPCConnection<CordaRPCOps> getActualConnection() {
        RPCConnection<CordaRPCOps> rPCConnection;
        Object object = this.reconnectingCordaRPCOps;
        if (object != null && (object = ((ReconnectingCordaRPCOps)object).getReconnectingRPCConnection()) != null) {
            rPCConnection = (RPCConnection<CordaRPCOps>)object;
        } else {
            rPCConnection = this.oneTimeConnection;
            if (rPCConnection == null) {
                Intrinsics.throwNpe();
            }
        }
        return rPCConnection;
    }

    @Override
    public int getServerProtocolVersion() {
        return this.getActualConnection().getServerProtocolVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServerAndClose() {
        CordaRPCConnection this_$iv = this;
        try {
            this.getActualConnection().notifyServerAndClose();
        }
        finally {
            ExecutorService executorService = this_$iv.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $receiver$iv = executorService2 = executorService;
                $receiver$iv.shutdown();
                if (!$receiver$iv.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $receiver$iv.shutdownNow();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceClose() {
        CordaRPCConnection this_$iv = this;
        try {
            this.getActualConnection().forceClose();
        }
        finally {
            ExecutorService executorService = this_$iv.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $receiver$iv = executorService2 = executorService;
                $receiver$iv.shutdown();
                if (!$receiver$iv.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $receiver$iv.shutdownNow();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doCloseLogic(Function0<Unit> close) {
        try {
            close.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ExecutorService executorService = this.observersPool;
            if (executorService != null) {
                ExecutorService executorService2;
                ExecutorService $receiver = executorService2 = executorService;
                $receiver.shutdown();
                if (!$receiver.awaitTermination(30L, TimeUnit.SECONDS)) {
                    $receiver.shutdownNow();
                }
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    private CordaRPCConnection(RPCConnection<? extends CordaRPCOps> oneTimeConnection, ExecutorService observersPool, ReconnectingCordaRPCOps reconnectingCordaRPCOps) {
        this.oneTimeConnection = oneTimeConnection;
        this.observersPool = observersPool;
        this.reconnectingCordaRPCOps = reconnectingCordaRPCOps;
    }

    public CordaRPCConnection(@Nullable RPCConnection<? extends CordaRPCOps> connection2) {
        this(connection2, null, null);
    }

    @Override
    public void close() {
        RPCConnection.DefaultImpls.close(this);
    }

    public /* synthetic */ CordaRPCConnection(@Nullable RPCConnection oneTimeConnection, @Nullable ExecutorService observersPool, @Nullable ReconnectingCordaRPCOps reconnectingCordaRPCOps, DefaultConstructorMarker $constructor_marker) {
        this(oneTimeConnection, observersPool, reconnectingCordaRPCOps);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lnet/corda/client/rpc/CordaRPCConnection$Companion;", "", "()V", "createWithGracefulReconnection", "Lnet/corda/client/rpc/CordaRPCConnection;", "username", "", "password", "addresses", "", "Lnet/corda/core/utilities/NetworkHostAndPort;", "rpcConfiguration", "Lnet/corda/client/rpc/CordaRPCClientConfiguration;", "gracefulReconnect", "Lnet/corda/client/rpc/GracefulReconnect;", "sslConfiguration", "Lnet/corda/core/messaging/ClientRpcSslOptions;", "classLoader", "Ljava/lang/ClassLoader;", "createWithGracefulReconnection$rpc", "rpc"})
    public static final class Companion {
        @CordaInternal
        @NotNull
        public final CordaRPCConnection createWithGracefulReconnection$rpc(@NotNull String username, @NotNull String password, @NotNull List<NetworkHostAndPort> addresses, @NotNull CordaRPCClientConfiguration rpcConfiguration, @NotNull GracefulReconnect gracefulReconnect, @Nullable ClientRpcSslOptions sslConfiguration, @Nullable ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Intrinsics.checkParameterIsNotNull(addresses, (String)"addresses");
            Intrinsics.checkParameterIsNotNull((Object)rpcConfiguration, (String)"rpcConfiguration");
            Intrinsics.checkParameterIsNotNull((Object)gracefulReconnect, (String)"gracefulReconnect");
            ExecutorService executorService = Executors.newCachedThreadPool();
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
            ExecutorService observersPool = executorService;
            return new CordaRPCConnection(null, observersPool, new ReconnectingCordaRPCOps(addresses, username, password, rpcConfiguration, gracefulReconnect, sslConfiguration, classLoader, observersPool), null);
        }

        @CordaInternal
        @NotNull
        public static /* bridge */ /* synthetic */ CordaRPCConnection createWithGracefulReconnection$rpc$default(Companion companion, String string, String string2, List list, CordaRPCClientConfiguration cordaRPCClientConfiguration, GracefulReconnect gracefulReconnect, ClientRpcSslOptions clientRpcSslOptions, ClassLoader classLoader, int n, Object object) {
            if ((n & 0x20) != 0) {
                clientRpcSslOptions = null;
            }
            if ((n & 0x40) != 0) {
                classLoader = null;
            }
            return companion.createWithGracefulReconnection$rpc(string, string2, list, cordaRPCClientConfiguration, gracefulReconnect, clientRpcSslOptions, classLoader);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

