/*
 * Decompiled with CFR 0.152.
 */
package net.corda.common.configuration.parsing.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.corda.common.configuration.parsing.internal.Configuration;
import net.corda.common.configuration.parsing.internal.LongProperty;
import net.corda.common.configuration.parsing.internal.PropertyDelegate;
import net.corda.common.configuration.parsing.internal.StandardProperty;
import net.corda.common.configuration.parsing.internal.UtilsKt;
import net.corda.common.configuration.parsing.internal.versioned.VersionExtractor;
import net.corda.common.validation.internal.Validated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0003\u0004\u0005\u0006\u0007\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\f"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration;", "", "()V", "Describer", "Options", "Property", "Schema", "Specification", "Validation", "Validator", "Value", "Version", "common-configuration-parsing"})
public final class Configuration {
    public static final Configuration INSTANCE;

    private Configuration() {
    }

    static {
        Configuration configuration;
        INSTANCE = configuration = new Configuration();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Describer;", "", "describe", "Lcom/typesafe/config/ConfigValue;", "configuration", "Lcom/typesafe/config/Config;", "serialiseValue", "Lkotlin/Function1;", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "common-configuration-parsing"})
    public static interface Describer {
        @Nullable
        public ConfigValue describe(@NotNull Config var1, @NotNull Function1<Object, ? extends ConfigValue> var2, @NotNull Options var3);

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
        public static final class DefaultImpls {
            @Nullable
            public static /* bridge */ /* synthetic */ ConfigValue describe$default(Describer describer, Config config, Function1 function1, Options options, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: describe");
                }
                if ((n & 2) != 0) {
                    function1 = describe.1.INSTANCE;
                }
                return describer.describe(config, (Function1<Object, ? extends ConfigValue>)function1, options);
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Value;", "", "()V", "Extractor", "Parser", "common-configuration-parsing"})
    public static final class Value {
        public static final Value INSTANCE;

        private Value() {
        }

        static {
            Value value;
            INSTANCE = value = new Value();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u001d\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Extractor;", "TYPE", "", "isSpecifiedBy", "", "configuration", "Lcom/typesafe/config/Config;", "valueIn", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "(Lcom/typesafe/config/Config;Lnet/corda/common/configuration/parsing/internal/Configuration$Options;)Ljava/lang/Object;", "valueInOrNull", "common-configuration-parsing"})
        public static interface Extractor<TYPE> {
            public TYPE valueIn(@NotNull Config var1, @NotNull Options var2) throws ConfigException.Missing, ConfigException.WrongType, ConfigException.BadValue;

            public boolean isSpecifiedBy(@NotNull Config var1);

            @Nullable
            public TYPE valueInOrNull(@NotNull Config var1, @NotNull Options var2) throws ConfigException.WrongType, ConfigException.BadValue;

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
            public static final class DefaultImpls {
                @Nullable
                public static <TYPE> TYPE valueInOrNull(Extractor<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                    Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                    Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                    return $this.isSpecifiedBy(configuration) ? (TYPE)$this.valueIn(configuration, options) : null;
                }
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J0\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Parser;", "VALUE", "", "parse", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "Lnet/corda/common/configuration/parsing/internal/Valid;", "configuration", "Lcom/typesafe/config/Config;", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "common-configuration-parsing"})
        public static interface Parser<VALUE> {
            @NotNull
            public Validated<VALUE, Validation.Error> parse(@NotNull Config var1, @NotNull Options var2);

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
            public static final class DefaultImpls {
                @NotNull
                public static /* bridge */ /* synthetic */ Validated parse$default(Parser parser, Config config, Options options, int n, Object object) {
                    if (object != null) {
                        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parse");
                    }
                    if ((n & 2) != 0) {
                        options = Options.Companion.getDefaults();
                    }
                    return parser.parse(config, options);
                }
            }
        }
    }

    @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property;", "", "()V", "Definition", "Metadata", "common-configuration-parsing"})
    public static final class Property {
        public static final Property INSTANCE;

        private Property() {
        }

        static {
            Property property;
            INSTANCE = property = new Property();
        }

        @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Metadata;", "", "isMandatory", "", "()Z", "isSensitive", "key", "", "getKey", "()Ljava/lang/String;", "schema", "Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "getSchema", "()Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "typeName", "getTypeName", "common-configuration-parsing"})
        public static interface Metadata {
            @NotNull
            public String getKey();

            @NotNull
            public String getTypeName();

            public boolean isMandatory();

            public boolean isSensitive();

            @Nullable
            public Schema getSchema();
        }

        @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u0010*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u00052\b\u0012\u0004\u0012\u0002H\u00010\u0006:\u0006\u0010\u0011\u0012\u0013\u0014\u0015J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Metadata;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validator;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Extractor;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Describer;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Parser;", "isSpecifiedBy", "", "configuration", "Lcom/typesafe/config/Config;", "parse", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "Companion", "Optional", "Required", "RequiredList", "Single", "Standard", "common-configuration-parsing"})
        public static interface Definition<TYPE>
        extends Metadata,
        Validator,
        Value.Extractor<TYPE>,
        Describer,
        Value.Parser<TYPE> {
            public static final Companion Companion = Companion.$$INSTANCE;
            @NotNull
            public static final String SENSITIVE_DATA_PLACEHOLDER = "*****";

            @Override
            public boolean isSpecifiedBy(@NotNull Config var1);

            @Override
            @NotNull
            public Validated<TYPE, Validation.Error> parse(@NotNull Config var1, @NotNull Options var2);

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H&\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Required;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "optional", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;", "common-configuration-parsing"})
            public static interface Required<TYPE>
            extends Definition<TYPE> {
                @NotNull
                public Optional<TYPE> optional();

                @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
                public static final class DefaultImpls {
                    public static <TYPE> boolean isSpecifiedBy(Required<TYPE> $this, @NotNull Config configuration) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.isSpecifiedBy($this, configuration);
                    }

                    @NotNull
                    public static <TYPE> Validated<TYPE, Validation.Error> parse(Required<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.parse($this, configuration, options);
                    }

                    @Nullable
                    public static <TYPE> TYPE valueInOrNull(Required<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.valueInOrNull($this, configuration, options);
                    }
                }
            }

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0002\"\u0004\b\u0002\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0004\u0012\u0002H\u00050\tH\u0016JB\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0002\"\u0004\b\u0002\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072$\u0010\b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\f0\u000b0\tH&\u00a8\u0006\r"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$RequiredList;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Required;", "", "map", "MAPPED", "mappedTypeName", "", "convert", "Lkotlin/Function1;", "mapValid", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "common-configuration-parsing"})
            public static interface RequiredList<TYPE>
            extends Required<List<? extends TYPE>> {
                @NotNull
                public <MAPPED> Required<MAPPED> mapValid(@NotNull String var1, @NotNull Function1<? super List<? extends TYPE>, ? extends Validated<MAPPED, Validation.Error>> var2);

                @NotNull
                public <MAPPED> Required<MAPPED> map(@NotNull String var1, @NotNull Function1<? super List<? extends TYPE>, ? extends MAPPED> var2);

                @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
                public static final class DefaultImpls {
                    @NotNull
                    public static <TYPE, MAPPED> Required<MAPPED> map(RequiredList<TYPE> $this, @NotNull String mappedTypeName, @NotNull Function1<? super List<? extends TYPE>, ? extends MAPPED> convert) {
                        Intrinsics.checkParameterIsNotNull((Object)mappedTypeName, (String)"mappedTypeName");
                        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                        return $this.mapValid(mappedTypeName, (Function1)new Function1<List<? extends TYPE>, Validated.Result<MAPPED, Validation.Error>>(convert){
                            final /* synthetic */ Function1 $convert;

                            @NotNull
                            public final Validated.Result<MAPPED, Validation.Error> invoke(@NotNull List<? extends TYPE> value) {
                                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                                return UtilsKt.valid(this.$convert.invoke(value));
                            }
                            {
                                this.$convert = function1;
                                super(1);
                            }
                        });
                    }

                    public static <TYPE> boolean isSpecifiedBy(RequiredList<TYPE> $this, @NotNull Config configuration) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        return Required.DefaultImpls.isSpecifiedBy((Required)$this, configuration);
                    }

                    @NotNull
                    public static <TYPE> Validated<List<TYPE>, Validation.Error> parse(RequiredList<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return Required.DefaultImpls.parse((Required)$this, configuration, options);
                    }

                    @Nullable
                    public static <TYPE> List<TYPE> valueInOrNull(RequiredList<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return (List)Required.DefaultImpls.valueInOrNull((Required)$this, configuration, options);
                    }
                }
            }

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H&\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Single;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "list", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$RequiredList;", "common-configuration-parsing"})
            public static interface Single<TYPE>
            extends Definition<TYPE> {
                @NotNull
                public RequiredList<TYPE> list();

                @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
                public static final class DefaultImpls {
                    public static <TYPE> boolean isSpecifiedBy(Single<TYPE> $this, @NotNull Config configuration) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.isSpecifiedBy($this, configuration);
                    }

                    @NotNull
                    public static <TYPE> Validated<TYPE, Validation.Error> parse(Single<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.parse($this, configuration, options);
                    }

                    @Nullable
                    public static <TYPE> TYPE valueInOrNull(Single<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.valueInOrNull($this, configuration, options);
                    }
                }
            }

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u0004\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Optional;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "withDefaultValue", "defaultValue", "(Ljava/lang/Object;)Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "common-configuration-parsing"})
            public static interface Optional<TYPE>
            extends Definition<TYPE> {
                @NotNull
                public Definition<TYPE> withDefaultValue(TYPE var1);

                @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
                public static final class DefaultImpls {
                    public static <TYPE> boolean isSpecifiedBy(Optional<TYPE> $this, @NotNull Config configuration) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.isSpecifiedBy($this, configuration);
                    }

                    @NotNull
                    public static <TYPE> Validated<TYPE, Validation.Error> parse(Optional<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.parse($this, configuration, options);
                    }

                    @Nullable
                    public static <TYPE> TYPE valueInOrNull(Optional<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return net.corda.common.configuration.parsing.internal.Configuration$Property$Definition$DefaultImpls.valueInOrNull($this, configuration, options);
                    }
                }
            }

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000\"\u0004\b\u0002\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00050\tH\u0016J<\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000\"\u0004\b\u0002\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\f0\u000b0\tH&\u00a8\u0006\r"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;", "TYPE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Required;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Single;", "map", "MAPPED", "mappedTypeName", "", "convert", "Lkotlin/Function1;", "mapValid", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "common-configuration-parsing"})
            public static interface Standard<TYPE>
            extends Required<TYPE>,
            Single<TYPE> {
                @NotNull
                public <MAPPED> Standard<MAPPED> mapValid(@NotNull String var1, @NotNull Function1<? super TYPE, ? extends Validated<MAPPED, Validation.Error>> var2);

                @NotNull
                public <MAPPED> Standard<MAPPED> map(@NotNull String var1, @NotNull Function1<? super TYPE, ? extends MAPPED> var2);

                @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
                public static final class DefaultImpls {
                    @NotNull
                    public static <TYPE, MAPPED> Standard<MAPPED> map(Standard<TYPE> $this, @NotNull String mappedTypeName, @NotNull Function1<? super TYPE, ? extends MAPPED> convert) {
                        Intrinsics.checkParameterIsNotNull((Object)mappedTypeName, (String)"mappedTypeName");
                        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
                        return $this.mapValid(mappedTypeName, (Function1)new Function1<TYPE, Validated.Result<MAPPED, Validation.Error>>(convert){
                            final /* synthetic */ Function1 $convert;

                            @NotNull
                            public final Validated.Result<MAPPED, Validation.Error> invoke(TYPE value) {
                                return UtilsKt.valid(this.$convert.invoke(value));
                            }
                            {
                                this.$convert = function1;
                                super(1);
                            }
                        });
                    }

                    public static <TYPE> boolean isSpecifiedBy(Standard<TYPE> $this, @NotNull Config configuration) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        return Required.DefaultImpls.isSpecifiedBy($this, configuration);
                    }

                    @NotNull
                    public static <TYPE> Validated<TYPE, Validation.Error> parse(Standard<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return Required.DefaultImpls.parse($this, configuration, options);
                    }

                    @Nullable
                    public static <TYPE> TYPE valueInOrNull(Standard<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                        return Required.DefaultImpls.valueInOrNull($this, configuration, options);
                    }
                }
            }

            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=3)
            public static final class DefaultImpls {
                public static <TYPE> boolean isSpecifiedBy(Definition<TYPE> $this, @NotNull Config configuration) {
                    Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                    return configuration.hasPath($this.getKey());
                }

                @NotNull
                public static <TYPE> Validated<TYPE, Validation.Error> parse(Definition<TYPE> $this, @NotNull Config configuration, @NotNull Options options) {
                    Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                    Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                    return $this.validate(configuration, options).mapValid(new Function1<Config, Validated.Result<TYPE, Validation.Error>>($this, options){
                        final /* synthetic */ Definition this$0;
                        final /* synthetic */ Options $options;

                        @NotNull
                        public final Validated.Result<TYPE, Validation.Error> invoke(@NotNull Config config) {
                            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
                            return UtilsKt.valid(this.this$0.valueIn(config, this.$options));
                        }
                        {
                            this.this$0 = definition;
                            this.$options = options;
                            super(1);
                        }
                    });
                }

                @Nullable
                public static <TYPE> TYPE valueInOrNull(Definition<TYPE> $this, @NotNull Config configuration, @NotNull Options options) throws ConfigException.WrongType, ConfigException.BadValue {
                    Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                    Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                    return Value.Extractor.DefaultImpls.valueInOrNull($this, configuration, options);
                }
            }

            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @kotlin.Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0006\"\u000e\b\u0001\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00102\u0006\u0010\b\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00062\u0006\u0010\b\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\t\u001a\u00020\u0007J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Companion;", "", "()V", "SENSITIVE_DATA_PLACEHOLDER", "", "boolean", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Standard;", "", "key", "sensitive", "double", "", "duration", "Ljava/time/Duration;", "enum", "ENUM", "", "enumClass", "Lkotlin/reflect/KClass;", "float", "", "int", "", "long", "", "nestedObject", "Lcom/typesafe/config/ConfigObject;", "schema", "Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "string", "common-configuration-parsing"})
            public static final class Companion {
                @NotNull
                public static final String SENSITIVE_DATA_PLACEHOLDER = "*****";
                static final /* synthetic */ Companion $$INSTANCE;

                @NotNull
                public final Standard<Long> long(@NotNull String key, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    return new LongProperty(key, sensitive);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard long$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.long(string2, bl);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Standard<Integer> int(@NotNull String key, boolean sensitive) {
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Standard<Long> standard = this.long(key, sensitive);
                    Function1 convert$iv = (Function1)new Function1<Long, Validated.Result<Integer, Validation.Error>>(key){
                        final /* synthetic */ String $key;

                        @NotNull
                        public final Validated.Result<Integer, Validation.Error> invoke(long value) {
                            Validated.Result result;
                            try {
                                result = UtilsKt.valid(Math.toIntExact(value));
                            }
                            catch (ArithmeticException e) {
                                Object[] objectArray = new Validation.Error[1];
                                String string2 = Integer.class.getSimpleName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Int::class.javaObjectType.simpleName");
                                objectArray[0] = Validation.Error.BadValue.Companion.of$default(Validation.Error.BadValue.Companion, "Provided value exceeds Integer range [-2147483648, 2147483647].", this.$key, string2, null, 8, null);
                                result = Validated.Companion.invalid(objectArray);
                            }
                            return result;
                        }
                        {
                            this.$key = string2;
                            super(1);
                        }
                    };
                    String string2 = Integer.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MAPPED::class.java.simpleName");
                    return $receiver$iv.mapValid(string2, convert$iv);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard int$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.int(string2, bl);
                }

                @NotNull
                public final Standard<Boolean> boolean(@NotNull String key, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    String string2 = Boolean.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Boolean::class.javaObjectType.simpleName");
                    return new StandardProperty(key, string2, boolean.1.INSTANCE, boolean.2.INSTANCE, sensitive, null, 32, null);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard boolean$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.boolean(string2, bl);
                }

                @NotNull
                public final Standard<Double> double(@NotNull String key, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    String string2 = Double.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Double::class.javaObjectType.simpleName");
                    return new StandardProperty(key, string2, double.1.INSTANCE, double.2.INSTANCE, sensitive, null, 32, null);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard double$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.double(string2, bl);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Standard<Float> float(@NotNull String key, boolean sensitive) {
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Standard<Double> standard = this.double(key, sensitive);
                    Function1 convert$iv = (Function1)new Function1<Double, Validated.Result<Float, Validation.Error>>(key){
                        final /* synthetic */ String $key;

                        @NotNull
                        public final Validated.Result<Float, Validation.Error> invoke(double value) {
                            float floatValue = (float)value;
                            float f = floatValue;
                            return Float.isInfinite(f) || Float.isNaN(f = floatValue) ? Validated.Companion.invalid((Object[])new Validation.Error[]{Validation.Error.BadValue.Companion.of$default(Validation.Error.BadValue.Companion, this.$key, Float.class.getSimpleName(), "Provided value exceeds Float range.", null, 8, null)}) : UtilsKt.valid(Float.valueOf((float)value));
                        }
                        {
                            this.$key = string2;
                            super(1);
                        }
                    };
                    String string2 = Float.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MAPPED::class.java.simpleName");
                    return $receiver$iv.mapValid(string2, convert$iv);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard float$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.float(string2, bl);
                }

                @NotNull
                public final Standard<String> string(@NotNull String key, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    String string2 = String.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"String::class.java.simpleName");
                    return new StandardProperty(key, string2, string.1.INSTANCE, string.2.INSTANCE, sensitive, null, 32, null);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard string$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.string(string2, bl);
                }

                @NotNull
                public final Standard<Duration> duration(@NotNull String key, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    String string2 = Duration.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Duration::class.java.simpleName");
                    return new StandardProperty(key, string2, duration.1.INSTANCE, duration.2.INSTANCE, sensitive, null, 32, null);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard duration$default(Companion companion, String string2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        bl = false;
                    }
                    return companion.duration(string2, bl);
                }

                @NotNull
                public final Standard<ConfigObject> nestedObject(@NotNull String key, @Nullable Schema schema2, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    String string2 = ConfigObject.class.getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ConfigObject::class.java.simpleName");
                    return new StandardProperty(key, string2, nestedObject.1.INSTANCE, nestedObject.2.INSTANCE, sensitive, schema2);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard nestedObject$default(Companion companion, String string2, Schema schema2, boolean bl, int n, Object object) {
                    if ((n & 2) != 0) {
                        schema2 = null;
                    }
                    if ((n & 4) != 0) {
                        bl = false;
                    }
                    return companion.nestedObject(string2, schema2, bl);
                }

                @NotNull
                public final <ENUM extends Enum<ENUM>> Standard<ENUM> enum(@NotNull String key, @NotNull KClass<ENUM> enumClass, boolean sensitive) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
                    String string2 = JvmClassMappingKt.getJavaClass(enumClass).getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"enumClass.java.simpleName");
                    return new StandardProperty(key, string2, new Function3<Config, String, Options, ENUM>(enumClass){
                        final /* synthetic */ KClass $enumClass;

                        public final ENUM invoke(@NotNull Config conf, @NotNull String propertyKey, @NotNull Options $noName_2) {
                            Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
                            Intrinsics.checkParameterIsNotNull((Object)propertyKey, (String)"propertyKey");
                            Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                            return (ENUM)conf.getEnum(JvmClassMappingKt.getJavaClass((KClass)this.$enumClass), propertyKey);
                        }
                        {
                            this.$enumClass = kClass;
                            super(3);
                        }
                    }, new Function3<Config, String, Options, List<ENUM>>(enumClass){
                        final /* synthetic */ KClass $enumClass;

                        public final List<ENUM> invoke(@NotNull Config conf, @NotNull String propertyKey, @NotNull Options $noName_2) {
                            Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
                            Intrinsics.checkParameterIsNotNull((Object)propertyKey, (String)"propertyKey");
                            Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                            List list2 = conf.getEnumList(JvmClassMappingKt.getJavaClass((KClass)this.$enumClass), propertyKey);
                            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"conf.getEnumList(enumClass.java, propertyKey)");
                            return list2;
                        }
                        {
                            this.$enumClass = kClass;
                            super(3);
                        }
                    }, sensitive, null, 32, null);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Standard enum$default(Companion companion, String string2, KClass kClass, boolean bl, int n, Object object) {
                    if ((n & 4) != 0) {
                        bl = false;
                    }
                    return companion.enum(string2, kClass, bl);
                }

                private Companion() {
                }

                static {
                    Companion companion;
                    $$INSTANCE = companion = new Companion();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0004H&R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validator;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Describer;", "name", "", "getName", "()Ljava/lang/String;", "properties", "", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "getProperties", "()Ljava/util/Set;", "describe", "Lcom/typesafe/config/ConfigValue;", "configuration", "Lcom/typesafe/config/Config;", "serialiseValue", "Lkotlin/Function1;", "", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "description", "Companion", "common-configuration-parsing"})
    public static interface Schema
    extends Validator,
    Describer {
        public static final Companion Companion = Companion.$$INSTANCE;

        @Nullable
        public String getName();

        @NotNull
        public String description();

        @NotNull
        public Set<Property.Definition<?>> getProperties();

        @Override
        @NotNull
        public ConfigValue describe(@NotNull Config var1, @NotNull Function1<Object, ? extends ConfigValue> var2, @NotNull Options var3);

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000bJ5\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2!\u0010\f\u001a\u001d\u0012\u0004\u0012\u00020\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000b0\r\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Schema$Companion;", "", "()V", "withProperties", "Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "properties", "", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "name", "", "([Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "", "builder", "Lkotlin/Function1;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition$Companion;", "Lkotlin/ExtensionFunctionType;", "common-configuration-parsing"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final Schema withProperties(@Nullable String name, @NotNull Iterable<? extends Property.Definition<?>> properties) {
                Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
                return new net.corda.common.configuration.parsing.internal.Schema(name, properties);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Schema withProperties$default(Companion companion, String string2, Iterable iterable, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = null;
                }
                return companion.withProperties(string2, iterable);
            }

            @NotNull
            public final Schema withProperties(@NotNull Property.Definition<?>[] properties, @Nullable String name) {
                Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
                return this.withProperties(name, ArraysKt.toSet((Object[])properties));
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Schema withProperties$default(Companion companion, Property.Definition[] definitionArray, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                return companion.withProperties(definitionArray, string2);
            }

            @NotNull
            public final Schema withProperties(@Nullable String name, @NotNull Function1<? super Property.Definition.Companion, ? extends Iterable<? extends Property.Definition<?>>> builder) {
                Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
                return this.withProperties(name, (Iterable)builder.invoke((Object)Property.Definition.Companion));
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Schema withProperties$default(Companion companion, String string2, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = null;
                }
                return companion.withProperties(string2, function1);
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J\"\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J@\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u0017\"\u000e\b\u0001\u0010**\b\u0012\u0004\u0012\u0002H*0+2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H*0-2\b\b\u0002\u0010\u001a\u001a\u00020\u0018J4\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u0017\"\u000e\b\u0001\u0010**\b\u0012\u0004\u0012\u0002H*0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H*0-2\b\b\u0002\u0010\u001a\u001a\u00020\u0018J\"\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J\"\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J\"\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J.\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00172\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J,\u00106\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020807j\b\u0012\u0004\u0012\u00028\u0000`92\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J.\u0010:\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020807j\b\u0012\u0004\u0012\u00028\u0000`92\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H$J\"\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0018J$\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u000208072\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006>"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Specification;", "VALUE", "Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Parser;", "name", "", "prefix", "(Ljava/lang/String;Ljava/lang/String;)V", "mutableProperties", "", "Lnet/corda/common/configuration/parsing/internal/Configuration$Property$Definition;", "getName", "()Ljava/lang/String;", "properties", "", "getProperties", "()Ljava/util/Set;", "schema", "getSchema", "()Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;", "schema$delegate", "Lkotlin/Lazy;", "boolean", "Lnet/corda/common/configuration/parsing/internal/PropertyDelegate$Standard;", "", "key", "sensitive", "describe", "Lcom/typesafe/config/ConfigValue;", "configuration", "Lcom/typesafe/config/Config;", "serialiseValue", "Lkotlin/Function1;", "", "options", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "description", "double", "", "duration", "Ljava/time/Duration;", "enum", "ENUM", "", "enumClass", "Lkotlin/reflect/KClass;", "float", "", "int", "", "long", "", "nestedObject", "Lcom/typesafe/config/ConfigObject;", "parse", "Lnet/corda/common/validation/internal/Validated;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "Lnet/corda/common/configuration/parsing/internal/Valid;", "parseValid", "string", "validate", "target", "common-configuration-parsing"})
    public static abstract class Specification<VALUE>
    implements Schema,
    Value.Parser<VALUE> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Set<Property.Definition<?>> mutableProperties;
        @NotNull
        private final Set<Property.Definition<?>> properties;
        private final Lazy schema$delegate;
        @NotNull
        private final String name;
        private final String prefix;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Specification.class), "schema", "getSchema()Lnet/corda/common/configuration/parsing/internal/Configuration$Schema;"))};
        }

        @Override
        @NotNull
        public Set<Property.Definition<?>> getProperties() {
            return this.properties;
        }

        private final Schema getSchema() {
            Lazy lazy = this.schema$delegate;
            Specification specification = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (Schema)lazy.getValue();
        }

        @NotNull
        public final PropertyDelegate.Standard<Long> long(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.long$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard long$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: long");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.long(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<Integer> int(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.int$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard int$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: int");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.int(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<Boolean> boolean(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.boolean$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard boolean$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: boolean");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.boolean(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<Double> double(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.double$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard double$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: double");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.double(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<Float> float(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.float$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard float$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: float");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.float(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<String> string(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.string$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard string$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: string");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.string(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<Duration> duration(@Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.duration$common_configuration_parsing(key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard duration$default(Specification specification, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: duration");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.duration(string2, bl);
        }

        @NotNull
        public final PropertyDelegate.Standard<ConfigObject> nestedObject(@Nullable Schema schema2, @Nullable String key, boolean sensitive) {
            return PropertyDelegate.Companion.nestedObject$common_configuration_parsing(schema2, key, this.prefix, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard nestedObject$default(Specification specification, Schema schema2, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nestedObject");
            }
            if ((n & 1) != 0) {
                schema2 = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return specification.nestedObject(schema2, string2, bl);
        }

        @NotNull
        public final <ENUM extends Enum<ENUM>> PropertyDelegate.Standard<ENUM> enum(@Nullable String key, @NotNull KClass<ENUM> enumClass, boolean sensitive) {
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return PropertyDelegate.Companion.enum$common_configuration_parsing(key, this.prefix, enumClass, sensitive, (Function1)new Function1<Property.Definition<?>, Unit>(this){
                final /* synthetic */ Specification this$0;

                public final void invoke(@NotNull Property.Definition<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    Specification.access$getMutableProperties$p(this.this$0).add(it);
                }
                {
                    this.this$0 = specification;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard enum$default(Specification specification, String string2, KClass kClass, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enum");
            }
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return specification.enum(string2, kClass, bl);
        }

        @NotNull
        public final <ENUM extends Enum<ENUM>> PropertyDelegate.Standard<ENUM> enum(@NotNull KClass<ENUM> enumClass, boolean sensitive) {
            Intrinsics.checkParameterIsNotNull(enumClass, (String)"enumClass");
            return this.enum(null, enumClass, sensitive);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyDelegate.Standard enum$default(Specification specification, KClass kClass, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: enum");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return specification.enum(kClass, bl);
        }

        @Override
        @NotNull
        public String description() {
            return this.getSchema().description();
        }

        @NotNull
        public Validated<Config, Validation.Error> validate(@NotNull Config target, @NotNull Options options) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return this.getSchema().validate(target, options);
        }

        @Override
        @NotNull
        public ConfigValue describe(@NotNull Config configuration, @NotNull Function1<Object, ? extends ConfigValue> serialiseValue, @NotNull Options options) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull(serialiseValue, (String)"serialiseValue");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return this.getSchema().describe(configuration, serialiseValue, options);
        }

        @Override
        @NotNull
        public final Validated<VALUE, Validation.Error> parse(@NotNull Config configuration, @NotNull Options options) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return this.validate(configuration, options).mapValid(new Function1<Config, Validated<VALUE, Validation.Error>>(this, options){
                final /* synthetic */ Specification this$0;
                final /* synthetic */ Options $options;

                @NotNull
                public final Validated<VALUE, Validation.Error> invoke(@NotNull Config it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.this$0.parseValid(it, this.$options);
                }
                {
                    this.this$0 = specification;
                    this.$options = options;
                    super(1);
                }
            });
        }

        @NotNull
        protected abstract Validated<VALUE, Validation.Error> parseValid(@NotNull Config var1, @NotNull Options var2);

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public Specification(@NotNull String name, @Nullable String prefix) {
            Set set;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.prefix = prefix;
            Specification specification = this;
            specification.mutableProperties = set = (Set)new LinkedHashSet();
            this.properties = this.mutableProperties;
            this.schema$delegate = LazyKt.lazy((Function0)((Function0)new Function0<net.corda.common.configuration.parsing.internal.Schema>(this){
                final /* synthetic */ Specification this$0;

                @NotNull
                public final net.corda.common.configuration.parsing.internal.Schema invoke() {
                    return new net.corda.common.configuration.parsing.internal.Schema(this.this$0.getName(), (Iterable)this.this$0.getProperties());
                }
                {
                    this.this$0 = specification;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Specification(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            this(string2, string3);
        }

        @NotNull
        public static final /* synthetic */ Set access$getMutableProperties$p(Specification $this) {
            return $this.mutableProperties;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "", "strict", "", "(Z)V", "getStrict", "()Z", "Companion", "common-configuration-parsing"})
    public static final class Options {
        private final boolean strict;
        @NotNull
        private static final Options defaults;
        public static final Companion Companion;

        public final boolean getStrict() {
            return this.strict;
        }

        public Options(boolean strict) {
            this.strict = strict;
        }

        public /* synthetic */ Options(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public Options() {
            this(false, 1, null);
        }

        static {
            Companion = new Companion(null);
            defaults = new Options(false, 1, null);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Options$Companion;", "", "()V", "defaults", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "getDefaults", "()Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "common-configuration-parsing"})
        public static final class Companion {
            @NotNull
            public final Options getDefaults() {
                return defaults;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation;", "", "()V", "Error", "common-configuration-parsing"})
    public static final class Validation {
        public static final Validation INSTANCE;

        private Validation() {
        }

        static {
            Validation validation;
            INSTANCE = validation = new Validation();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\b\u001e\u001f !\"#$%B3\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0003H\u0016J!\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H \u00a2\u0006\u0002\b\u0017J#\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0019\"\u00020\u0003H \u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001c\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0019\"\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u0082\u0001\u0007&'()*+,\u00a8\u0006-"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getContainingPath", "()Ljava/util/List;", "containingPathAsString", "getContainingPathAsString", "()Ljava/lang/String;", "getKeyName", "getMessage", "path", "getPath", "pathAsString", "getPathAsString", "getTypeName", "toString", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "withContainingPathPrefix", "withContainingPathPrefix$common_configuration_parsing", "BadPath", "BadValue", "Companion", "MalformedStructure", "MissingValue", "Unknown", "UnsupportedVersion", "WrongType", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$WrongType;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MissingValue;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadValue;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadPath;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MalformedStructure;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Unknown;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$UnsupportedVersion;", "common-configuration-parsing"})
        public static abstract class Error {
            @NotNull
            private final String containingPathAsString;
            @Nullable
            private final String keyName;
            @Nullable
            private final String typeName;
            @NotNull
            private final String message;
            @NotNull
            private final List<String> containingPath;
            private static final String UNKNOWN = "<unknown>";
            public static final Companion Companion = new Companion(null);

            @NotNull
            public final List<String> getPath() {
                String string2;
                String it;
                Object object = this.getKeyName();
                if (object == null || (object = CollectionsKt.plus((Collection)this.containingPath, (Object)(it = (string2 = object)))) == null) {
                    object = this.containingPath;
                }
                return object;
            }

            @NotNull
            public final String getContainingPathAsString() {
                return this.containingPathAsString;
            }

            @NotNull
            public final String getPathAsString() {
                return CollectionsKt.joinToString$default((Iterable)this.getPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Error withContainingPathPrefix$common_configuration_parsing(String ... containingPath) {
                String[] stringArray;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                Collection collection = CollectionsKt.plus((Collection)ArraysKt.toList((Object[])containingPath), (Iterable)this.containingPath);
                Error error = this;
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v0;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray3 = stringArray = stringArray2;
                return error.withContainingPath$common_configuration_parsing(Arrays.copyOf(stringArray3, stringArray3.length));
            }

            @NotNull
            public abstract Error withContainingPath$common_configuration_parsing(String ... var1);

            @NotNull
            public abstract Error with$common_configuration_parsing(@NotNull String var1, @NotNull String var2);

            @NotNull
            public static /* bridge */ /* synthetic */ Error with$common_configuration_parsing$default(Error error, String string2, String string3, int n, Object object) {
                String string4;
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: with");
                }
                if ((n & 1) != 0 && (string4 = error.getKeyName()) == null) {
                    string4 = string2 = UNKNOWN;
                }
                if ((n & 2) != 0) {
                    String string5 = error.getTypeName();
                    if (string5 == null) {
                        string5 = UNKNOWN;
                    }
                    string3 = string5;
                }
                return error.with$common_configuration_parsing(string2, string3);
            }

            @NotNull
            public String toString() {
                return this.getMessage() + ": (keyName='" + this.getKeyName() + "', typeName='" + this.getTypeName() + "', path=" + this.getPath() + ')';
            }

            @Nullable
            public String getKeyName() {
                return this.keyName;
            }

            @Nullable
            public String getTypeName() {
                return this.typeName;
            }

            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final List<String> getContainingPath() {
                return this.containingPath;
            }

            private Error(String keyName, String typeName, String message, List<String> containingPath) {
                this.keyName = keyName;
                this.typeName = typeName;
                this.message = message;
                this.containingPath = containingPath;
                this.containingPathAsString = CollectionsKt.joinToString$default((Iterable)this.containingPath, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            }

            /* synthetic */ Error(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    list2 = CollectionsKt.emptyList();
                }
                this(string2, string3, string4, list2);
            }

            public /* synthetic */ Error(@Nullable String keyName, @Nullable String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                this(keyName, typeName, message, containingPath);
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$WrongType;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "getTypeName", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$WrongType;", "Companion", "common-configuration-parsing"})
            public static final class WrongType
            extends Error {
                @NotNull
                private final String keyName;
                @NotNull
                private final String typeName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public WrongType withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new WrongType(this.getKeyName(), this.getTypeName(), this.getMessage(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public WrongType with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(this.getMessage(), keyName, typeName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                @Override
                @NotNull
                public String getTypeName() {
                    return this.typeName;
                }

                private WrongType(String keyName, String typeName, String message, List<String> containingPath) {
                    super(keyName, typeName, message, containingPath, null);
                    this.keyName = keyName;
                    this.typeName = typeName;
                }

                /* synthetic */ WrongType(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, string3, string4, list2);
                }

                public /* synthetic */ WrongType(@NotNull String keyName, @NotNull String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, typeName, message, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J4\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$WrongType$Companion;", "", "()V", "forKey", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$WrongType;", "keyName", "", "expectedTypeName", "actualTypeName", "of", "message", "typeName", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final WrongType of(@NotNull String message, @Nullable String keyName, @NotNull String typeName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        String string2 = keyName;
                        if (string2 == null) {
                            string2 = Error.UNKNOWN;
                        }
                        Pair $key_path = pair = Error.Companion.contextualize(string2, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new WrongType(key, typeName, message, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ WrongType of$default(Companion companion, String string2, String string3, String string4, List list2, int n, Object object) {
                        if ((n & 2) != 0) {
                            string3 = null;
                        }
                        if ((n & 4) != 0) {
                            string4 = Error.UNKNOWN;
                        }
                        if ((n & 8) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, string3, string4, list2);
                    }

                    @NotNull
                    public final WrongType forKey(@NotNull String keyName, @NotNull String expectedTypeName, @NotNull String actualTypeName) {
                        Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                        Intrinsics.checkParameterIsNotNull((Object)expectedTypeName, (String)"expectedTypeName");
                        Intrinsics.checkParameterIsNotNull((Object)actualTypeName, (String)"actualTypeName");
                        String string2 = actualTypeName;
                        StringBuilder stringBuilder = new StringBuilder().append(keyName).append(" has type ");
                        Companion companion = this;
                        String string3 = string2.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                        String string4 = string3;
                        string2 = expectedTypeName;
                        stringBuilder = stringBuilder.append(string4).append(" rather than ");
                        String string5 = string2.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
                        string4 = string5;
                        return net.corda.common.configuration.parsing.internal.Configuration$Validation$Error$WrongType$Companion.of$default(companion, stringBuilder.append(string4).toString(), null, null, null, 14, null);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MissingValue;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "getTypeName", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MissingValue;", "Companion", "common-configuration-parsing"})
            public static final class MissingValue
            extends Error {
                @NotNull
                private final String keyName;
                @NotNull
                private final String typeName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public MissingValue withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new MissingValue(this.getKeyName(), this.getTypeName(), this.getMessage(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public MissingValue with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(this.getMessage(), keyName, typeName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                @Override
                @NotNull
                public String getTypeName() {
                    return this.typeName;
                }

                private MissingValue(String keyName, String typeName, String message, List<String> containingPath) {
                    super(keyName, typeName, message, containingPath, null);
                    this.keyName = keyName;
                    this.typeName = typeName;
                }

                /* synthetic */ MissingValue(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, string3, string4, list2);
                }

                public /* synthetic */ MissingValue(@NotNull String keyName, @NotNull String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, typeName, message, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a8\u0006\f"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MissingValue$Companion;", "", "()V", "forKey", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MissingValue;", "keyName", "", "of", "message", "typeName", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final MissingValue of(@NotNull String message, @Nullable String keyName, @NotNull String typeName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        String string2 = keyName;
                        if (string2 == null) {
                            string2 = Error.UNKNOWN;
                        }
                        Pair $key_path = pair = Error.Companion.contextualize(string2, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new MissingValue(key, typeName, message, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ MissingValue of$default(Companion companion, String string2, String string3, String string4, List list2, int n, Object object) {
                        if ((n & 2) != 0) {
                            string3 = null;
                        }
                        if ((n & 4) != 0) {
                            string4 = Error.UNKNOWN;
                        }
                        if ((n & 8) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, string3, string4, list2);
                    }

                    @NotNull
                    public final MissingValue forKey(@NotNull String keyName) {
                        Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                        return net.corda.common.configuration.parsing.internal.Configuration$Validation$Error$MissingValue$Companion.of$default(this, "No configuration setting found for key '" + keyName + '\'', keyName, null, null, 12, null);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadValue;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "getTypeName", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadValue;", "Companion", "common-configuration-parsing"})
            public static final class BadValue
            extends Error {
                @NotNull
                private final String keyName;
                @NotNull
                private final String typeName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public BadValue withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new BadValue(this.getKeyName(), this.getTypeName(), this.getMessage(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public BadValue with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(this.getMessage(), keyName, typeName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                @Override
                @NotNull
                public String getTypeName() {
                    return this.typeName;
                }

                private BadValue(String keyName, String typeName, String message, List<String> containingPath) {
                    super(keyName, typeName, message, containingPath, null);
                    this.keyName = keyName;
                    this.typeName = typeName;
                }

                /* synthetic */ BadValue(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, string3, string4, list2);
                }

                public /* synthetic */ BadValue(@NotNull String keyName, @NotNull String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, typeName, message, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadValue$Companion;", "", "()V", "of", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadValue;", "message", "", "keyName", "typeName", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final BadValue of(@NotNull String message, @Nullable String keyName, @NotNull String typeName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        String string2 = keyName;
                        if (string2 == null) {
                            string2 = Error.UNKNOWN;
                        }
                        Pair $key_path = pair = Error.Companion.contextualize(string2, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new BadValue(key, typeName, message, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ BadValue of$default(Companion companion, String string2, String string3, String string4, List list2, int n, Object object) {
                        if ((n & 2) != 0) {
                            string3 = null;
                        }
                        if ((n & 4) != 0) {
                            string4 = Error.UNKNOWN;
                        }
                        if ((n & 8) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, string3, string4, list2);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadPath;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "getTypeName", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadPath;", "Companion", "common-configuration-parsing"})
            public static final class BadPath
            extends Error {
                @NotNull
                private final String keyName;
                @NotNull
                private final String typeName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public BadPath withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new BadPath(this.getKeyName(), this.getTypeName(), this.getMessage(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public BadPath with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(this.getMessage(), keyName, typeName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                @Override
                @NotNull
                public String getTypeName() {
                    return this.typeName;
                }

                private BadPath(String keyName, String typeName, String message, List<String> containingPath) {
                    super(keyName, typeName, message, containingPath, null);
                    this.keyName = keyName;
                    this.typeName = typeName;
                }

                /* synthetic */ BadPath(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, string3, string4, list2);
                }

                public /* synthetic */ BadPath(@NotNull String keyName, @NotNull String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, typeName, message, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadPath$Companion;", "", "()V", "of", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$BadPath;", "message", "", "keyName", "typeName", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final BadPath of(@NotNull String message, @Nullable String keyName, @NotNull String typeName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        String string2 = keyName;
                        if (string2 == null) {
                            string2 = Error.UNKNOWN;
                        }
                        Pair $key_path = pair = Error.Companion.contextualize(string2, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new BadPath(key, typeName, message, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ BadPath of$default(Companion companion, String string2, String string3, String string4, List list2, int n, Object object) {
                        if ((n & 2) != 0) {
                            string3 = null;
                        }
                        if ((n & 4) != 0) {
                            string4 = Error.UNKNOWN;
                        }
                        if ((n & 8) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, string3, string4, list2);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MalformedStructure;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "typeName", "message", "containingPath", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "getTypeName", "with", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MalformedStructure;", "Companion", "common-configuration-parsing"})
            public static final class MalformedStructure
            extends Error {
                @NotNull
                private final String keyName;
                @NotNull
                private final String typeName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public MalformedStructure withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new MalformedStructure(this.getKeyName(), this.getTypeName(), this.getMessage(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public MalformedStructure with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(this.getMessage(), keyName, typeName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                @Override
                @NotNull
                public String getTypeName() {
                    return this.typeName;
                }

                private MalformedStructure(String keyName, String typeName, String message, List<String> containingPath) {
                    super(keyName, typeName, message, containingPath, null);
                    this.keyName = keyName;
                    this.typeName = typeName;
                }

                /* synthetic */ MalformedStructure(String string2, String string3, String string4, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, string3, string4, list2);
                }

                public /* synthetic */ MalformedStructure(@NotNull String keyName, @NotNull String typeName, @NotNull String message, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, typeName, message, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MalformedStructure$Companion;", "", "()V", "of", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$MalformedStructure;", "message", "", "keyName", "typeName", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final MalformedStructure of(@NotNull String message, @Nullable String keyName, @NotNull String typeName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        String string2 = keyName;
                        if (string2 == null) {
                            string2 = Error.UNKNOWN;
                        }
                        Pair $key_path = pair = Error.Companion.contextualize(string2, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new MalformedStructure(key, typeName, message, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ MalformedStructure of$default(Companion companion, String string2, String string3, String string4, List list2, int n, Object object) {
                        if ((n & 2) != 0) {
                            string3 = null;
                        }
                        if ((n & 4) != 0) {
                            string4 = Error.UNKNOWN;
                        }
                        if ((n & 8) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, string3, string4, list2);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000bJ#\u0010\f\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\r\"\u00020\u0003H\u0010\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Unknown;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "keyName", "", "containingPath", "", "(Ljava/lang/String;Ljava/util/List;)V", "getKeyName", "()Ljava/lang/String;", "with", "typeName", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Unknown;", "Companion", "common-configuration-parsing"})
            public static final class Unknown
            extends Error {
                @NotNull
                private final String keyName;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public Unknown withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new Unknown(this.getKeyName(), ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public Unknown with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return Companion.of(keyName, this.getContainingPath());
                }

                @Override
                @NotNull
                public String getKeyName() {
                    return this.keyName;
                }

                private Unknown(String keyName, List<String> containingPath) {
                    super(keyName, null, Unknown.Companion.message(keyName), containingPath, null);
                    this.keyName = keyName;
                }

                /* synthetic */ Unknown(String string2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 2) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(string2, list2);
                }

                public /* synthetic */ Unknown(@NotNull String keyName, @NotNull List containingPath, DefaultConstructorMarker $constructor_marker) {
                    this(keyName, containingPath);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\n"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Unknown$Companion;", "", "()V", "message", "", "keyName", "of", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Unknown;", "containingPath", "", "common-configuration-parsing"})
                public static final class Companion {
                    private final String message(String keyName) {
                        return "Unknown property '" + keyName + '\'';
                    }

                    @NotNull
                    public final Unknown of(@NotNull String keyName, @NotNull List<String> containingPath) {
                        Pair pair;
                        Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                        Intrinsics.checkParameterIsNotNull(containingPath, (String)"containingPath");
                        Pair $key_path = pair = Error.Companion.contextualize(keyName, containingPath);
                        String key = (String)$key_path.component1();
                        List path = (List)$key_path.component2();
                        return new Unknown(key, path, null);
                    }

                    @NotNull
                    public static /* bridge */ /* synthetic */ Unknown of$default(Companion companion, String string2, List list2, int n, Object object) {
                        if ((n & 1) != 0) {
                            string2 = Error.UNKNOWN;
                        }
                        if ((n & 2) != 0) {
                            list2 = CollectionsKt.emptyList();
                        }
                        return companion.of(string2, list2);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\rJ#\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$UnsupportedVersion;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "version", "", "containingPath", "", "", "(ILjava/util/List;)V", "getVersion", "()I", "with", "keyName", "typeName", "with$common_configuration_parsing", "withContainingPath", "", "withContainingPath$common_configuration_parsing", "([Ljava/lang/String;)Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$UnsupportedVersion;", "Companion", "common-configuration-parsing"})
            public static final class UnsupportedVersion
            extends Error {
                private final int version;
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public UnsupportedVersion withContainingPath$common_configuration_parsing(String ... containingPath) {
                    Intrinsics.checkParameterIsNotNull((Object)containingPath, (String)"containingPath");
                    return new UnsupportedVersion(this.version, ArraysKt.toList((Object[])containingPath));
                }

                @Override
                @NotNull
                public UnsupportedVersion with$common_configuration_parsing(@NotNull String keyName, @NotNull String typeName) {
                    Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
                    Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                    return this;
                }

                public final int getVersion() {
                    return this.version;
                }

                private UnsupportedVersion(int version, List<String> containingPath) {
                    super(null, null, "Unknown configuration version " + version + '.', containingPath, null);
                    this.version = version;
                }

                /* synthetic */ UnsupportedVersion(int n, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n2 & 2) != 0) {
                        list2 = CollectionsKt.emptyList();
                    }
                    this(n, list2);
                }

                @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$UnsupportedVersion$Companion;", "", "()V", "of", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$UnsupportedVersion;", "version", "", "common-configuration-parsing"})
                public static final class Companion {
                    @NotNull
                    public final UnsupportedVersion of(int version) {
                        return new UnsupportedVersion(version, null, 2, null);
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u00062\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error$Companion;", "", "()V", "UNKNOWN", "", "contextualize", "Lkotlin/Pair;", "", "keyName", "containingPath", "common-configuration-parsing"})
            public static final class Companion {
                private final Pair<String, List<String>> contextualize(String keyName, List<String> containingPath) {
                    Pair pair;
                    List keyParts = StringsKt.split$default((CharSequence)keyName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                    if (keyParts.size() > 1) {
                        List fullContainingPath = CollectionsKt.plus((Collection)containingPath, (Iterable)keyParts.subList(0, keyParts.size() - 1));
                        String keySegment = (String)CollectionsKt.last((List)keyParts);
                        pair = TuplesKt.to((Object)keySegment, (Object)fullContainingPath);
                    } else {
                        pair = TuplesKt.to((Object)keyName, containingPath);
                    }
                    return pair;
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Version;", "", "()V", "Extractor", "common-configuration-parsing"})
    public static final class Version {
        public static final Version INSTANCE;

        private Version() {
        }

        static {
            Version version;
            INSTANCE = version = new Version();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u0000 \u00032\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Version$Extractor;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Value$Parser;", "", "Companion", "common-configuration-parsing"})
        public static interface Extractor
        extends Value.Parser<Integer> {
            public static final Companion Companion = Companion.$$INSTANCE;
            public static final int DEFAULT_VERSION_VALUE = 1;

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Version$Extractor$Companion;", "", "()V", "DEFAULT_VERSION_VALUE", "", "fromPath", "Lnet/corda/common/configuration/parsing/internal/Configuration$Version$Extractor;", "versionPath", "", "versionDefaultValue", "common-configuration-parsing"})
            public static final class Companion {
                public static final int DEFAULT_VERSION_VALUE = 1;
                static final /* synthetic */ Companion $$INSTANCE;

                @NotNull
                public final Extractor fromPath(@NotNull String versionPath, int versionDefaultValue) {
                    Intrinsics.checkParameterIsNotNull((Object)versionPath, (String)"versionPath");
                    return new VersionExtractor(versionPath, versionDefaultValue);
                }

                @NotNull
                public static /* bridge */ /* synthetic */ Extractor fromPath$default(Companion companion, String string2, int n, int n2, Object object) {
                    if ((n2 & 2) != 0) {
                        n = 1;
                    }
                    return companion.fromPath(string2, n);
                }

                private Companion() {
                }

                static {
                    Companion companion;
                    $$INSTANCE = companion = new Companion();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001\u00a8\u0006\u0005"}, d2={"Lnet/corda/common/configuration/parsing/internal/Configuration$Validator;", "Lnet/corda/common/validation/internal/Validator;", "Lcom/typesafe/config/Config;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Validation$Error;", "Lnet/corda/common/configuration/parsing/internal/Configuration$Options;", "common-configuration-parsing"})
    public static interface Validator
    extends net.corda.common.validation.internal.Validator<Config, Validation.Error, Options> {
    }
}

