/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import net.bramp.ffmpeg.progress.StreamProgressParser;

class TcpProgressParserRunnable
implements Runnable {
    final StreamProgressParser parser;
    final ServerSocket server;
    final CountDownLatch startSignal;

    public TcpProgressParserRunnable(StreamProgressParser parser, ServerSocket server, CountDownLatch startSignal) {
        this.parser = (StreamProgressParser)Preconditions.checkNotNull((Object)parser);
        this.server = (ServerSocket)Preconditions.checkNotNull((Object)server);
        this.startSignal = (CountDownLatch)Preconditions.checkNotNull((Object)startSignal);
    }

    @Override
    public void run() {
        while (!this.server.isClosed() && !Thread.currentThread().isInterrupted()) {
            try {
                this.startSignal.countDown();
                Socket socket = this.server.accept();
                Throwable throwable = null;
                try {
                    InputStream stream = socket.getInputStream();
                    Throwable throwable2 = null;
                    try {
                        this.parser.processStream(stream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable2 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {}
        }
    }
}

