/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.bramp.ffmpeg.progress.Progress;
import net.bramp.ffmpeg.progress.ProgressListener;

public class StreamProgressParser {
    final ProgressListener listener;

    public StreamProgressParser(ProgressListener listener) {
        this.listener = (ProgressListener)Preconditions.checkNotNull((Object)listener);
    }

    private static BufferedReader wrapInBufferedReader(Reader reader) {
        Preconditions.checkNotNull((Object)reader);
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public void processStream(InputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        this.processReader(new InputStreamReader(stream, Charsets.UTF_8));
    }

    public void processReader(Reader reader) throws IOException {
        String line;
        BufferedReader in = StreamProgressParser.wrapInBufferedReader(reader);
        Progress p = new Progress();
        while ((line = in.readLine()) != null) {
            if (!p.parseLine(line)) continue;
            this.listener.progress(p);
            p = new Progress();
        }
    }
}

