/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.nut;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.bramp.ffmpeg.io.CRC32InputStream;

public class NutDataInputStream
implements DataInput {
    final DataInputStream in;
    final CRC32InputStream crc;
    final CountingInputStream count;
    long startCrcRange;
    long endCrcRange;

    public NutDataInputStream(InputStream in) {
        Preconditions.checkNotNull((Object)in);
        this.count = new CountingInputStream(in);
        this.crc = new CRC32InputStream((InputStream)this.count);
        this.in = new DataInputStream(this.crc);
    }

    public void resetCRC() {
        this.startCrcRange = this.count.getCount();
        this.crc.resetCrc();
    }

    public long getCRC() {
        this.endCrcRange = this.count.getCount();
        return this.crc.getValue();
    }

    public int readVarInt() throws IOException {
        boolean more;
        int result = 0;
        do {
            int b;
            more = ((b = this.in.readUnsignedByte()) & 0x80) == 128;
            result = 128 * result + (b & 0x7F);
        } while (more);
        return result;
    }

    public long readVarLong() throws IOException {
        boolean more;
        long result = 0L;
        do {
            int b;
            more = ((b = this.in.readUnsignedByte()) & 0x80) == 128;
            result = 128L * result + (long)(b & 0x7F);
        } while (more);
        return result;
    }

    public long readSignedVarInt() throws IOException {
        long temp = this.readVarLong() + 1L;
        if ((temp & 1L) == 1L) {
            return -(temp >> 1);
        }
        return temp >> 1;
    }

    public byte[] readVarArray() throws IOException {
        int len = (int)this.readVarLong();
        byte[] result = new byte[len];
        this.in.read(result);
        return result;
    }

    public long readStartCode() throws IOException {
        byte frameCode = this.in.readByte();
        if (frameCode != 78) {
            return frameCode & 0xFF;
        }
        byte[] buffer = new byte[8];
        buffer[0] = frameCode;
        this.readFully(buffer, 1, 7);
        return ((long)buffer[0] << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)((buffer[7] & 0xFF) << 0);
    }

    public long offset() {
        return this.count.getCount();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

