/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.gson;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@Immutable
public class LowercaseEnumTypeAdapterFactory
implements TypeAdapterFactory {
    @CheckReturnValue
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Preconditions.checkNotNull(type);
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        HashMap lowercaseToEnum = new HashMap();
        for (Object constant : rawType.getEnumConstants()) {
            lowercaseToEnum.put(LowercaseEnumTypeAdapterFactory.toLowercase(constant), constant);
        }
        return new MyTypeAdapter(lowercaseToEnum);
    }

    @CheckReturnValue
    private static String toLowercase(@Nonnull Object o) {
        return Preconditions.checkNotNull((Object)o).toString().toLowerCase(Locale.UK);
    }

    @Immutable
    private static class MyTypeAdapter<T>
    extends TypeAdapter<T> {
        private final ImmutableMap<String, T> lowercaseToEnum;

        public MyTypeAdapter(Map<String, T> lowercaseToEnum) {
            this.lowercaseToEnum = ImmutableMap.copyOf(lowercaseToEnum);
        }

        public void write(JsonWriter out, T value) throws IOException {
            Preconditions.checkNotNull((Object)out);
            if (value == null) {
                out.nullValue();
            } else {
                out.value(LowercaseEnumTypeAdapterFactory.toLowercase(value));
            }
        }

        public T read(JsonReader reader) throws IOException {
            Preconditions.checkNotNull((Object)reader);
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return (T)this.lowercaseToEnum.get((Object)reader.nextString());
        }
    }
}

