/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.CharMatcher;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bramp.commons.lang3.math.gson.FractionAdapter;
import net.bramp.ffmpeg.Preconditions;
import net.bramp.ffmpeg.gson.LowercaseEnumTypeAdapterFactory;
import net.bramp.ffmpeg.gson.NamedBitsetAdapter;
import net.bramp.ffmpeg.probe.FFmpegDisposition;
import org.apache.commons.lang3.math.Fraction;

public final class FFmpegUtils {
    static final Gson gson = FFmpegUtils.setupGson();
    static final Pattern BITRATE_REGEX = Pattern.compile("(\\d+(?:\\.\\d+)?)kbits/s");
    static final Pattern TIME_REGEX = Pattern.compile("(\\d+):(\\d+):(\\d+(?:\\.\\d+)?)");
    static final CharMatcher ZERO = CharMatcher.is((char)'0');

    FFmpegUtils() {
        throw new AssertionError((Object)"No instances for you!");
    }

    @Deprecated
    public static String millisecondsToString(long milliseconds) {
        return FFmpegUtils.toTimecode(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static String toTimecode(long duration, TimeUnit units) {
        com.google.common.base.Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be positive");
        long nanoseconds = units.toNanos(duration);
        long seconds = units.toSeconds(duration);
        long ns = nanoseconds - TimeUnit.SECONDS.toNanos(seconds);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds);
        seconds -= TimeUnit.MINUTES.toSeconds(minutes);
        long hours = TimeUnit.MINUTES.toHours(minutes);
        minutes -= TimeUnit.HOURS.toMinutes(hours);
        if (ns == 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return ZERO.trimTrailingFrom((CharSequence)String.format("%02d:%02d:%02d.%09d", hours, minutes, seconds, ns));
    }

    public static long fromTimecode(String time) {
        Preconditions.checkNotEmpty(time, "time must not be empty string");
        Matcher m = TIME_REGEX.matcher(time);
        if (!m.find()) {
            throw new IllegalArgumentException("invalid time '" + time + "'");
        }
        long hours = Long.parseLong(m.group(1));
        long mins = Long.parseLong(m.group(2));
        double secs = Double.parseDouble(m.group(3));
        return TimeUnit.HOURS.toNanos(hours) + TimeUnit.MINUTES.toNanos(mins) + (long)((double)TimeUnit.SECONDS.toNanos(1L) * secs);
    }

    public static long parseBitrate(String bitrate) {
        if ("N/A".equals(bitrate)) {
            return -1L;
        }
        Matcher m = BITRATE_REGEX.matcher(bitrate);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid bitrate '" + bitrate + "'");
        }
        return (long)(Float.parseFloat(m.group(1)) * 1000.0f);
    }

    static Gson getGson() {
        return gson;
    }

    private static Gson setupGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new LowercaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter(Fraction.class, (Object)new FractionAdapter());
        builder.registerTypeAdapter(FFmpegDisposition.class, new NamedBitsetAdapter<FFmpegDisposition>(FFmpegDisposition.class));
        return builder.create();
    }
}

