/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.MessageConsumerRequest;
import brave.spring.rabbit.MessageProducerRequest;
import brave.spring.rabbit.TracingMessagePostProcessor;
import brave.spring.rabbit.TracingRabbitListenerAdvice;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public final class SpringRabbitTracing {
    static final String RABBIT_EXCHANGE = "rabbit.exchange";
    static final String RABBIT_ROUTING_KEY = "rabbit.routing_key";
    static final String RABBIT_QUEUE = "rabbit.queue";
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<MessageProducerRequest> producerExtractor;
    final TraceContext.Extractor<MessageConsumerRequest> consumerExtractor;
    final TraceContext.Injector<MessageProducerRequest> producerInjector;
    final TraceContext.Injector<MessageConsumerRequest> consumerInjector;
    final String[] traceIdHeaders;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final String remoteServiceName;
    @Nullable
    final Field beforePublishPostProcessorsField;
    @Nullable
    final Field beforeSendReplyPostProcessorsField;

    public static SpringRabbitTracing create(Tracing tracing) {
        return SpringRabbitTracing.newBuilder(tracing).build();
    }

    public static SpringRabbitTracing create(MessagingTracing messagingTracing) {
        return SpringRabbitTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return SpringRabbitTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    SpringRabbitTracing(Builder builder) {
        this.tracing = builder.messagingTracing.tracing();
        this.tracer = this.tracing.tracer();
        MessagingTracing messagingTracing = builder.messagingTracing;
        Propagation propagation = this.tracing.propagation();
        this.producerExtractor = propagation.extractor(MessageProducerRequest.GETTER);
        this.consumerExtractor = propagation.extractor(MessageConsumerRequest.GETTER);
        this.producerInjector = propagation.injector(MessageProducerRequest.SETTER);
        this.consumerInjector = propagation.injector(MessageConsumerRequest.SETTER);
        this.producerSampler = messagingTracing.producerSampler();
        this.consumerSampler = messagingTracing.consumerSampler();
        this.remoteServiceName = builder.remoteServiceName;
        this.traceIdHeaders = propagation.keys().toArray(new String[0]);
        this.beforePublishPostProcessorsField = SpringRabbitTracing.getField(RabbitTemplate.class, "beforePublishPostProcessors");
        this.beforeSendReplyPostProcessorsField = SpringRabbitTracing.getField(AbstractRabbitListenerContainerFactory.class, "beforeSendReplyPostProcessors");
    }

    @Nullable
    static Field getField(Class<?> clazz, String name) {
        Field result = null;
        try {
            result = clazz.getDeclaredField(name);
            result.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return result;
    }

    public RabbitTemplate newRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{tracingMessagePostProcessor});
        return rabbitTemplate;
    }

    public RabbitTemplate decorateRabbitTemplate(RabbitTemplate rabbitTemplate) {
        MessagePostProcessor[] beforePublishPostProcessors = this.appendTracingMessagePostProcessor(rabbitTemplate, this.beforePublishPostProcessorsField);
        if (beforePublishPostProcessors != null) {
            rabbitTemplate.setBeforePublishPostProcessors(beforePublishPostProcessors);
        }
        return rabbitTemplate;
    }

    public SimpleRabbitListenerContainerFactory newSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAdviceChain(new Advice[]{new TracingRabbitListenerAdvice(this)});
        factory.setBeforeSendReplyPostProcessors(new MessagePostProcessor[]{new TracingMessagePostProcessor(this)});
        return factory;
    }

    public SimpleRabbitListenerContainerFactory decorateSimpleRabbitListenerContainerFactory(SimpleRabbitListenerContainerFactory factory) {
        MessagePostProcessor[] beforeSendReplyPostProcessors;
        Advice[] advice = this.prependTracingRabbitListenerAdvice(factory);
        if (advice != null) {
            factory.setAdviceChain(advice);
        }
        if ((beforeSendReplyPostProcessors = this.appendTracingMessagePostProcessor(factory, this.beforeSendReplyPostProcessorsField)) != null) {
            factory.setBeforeSendReplyPostProcessors(beforeSendReplyPostProcessors);
        }
        return factory;
    }

    <R> TraceContextOrSamplingFlags extractAndClearTraceIdHeaders(TraceContext.Extractor<R> extractor, R request, Message message) {
        MessageProperties properties;
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        if (extracted.samplingFlags() == null && (properties = message.getMessageProperties()) != null) {
            this.clearTraceIdHeaders(properties.getHeaders());
        }
        return extracted;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    void clearTraceIdHeaders(Map<String, Object> headers) {
        for (String traceIDHeader : this.traceIdHeaders) {
            headers.remove(traceIDHeader);
        }
    }

    @Nullable
    MessagePostProcessor[] appendTracingMessagePostProcessor(Object obj, Field field) {
        MessagePostProcessor[] processors;
        block7: {
            if (field == null) {
                return null;
            }
            try {
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection collection = (Collection)field.get(obj);
                    processors = collection != null ? collection.toArray(new MessagePostProcessor[0]) : null;
                    break block7;
                }
                if (MessagePostProcessor[].class.isAssignableFrom(field.getType())) {
                    processors = (MessagePostProcessor[])field.get(obj);
                    break block7;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        TracingMessagePostProcessor tracingMessagePostProcessor = new TracingMessagePostProcessor(this);
        if (processors == null) {
            return new MessagePostProcessor[]{tracingMessagePostProcessor};
        }
        for (MessagePostProcessor processor : processors) {
            if (!(processor instanceof TracingMessagePostProcessor)) continue;
            return null;
        }
        MessagePostProcessor[] result = new MessagePostProcessor[processors.length + 1];
        System.arraycopy(processors, 0, result, 0, processors.length);
        result[processors.length] = tracingMessagePostProcessor;
        return result;
    }

    @Nullable
    Advice[] prependTracingRabbitListenerAdvice(SimpleRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        TracingRabbitListenerAdvice tracingAdvice = new TracingRabbitListenerAdvice(this);
        if (chain == null) {
            return new Advice[]{tracingAdvice};
        }
        for (Advice advice : chain) {
            if (!(advice instanceof TracingRabbitListenerAdvice)) continue;
            return null;
        }
        Advice[] result = new Advice[chain.length + 1];
        result[0] = tracingAdvice;
        System.arraycopy(chain, 0, result, 1, chain.length);
        return result;
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "rabbitmq";

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        @Deprecated
        public Builder writeB3SingleFormat(boolean writeB3SingleFormat) {
            return this;
        }

        public SpringRabbitTracing build() {
            return new SpringRabbitTracing(this);
        }
    }
}

