/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Throwables;
import brave.jms.JmsTracing;
import brave.jms.MessageConsumerRequest;
import brave.jms.MessageParser;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import javax.jms.Message;
import javax.jms.MessageListener;

final class TracingMessageListener
implements MessageListener {
    final MessageListener delegate;
    final JmsTracing jmsTracing;
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<MessageConsumerRequest> extractor;
    final TraceContext.Injector<MessageConsumerRequest> injector;
    final SamplerFunction<MessagingRequest> sampler;
    final String remoteServiceName;
    final boolean addConsumerSpan;

    static MessageListener create(MessageListener delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingMessageListener) {
            return delegate;
        }
        return new TracingMessageListener(delegate, jmsTracing, true);
    }

    TracingMessageListener(MessageListener delegate, JmsTracing jmsTracing, boolean addConsumerSpan) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        this.tracing = jmsTracing.tracing;
        this.tracer = jmsTracing.tracer;
        this.extractor = jmsTracing.messageConsumerExtractor;
        this.sampler = jmsTracing.consumerSampler;
        this.injector = jmsTracing.messageConsumerInjector;
        this.remoteServiceName = jmsTracing.remoteServiceName;
        this.addConsumerSpan = addConsumerSpan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        Span listenerSpan = this.startMessageListenerSpan(message);
        try {
            Tracer.SpanInScope ws = this.tracer.withSpanInScope(listenerSpan);
            try {
                this.delegate.onMessage(message);
                if (ws == null) return;
            }
            catch (Throwable throwable) {
                if (ws == null) throw throwable;
                try {
                    ws.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            ws.close();
            return;
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            listenerSpan.error(t);
            throw t;
        }
        finally {
            listenerSpan.finish();
        }
    }

    Span startMessageListenerSpan(Message message) {
        if (!this.addConsumerSpan) {
            return this.jmsTracing.nextSpan(message).name("on-message").start();
        }
        MessageConsumerRequest request = new MessageConsumerRequest(message, MessageParser.destination(message));
        TraceContextOrSamplingFlags extracted = this.jmsTracing.extractAndClearProperties(this.extractor, request, message);
        Span consumerSpan = this.jmsTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted);
        consumerSpan.kind(Span.Kind.CONSUMER).name("receive");
        Span listenerSpan = this.tracer.newChild(consumerSpan.context());
        if (!consumerSpan.isNoop()) {
            long timestamp = this.tracing.clock(consumerSpan.context()).currentTimeMicroseconds();
            consumerSpan.start(timestamp);
            if (this.remoteServiceName != null) {
                consumerSpan.remoteServiceName(this.remoteServiceName);
            }
            this.jmsTracing.tagQueueOrTopic((MessagingRequest)request, (SpanCustomizer)consumerSpan);
            long consumerFinish = timestamp + 1L;
            consumerSpan.finish(consumerFinish);
            listenerSpan.name("on-message").start(consumerFinish);
        }
        return listenerSpan;
    }
}

