/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.Tracer;
import brave.internal.Throwables;
import brave.jms.JMSProducerRequest;
import brave.jms.JmsTracing;
import brave.jms.TracingCompletionListener;
import brave.jms.TracingProducer;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSProducer;
import javax.jms.Message;

final class TracingJMSProducer
extends TracingProducer<JMSProducerRequest>
implements JMSProducer {
    final JMSProducer delegate;

    TracingJMSProducer(JMSProducer delegate, JmsTracing jmsTracing) {
        super(jmsTracing.jmsProducerExtractor, jmsTracing.jmsProducerInjector, jmsTracing);
        this.delegate = delegate;
    }

    public JMSProducer send(Destination destination, Message message) {
        this.send(Send.MESSAGE, destination, message);
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        this.send(Send.STRING, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        this.send(Send.MAP, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        this.send(Send.BYTES, destination, body);
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        this.send(Send.SERIALIZABLE, destination, body);
        return this;
    }

    void send(Send send, Destination destination, Object message) {
        Span span = this.createAndStartProducerSpan(new JMSProducerRequest(this, destination));
        CompletionListener oldCompletionListener = this.getAsync();
        if (oldCompletionListener != null) {
            this.delegate.setAsync(TracingCompletionListener.create(oldCompletionListener, span, this.current));
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            send.apply(this.delegate, destination, message);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            span.finish();
            throw t;
        }
        finally {
            ws.close();
            if (oldCompletionListener != null) {
                this.delegate.setAsync(oldCompletionListener);
            } else {
                span.finish();
            }
        }
    }

    public JMSProducer setDisableMessageID(boolean value) {
        this.delegate.setDisableMessageID(value);
        return this;
    }

    public boolean getDisableMessageID() {
        return this.delegate.getDisableMessageID();
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        this.delegate.setDisableMessageTimestamp(value);
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.delegate.getDisableMessageTimestamp();
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.delegate.setDeliveryMode(deliveryMode);
        return this;
    }

    public int getDeliveryMode() {
        return this.delegate.getDeliveryMode();
    }

    public JMSProducer setPriority(int priority) {
        this.delegate.setPriority(priority);
        return this;
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.delegate.setTimeToLive(timeToLive);
        return this;
    }

    public long getTimeToLive() {
        return this.delegate.getTimeToLive();
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.delegate.setDeliveryDelay(deliveryDelay);
        return this;
    }

    public long getDeliveryDelay() {
        return this.delegate.getDeliveryDelay();
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.delegate.setAsync(completionListener);
        return this;
    }

    public CompletionListener getAsync() {
        return this.delegate.getAsync();
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.delegate.setProperty(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.delegate.clearProperties();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.delegate.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) {
        return this.delegate.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) {
        return this.delegate.getByteProperty(name);
    }

    public short getShortProperty(String name) {
        return this.delegate.getShortProperty(name);
    }

    public int getIntProperty(String name) {
        return this.delegate.getIntProperty(name);
    }

    public long getLongProperty(String name) {
        return this.delegate.getLongProperty(name);
    }

    public float getFloatProperty(String name) {
        return this.delegate.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) {
        return this.delegate.getDoubleProperty(name);
    }

    public String getStringProperty(String name) {
        return this.delegate.getStringProperty(name);
    }

    public Object getObjectProperty(String name) {
        return this.delegate.getObjectProperty(name);
    }

    public Set<String> getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.delegate.setJMSCorrelationIDAsBytes(correlationID);
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.delegate.getJMSCorrelationIDAsBytes();
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.delegate.setJMSCorrelationID(correlationID);
        return this;
    }

    public String getJMSCorrelationID() {
        return this.delegate.getJMSCorrelationID();
    }

    public JMSProducer setJMSType(String type) {
        this.delegate.setJMSType(type);
        return this;
    }

    public String getJMSType() {
        return this.delegate.getJMSType();
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.delegate.setJMSReplyTo(replyTo);
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.delegate.getJMSReplyTo();
    }

    static enum Send {
        MESSAGE{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Message)message);
            }
        }
        ,
        STRING{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (String)message);
            }
        }
        ,
        MAP{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Map)message);
            }
        }
        ,
        BYTES{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (byte[])message);
            }
        }
        ,
        SERIALIZABLE{

            @Override
            void apply(JMSProducer producer, Destination destination, Object message) {
                producer.send(destination, (Serializable)message);
            }
        };


        abstract void apply(JMSProducer var1, Destination var2, Object var3);
    }
}

