/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.jms.MessageParser;
import brave.jms.MessagePropagation;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import javax.jms.Destination;
import javax.jms.Message;

final class MessageProducerRequest
extends ProducerRequest {
    static final Propagation.Getter<MessageProducerRequest, String> GETTER = new Propagation.Getter<MessageProducerRequest, String>(){

        public String get(MessageProducerRequest request, String name) {
            return request.getProperty(name);
        }

        public String toString() {
            return "MessageProducerRequest::getProperty";
        }
    };
    static final Propagation.Setter<MessageProducerRequest, String> SETTER = new Propagation.Setter<MessageProducerRequest, String>(){

        public void put(MessageProducerRequest request, String name, String value) {
            request.setProperty(name, value);
        }

        public String toString() {
            return "MessageProducerRequest::setProperty";
        }
    };
    final Message delegate;
    @Nullable
    final Destination destination;

    MessageProducerRequest(Message delegate, @Nullable Destination destination) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.destination = destination;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return MessageParser.channelKind(this.destination);
    }

    public String channelName() {
        return MessageParser.channelName(this.destination);
    }

    @Nullable
    String getProperty(String name) {
        return MessagePropagation.GETTER.get((Object)this.delegate, (Object)name);
    }

    void setProperty(String name, String value) {
        MessagePropagation.SETTER.put((Object)this.delegate, (Object)name, value);
    }
}

