/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.http.HttpRequest;
import brave.http.HttpServerAdapter;
import brave.propagation.Propagation;

public abstract class HttpServerRequest
extends HttpRequest {
    static final Propagation.Getter<HttpServerRequest, String> GETTER = new Propagation.Getter<HttpServerRequest, String>(){

        public String get(HttpServerRequest carrier, String key) {
            return carrier.header(key);
        }

        public String toString() {
            return "HttpServerRequest::header";
        }
    };

    public final Span.Kind spanKind() {
        return Span.Kind.SERVER;
    }

    public boolean parseClientIpAndPort(Span span) {
        return false;
    }

    @Deprecated
    static final class FromHttpAdapter<Req>
    extends HttpServerRequest {
        final HttpServerAdapter<Req, ?> adapter;
        final Req request;

        FromHttpAdapter(HttpServerAdapter<Req, ?> adapter, Req request) {
            if (adapter == null) {
                throw new NullPointerException("adapter == null");
            }
            this.adapter = adapter;
            if (request == null) {
                throw new NullPointerException("request == null");
            }
            this.request = request;
        }

        public Object unwrap() {
            return this.request;
        }

        @Override
        public long startTimestamp() {
            return this.adapter.startTimestamp(this.request);
        }

        @Override
        public String method() {
            return this.adapter.method(this.request);
        }

        @Override
        public String path() {
            return this.adapter.path(this.request);
        }

        @Override
        public String url() {
            return this.adapter.url(this.request);
        }

        @Override
        public String header(String name) {
            return this.adapter.requestHeader(this.request, name);
        }

        @Override
        public boolean parseClientIpAndPort(Span span) {
            return this.adapter.parseClientIpAndPort(this.request, span);
        }

        public final String toString() {
            return this.request.toString();
        }
    }

    @Deprecated
    static final class ToHttpAdapter
    extends HttpServerAdapter<Object, Void> {
        final HttpServerRequest delegate;
        final Object unwrapped;

        ToHttpAdapter(HttpServerRequest delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
            this.unwrapped = delegate.unwrap();
            if (this.unwrapped == null) {
                throw new NullPointerException("delegate.unwrap() == null");
            }
        }

        @Override
        public final boolean parseClientIpAndPort(Object req, Span span) {
            if (req == this.unwrapped) {
                if (this.parseClientIpFromXForwardedFor(req, span)) {
                    return true;
                }
                return this.delegate.parseClientIpAndPort(span);
            }
            return false;
        }

        @Override
        public final long startTimestamp(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.startTimestamp();
            }
            return 0L;
        }

        @Override
        public final String method(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.method();
            }
            return null;
        }

        @Override
        public final String url(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.url();
            }
            return null;
        }

        @Override
        public final String requestHeader(Object request, String name) {
            if (request == this.unwrapped) {
                return this.delegate.header(name);
            }
            return null;
        }

        @Override
        public final String path(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.path();
            }
            return null;
        }

        @Override
        public final String methodFromResponse(Void response) {
            return null;
        }

        @Override
        public final String route(Void response) {
            return null;
        }

        @Override
        public final int statusCodeAsInt(Void response) {
            return 0;
        }

        @Override
        public final Integer statusCode(Void response) {
            return null;
        }

        @Override
        public final long finishTimestamp(Void response) {
            return 0L;
        }

        public final String toString() {
            return this.delegate.toString();
        }
    }
}

