/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.internal.InternalPropagation;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.recorder.PendingSpan;
import brave.internal.recorder.TickClock;
import brave.propagation.TraceContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PendingSpans
extends ReferenceQueue<TraceContext> {
    final ConcurrentMap<Object, PendingSpan> delegate = new ConcurrentHashMap<Object, PendingSpan>(64);
    final Clock clock;
    final FinishedSpanHandler orphanedSpanHandler;
    final boolean trackOrphans;
    final AtomicBoolean noop;

    public PendingSpans(Clock clock, FinishedSpanHandler orphanedSpanHandler, boolean trackOrphans, AtomicBoolean noop) {
        this.clock = clock;
        this.orphanedSpanHandler = orphanedSpanHandler;
        this.trackOrphans = trackOrphans;
        this.noop = noop;
    }

    public PendingSpan getOrCreate(TraceContext context, boolean start) {
        PendingSpan newSpan;
        PendingSpan previousSpan;
        TickClock clock;
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.reportOrphanedSpans();
        PendingSpan result = (PendingSpan)this.delegate.get(context);
        if (result != null) {
            return result;
        }
        MutableSpan data = new MutableSpan();
        if (context.shared()) {
            data.setShared();
        }
        if ((clock = this.getClockFromParent(context)) == null) {
            clock = new TickClock(this.clock.currentTimeMicroseconds(), System.nanoTime());
            if (start) {
                data.startTimestamp(clock.baseEpochMicros);
            }
        } else if (start) {
            data.startTimestamp(clock.currentTimeMicroseconds());
        }
        if ((previousSpan = this.delegate.putIfAbsent(new RealKey(context, this), newSpan = new PendingSpan(data, clock))) != null) {
            return previousSpan;
        }
        if (this.trackOrphans) {
            newSpan.caller = new Throwable("Thread " + Thread.currentThread().getName() + " allocated span here");
        }
        return newSpan;
    }

    @Nullable
    TickClock getClockFromParent(TraceContext context) {
        long parentId = context.parentIdAsLong();
        PendingSpan parent = null;
        if (context.shared() || parentId != 0L) {
            long spanId = parentId != 0L ? parentId : context.spanId();
            parent = (PendingSpan)this.delegate.get(InternalPropagation.instance.newTraceContext(0, context.traceIdHigh(), context.traceId(), 0L, 0L, spanId, Collections.<Object>emptyList()));
        }
        return parent != null ? parent.clock : null;
    }

    public boolean remove(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        PendingSpan last = (PendingSpan)this.delegate.remove(context);
        this.reportOrphanedSpans();
        return last != null;
    }

    void reportOrphanedSpans() {
        RealKey contextKey;
        boolean noop;
        long flushTime = 0L;
        boolean bl = noop = this.orphanedSpanHandler == FinishedSpanHandler.NOOP || this.noop.get();
        while ((contextKey = (RealKey)this.poll()) != null) {
            PendingSpan value = (PendingSpan)this.delegate.remove(contextKey);
            if (noop || value == null) continue;
            if (flushTime == 0L) {
                flushTime = this.clock.currentTimeMicroseconds();
            }
            boolean isEmpty = value.state.isEmpty();
            Throwable caller = value.caller;
            TraceContext context = InternalPropagation.instance.newTraceContext(contextKey.flags, contextKey.traceIdHigh, contextKey.traceId, contextKey.localRootId, 0L, contextKey.spanId, Collections.<Object>emptyList());
            if (caller != null) {
                String message = isEmpty ? "Span " + context + " was allocated but never used" : "Span " + context + " neither finished nor flushed before GC";
                Platform.get().log(message, caller);
            }
            if (isEmpty) continue;
            value.state.annotate(flushTime, "brave.flush");
            this.orphanedSpanHandler.handle(context, value.state);
        }
    }

    public String toString() {
        return "PendingSpans" + this.delegate.keySet();
    }

    static final class LookupKey {
        long traceIdHigh;
        long traceId;
        long spanId;
        boolean shared;
        int hashCode;

        LookupKey() {
        }

        void set(TraceContext context) {
            this.set(context.traceIdHigh(), context.traceId(), context.spanId(), context.shared());
        }

        void set(long traceIdHigh, long traceId, long spanId, boolean shared) {
            this.traceIdHigh = traceIdHigh;
            this.traceId = traceId;
            this.spanId = spanId;
            this.shared = shared;
            this.hashCode = LookupKey.generateHashCode(traceIdHigh, traceId, spanId, shared);
        }

        public int hashCode() {
            return this.hashCode;
        }

        static int generateHashCode(long traceIdHigh, long traceId, long spanId, boolean shared) {
            int h = 1;
            h *= 1000003;
            h ^= (int)(traceIdHigh >>> 32 ^ traceIdHigh);
            h *= 1000003;
            h ^= (int)(traceId >>> 32 ^ traceId);
            h *= 1000003;
            h ^= (int)(spanId >>> 32 ^ spanId);
            h *= 1000003;
            return h ^= shared ? 16 : 0;
        }

        public boolean equals(Object other) {
            RealKey that = (RealKey)other;
            TraceContext thatContext = (TraceContext)that.get();
            if (thatContext == null) {
                return false;
            }
            return this.traceIdHigh == thatContext.traceIdHigh() && this.traceId == thatContext.traceId() && this.spanId == thatContext.spanId() && this.shared == thatContext.shared();
        }
    }

    static final class RealKey
    extends WeakReference<TraceContext> {
        final int hashCode;
        final long traceIdHigh;
        final long traceId;
        final long localRootId;
        final long spanId;
        final int flags;

        RealKey(TraceContext context, ReferenceQueue<TraceContext> queue) {
            super(context, queue);
            this.hashCode = context.hashCode();
            this.traceIdHigh = context.traceIdHigh();
            this.traceId = context.traceId();
            this.localRootId = context.localRootId();
            this.spanId = context.spanId();
            this.flags = InternalPropagation.instance.flags(context);
        }

        public String toString() {
            TraceContext context = (TraceContext)this.get();
            return context != null ? "WeakReference(" + context + ")" : "ClearedReference()";
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            TraceContext thisContext = (TraceContext)this.get();
            TraceContext thatContext = (TraceContext)((RealKey)other).get();
            if (thisContext == null) {
                return thatContext == null;
            }
            return thisContext.equals(thatContext);
        }
    }
}

