/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

public abstract class CorrelationFieldScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    @Override
    public CurrentTraceContext.Scope decorateScope(@Nullable TraceContext currentSpan, final CurrentTraceContext.Scope scope) {
        final String previousTraceId = this.get("traceId");
        final String previousSpanId = this.get("spanId");
        final String previousParentId = this.get("parentId");
        final String previousSampled = this.get("sampled");
        if (currentSpan != null) {
            this.maybeReplaceTraceContext(currentSpan, previousTraceId, previousParentId, previousSpanId, previousSampled);
        } else {
            this.remove("traceId");
            this.remove("parentId");
            this.remove("spanId");
            this.remove("sampled");
        }
        class CorrelationFieldCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            CorrelationFieldCurrentTraceContextScope() {
            }

            @Override
            public void close() {
                scope.close();
                CorrelationFieldScopeDecorator.this.replace("traceId", previousTraceId);
                CorrelationFieldScopeDecorator.this.replace("parentId", previousParentId);
                CorrelationFieldScopeDecorator.this.replace("spanId", previousSpanId);
                CorrelationFieldScopeDecorator.this.replace("sampled", previousSampled);
            }
        }
        return new CorrelationFieldCurrentTraceContextScope();
    }

    void maybeReplaceTraceContext(TraceContext currentSpan, String previousTraceId, @Nullable String previousParentId, String previousSpanId, @Nullable String previousSampled) {
        Boolean sampled;
        String parentId;
        String traceId = currentSpan.traceIdString();
        if (!traceId.equals(previousTraceId)) {
            this.put("traceId", currentSpan.traceIdString());
        }
        if ((parentId = currentSpan.parentIdString()) == null) {
            this.remove("parentId");
        } else {
            boolean sameParentId = parentId.equals(previousParentId);
            if (!sameParentId) {
                this.put("parentId", parentId);
            }
        }
        String spanId = currentSpan.spanIdString();
        if (!spanId.equals(previousSpanId)) {
            this.put("spanId", spanId);
        }
        if ((sampled = currentSpan.sampled()) == null) {
            this.remove("sampled");
        } else {
            String sampledString = sampled.toString();
            boolean sameSampled = sampledString.equals(previousSampled);
            if (!sameSampled) {
                this.put("sampled", sampledString);
            }
        }
    }

    @Nullable
    protected abstract String get(String var1);

    protected abstract void put(String var1, String var2);

    protected abstract void remove(String var1);

    final void replace(String key, @Nullable String value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }
}

