/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.propagation.TraceContext;
import java.util.Map;

public abstract class PropagationFields<K, V> {
    long traceId;
    long spanId;

    public abstract V get(K var1);

    public abstract void put(K var1, V var2);

    public abstract void forEach(FieldConsumer<K, V> var1);

    public abstract boolean isEmpty();

    abstract void putAllIfAbsent(PropagationFields<K, V> var1);

    protected abstract Map<K, V> toMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean tryToClaim(long traceId, long spanId) {
        PropagationFields propagationFields = this;
        synchronized (propagationFields) {
            if (this.traceId == 0L) {
                this.traceId = traceId;
                this.spanId = spanId;
                return true;
            }
            return this.traceId == traceId && this.spanId == spanId;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.toMap();
    }

    public static <K, V> V get(TraceContext context, K key, Class<? extends PropagationFields<K, V>> type) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        PropagationFields<K, V> fields = context.findExtra(type);
        return fields != null ? (V)fields.get(key) : null;
    }

    public static <K, V> void put(TraceContext context, K key, V value, Class<? extends PropagationFields<K, V>> type) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        PropagationFields<K, V> fields = context.findExtra(type);
        if (fields == null) {
            return;
        }
        fields.put(key, value);
    }

    public static interface FieldConsumer<K, V> {
        public void accept(K var1, V var2);
    }
}

