/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.internal.PropagationFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PredefinedPropagationFields
extends PropagationFields<String, String> {
    final String[] fieldNames;
    volatile String[] values;

    protected PredefinedPropagationFields(String ... fieldNames) {
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        if (fieldNames.length == 0) {
            throw new NullPointerException("fieldNames is empty");
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i] == null) {
                throw new NullPointerException("fieldNames[" + i + "] == null");
            }
            if (!fieldNames[i].isEmpty()) continue;
            throw new NullPointerException("fieldNames[" + i + "] is empty");
        }
        this.fieldNames = fieldNames;
    }

    protected PredefinedPropagationFields(PredefinedPropagationFields parent, String ... fieldNames) {
        this(fieldNames);
        this.checkSameFields(parent);
        this.values = parent.values;
    }

    @Override
    public String get(String name) {
        int index = this.indexOf(name);
        return index != -1 ? this.get(index) : null;
    }

    @Override
    public String get(int index) {
        if (index >= this.fieldNames.length) {
            return null;
        }
        String[] elements = this.values;
        return elements != null ? elements[index] : null;
    }

    @Override
    public void forEach(PropagationFields.FieldConsumer<String, String> fieldConsumer) {
        String[] elements = this.values;
        if (elements == null) {
            return;
        }
        int length = this.fieldNames.length;
        for (int i = 0; i < length; ++i) {
            String value = elements[i];
            if (value == null) continue;
            fieldConsumer.accept(this.fieldNames[i], value);
        }
    }

    @Override
    public final void put(String name, String value) {
        int index = this.indexOf(name);
        if (index == -1) {
            return;
        }
        this.put(index, value);
    }

    @Override
    public boolean isEmpty() {
        String[] elements = this.values;
        if (elements == null) {
            return true;
        }
        for (String value : elements) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(int index, String value) {
        if (index >= this.fieldNames.length) {
            return;
        }
        PredefinedPropagationFields predefinedPropagationFields = this;
        synchronized (predefinedPropagationFields) {
            String[] elements = this.values;
            if (elements == null) {
                elements = new String[this.fieldNames.length];
                elements[index] = value;
            } else {
                if (value.equals(elements[index])) {
                    return;
                }
                elements = Arrays.copyOf(elements, elements.length);
                elements[index] = value;
            }
            this.values = elements;
        }
    }

    @Override
    protected final void putAllIfAbsent(PropagationFields parent) {
        if (!(parent instanceof PredefinedPropagationFields)) {
            return;
        }
        PredefinedPropagationFields predefinedParent = (PredefinedPropagationFields)parent;
        this.checkSameFields(predefinedParent);
        String[] parentValues = predefinedParent.values;
        if (parentValues == null) {
            return;
        }
        for (int i = 0; i < parentValues.length; ++i) {
            if (parentValues[i] == null || this.get(i) != null) continue;
            this.put(i, parentValues[i]);
        }
    }

    void checkSameFields(PredefinedPropagationFields predefinedParent) {
        if (!Arrays.equals(this.fieldNames, predefinedParent.fieldNames)) {
            throw new IllegalStateException(String.format("Mixed name configuration unsupported: found %s, expected %s", Arrays.toString(this.fieldNames), Arrays.toString(predefinedParent.fieldNames)));
        }
    }

    @Override
    public final Map<String, String> toMap() {
        String[] elements = this.values;
        if (elements == null) {
            return Collections.emptyMap();
        }
        MapFieldConsumer result = new MapFieldConsumer();
        this.forEach(result);
        return result;
    }

    int indexOf(String name) {
        int length = this.fieldNames.length;
        for (int i = 0; i < length; ++i) {
            if (!this.fieldNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.toMap();
    }

    public int hashCode() {
        Object[] values = this.values;
        return values == null ? 0 : Arrays.hashCode(values);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredefinedPropagationFields)) {
            return false;
        }
        PredefinedPropagationFields that = (PredefinedPropagationFields)o;
        Object[] values = this.values;
        Object[] thatValues = that.values;
        return values == null ? thatValues == null : Arrays.equals(values, thatValues);
    }

    static final class MapFieldConsumer
    extends LinkedHashMap<String, String>
    implements PropagationFields.FieldConsumer<String, String> {
        MapFieldConsumer() {
        }

        @Override
        public void accept(String key, String value) {
            this.put(key, value);
        }
    }
}

