/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.Tracer;
import brave.handler.FinishedSpanHandler;
import brave.internal.IpLiteral;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.handler.NoopAwareFinishedSpanHandler;
import brave.internal.handler.ZipkinFinishedSpanHandler;
import brave.internal.recorder.PendingSpans;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public abstract class Tracing
implements Closeable {
    static final AtomicReference<Object> CURRENT = new AtomicReference();

    public static Builder newBuilder() {
        return new Builder();
    }

    public abstract Tracer tracer();

    public Propagation<String> propagation() {
        return this.propagationFactory().create(Propagation.KeyFactory.STRING);
    }

    public abstract Propagation.Factory propagationFactory();

    public abstract Sampler sampler();

    public abstract CurrentTraceContext currentTraceContext();

    public final Clock clock(TraceContext context) {
        return this.tracer().pendingSpans.getOrCreate(context, false).clock();
    }

    public abstract ErrorParser errorParser();

    @Nullable
    public static Tracing current() {
        return (Tracing)CURRENT.get();
    }

    @Nullable
    public static Tracer currentTracer() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.tracer() : null;
    }

    public abstract boolean isNoop();

    public abstract void setNoop(boolean var1);

    @Override
    public abstract void close();

    static FinishedSpanHandler zipkinReportingFinishedSpanHandler(Set<FinishedSpanHandler> input, FinishedSpanHandler zipkinHandler, AtomicBoolean noop) {
        ArrayList<FinishedSpanHandler> defensiveCopy = new ArrayList<FinishedSpanHandler>(input);
        if (zipkinHandler != FinishedSpanHandler.NOOP) {
            defensiveCopy.add(zipkinHandler);
        }
        return NoopAwareFinishedSpanHandler.create(defensiveCopy, noop);
    }

    Tracing() {
    }

    static final class Default
    extends Tracing {
        final Tracer tracer;
        final Propagation.Factory propagationFactory;
        final Propagation<String> stringPropagation;
        final CurrentTraceContext currentTraceContext;
        final Sampler sampler;
        final Clock clock;
        final ErrorParser errorParser;
        final AtomicBoolean noop;

        Default(Builder builder) {
            this.clock = builder.clock;
            this.errorParser = builder.errorParser;
            this.propagationFactory = builder.propagationFactory;
            this.stringPropagation = builder.propagationFactory.create(Propagation.KeyFactory.STRING);
            this.currentTraceContext = builder.currentTraceContext;
            this.sampler = builder.sampler;
            this.noop = new AtomicBoolean();
            FinishedSpanHandler zipkinHandler = builder.spanReporter != Reporter.NOOP ? new ZipkinFinishedSpanHandler(builder.spanReporter, this.errorParser, builder.localServiceName, builder.localIp, builder.localPort, builder.alwaysReportSpans) : FinishedSpanHandler.NOOP;
            FinishedSpanHandler finishedSpanHandler = Default.zipkinReportingFinishedSpanHandler(builder.finishedSpanHandlers, zipkinHandler, this.noop);
            LinkedHashSet<FinishedSpanHandler> orphanedSpanHandlers = new LinkedHashSet<FinishedSpanHandler>();
            for (FinishedSpanHandler handler : builder.finishedSpanHandlers) {
                if (!handler.supportsOrphans()) continue;
                orphanedSpanHandlers.add(handler);
            }
            FinishedSpanHandler orphanedSpanHandler = finishedSpanHandler;
            boolean allHandlersSupportOrphans = builder.finishedSpanHandlers.equals(orphanedSpanHandlers);
            if (!allHandlersSupportOrphans) {
                orphanedSpanHandler = Default.zipkinReportingFinishedSpanHandler(orphanedSpanHandlers, zipkinHandler, this.noop);
            }
            this.tracer = new Tracer(builder.clock, builder.propagationFactory, finishedSpanHandler, new PendingSpans(this.clock, orphanedSpanHandler, builder.trackOrphans, this.noop), builder.sampler, builder.currentTraceContext, builder.traceId128Bit || this.propagationFactory.requires128BitTraceId(), builder.supportsJoin && this.propagationFactory.supportsJoin(), finishedSpanHandler.alwaysSampleLocal(), this.noop);
            CURRENT.compareAndSet(null, this);
        }

        @Override
        public Tracer tracer() {
            return this.tracer;
        }

        @Override
        public Propagation<String> propagation() {
            return this.stringPropagation;
        }

        @Override
        public Propagation.Factory propagationFactory() {
            return this.propagationFactory;
        }

        @Override
        public Sampler sampler() {
            return this.sampler;
        }

        @Override
        public CurrentTraceContext currentTraceContext() {
            return this.currentTraceContext;
        }

        @Override
        public ErrorParser errorParser() {
            return this.errorParser;
        }

        @Override
        public boolean isNoop() {
            return this.noop.get();
        }

        @Override
        public void setNoop(boolean noop) {
            this.noop.set(noop);
        }

        public String toString() {
            return this.tracer.toString();
        }

        @Override
        public void close() {
            CURRENT.compareAndSet(this, null);
        }
    }

    static final class LoggingReporter
    implements Reporter<Span> {
        final Logger logger = Logger.getLogger(Tracer.class.getName());

        LoggingReporter() {
        }

        public void report(Span span) {
            if (span == null) {
                throw new NullPointerException("span == null");
            }
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            this.logger.info(span.toString());
        }

        public String toString() {
            return "LoggingReporter{name=" + this.logger.getName() + "}";
        }
    }

    public static final class Builder {
        String localServiceName = "unknown";
        String localIp;
        int localPort;
        Reporter<Span> spanReporter;
        Clock clock;
        Sampler sampler = Sampler.ALWAYS_SAMPLE;
        CurrentTraceContext currentTraceContext = CurrentTraceContext.Default.inheritable();
        boolean traceId128Bit = false;
        boolean supportsJoin = true;
        boolean alwaysReportSpans = false;
        boolean trackOrphans = false;
        Propagation.Factory propagationFactory = B3Propagation.FACTORY;
        ErrorParser errorParser = new ErrorParser();
        Set<FinishedSpanHandler> finishedSpanHandlers = new LinkedHashSet<FinishedSpanHandler>();

        public Builder localServiceName(String localServiceName) {
            if (localServiceName == null || localServiceName.isEmpty()) {
                throw new IllegalArgumentException(localServiceName + " is not a valid serviceName");
            }
            this.localServiceName = localServiceName.toLowerCase(Locale.ROOT);
            return this;
        }

        public Builder localIp(String localIp) {
            String maybeIp = IpLiteral.ipOrNull(localIp);
            if (maybeIp == null) {
                throw new IllegalArgumentException(localIp + " is not a valid IP");
            }
            this.localIp = maybeIp;
            return this;
        }

        public Builder localPort(int localPort) {
            if (localPort > 65535) {
                throw new IllegalArgumentException("invalid localPort " + localPort);
            }
            if (localPort < 0) {
                localPort = 0;
            }
            this.localPort = localPort;
            return this;
        }

        @Deprecated
        public Builder endpoint(Endpoint endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.localServiceName = endpoint.serviceName();
            this.localIp = endpoint.ipv6() != null ? endpoint.ipv6() : endpoint.ipv4();
            this.localPort = endpoint.portAsInt();
            return this;
        }

        public Builder spanReporter(Reporter<Span> spanReporter) {
            if (spanReporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            this.spanReporter = spanReporter;
            return this;
        }

        public Builder clock(Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock == null");
            }
            this.clock = clock;
            return this;
        }

        public Builder sampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("sampler == null");
            }
            this.sampler = sampler;
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            if (currentTraceContext == null) {
                throw new NullPointerException("currentTraceContext == null");
            }
            this.currentTraceContext = currentTraceContext;
            return this;
        }

        public Builder propagationFactory(Propagation.Factory propagationFactory) {
            if (propagationFactory == null) {
                throw new NullPointerException("propagationFactory == null");
            }
            this.propagationFactory = propagationFactory;
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.traceId128Bit = traceId128Bit;
            return this;
        }

        public Builder supportsJoin(boolean supportsJoin) {
            this.supportsJoin = supportsJoin;
            return this;
        }

        public Builder errorParser(ErrorParser errorParser) {
            this.errorParser = errorParser;
            return this;
        }

        public Builder addFinishedSpanHandler(FinishedSpanHandler handler) {
            if (handler == null) {
                throw new NullPointerException("finishedSpanHandler == null");
            }
            if (handler != FinishedSpanHandler.NOOP && !this.finishedSpanHandlers.add(handler)) {
                Platform.get().log("Please check configuration as %s was added twice", handler, null);
            }
            return this;
        }

        public Builder alwaysReportSpans() {
            this.alwaysReportSpans = true;
            return this;
        }

        public Builder trackOrphans() {
            this.trackOrphans = true;
            return this;
        }

        public Tracing build() {
            if (this.clock == null) {
                this.clock = Platform.get().clock();
            }
            if (this.localIp == null) {
                this.localIp = Platform.get().linkLocalIp();
            }
            if (this.spanReporter == null) {
                this.spanReporter = new LoggingReporter();
            }
            return new Default(this);
        }

        Builder() {
        }
    }
}

