/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Collections;
import java.util.List;

public final class B3SinglePropagation<K>
implements Propagation<K> {
    public static final Propagation.Factory FACTORY = new Propagation.Factory(){

        public <K1> Propagation<K1> create(Propagation.KeyFactory<K1> keyFactory) {
            return new B3SinglePropagation<K1>(keyFactory);
        }

        @Override
        public boolean supportsJoin() {
            return true;
        }

        public String toString() {
            return "B3SinglePropagationFactory";
        }
    };
    final K b3Key;
    final List<K> fields;

    B3SinglePropagation(Propagation.KeyFactory<K> keyFactory) {
        this.b3Key = keyFactory.create("b3");
        this.fields = Collections.unmodifiableList(Collections.singletonList(this.b3Key));
    }

    @Override
    public List<K> keys() {
        return this.fields;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new B3SingleInjector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new B3SingleExtractor<C, K>(this.b3Key, getter);
    }

    static final class B3SingleExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final K b3Key;
        final Propagation.Getter<C, K> getter;

        B3SingleExtractor(K b3Key, Propagation.Getter<C, K> getter) {
            this.b3Key = b3Key;
            this.getter = getter;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            if (carrier == null) {
                throw new NullPointerException("carrier == null");
            }
            String b3 = this.getter.get(carrier, this.b3Key);
            if (b3 == null) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
            TraceContextOrSamplingFlags extracted = B3SingleFormat.parseB3SingleFormat(b3);
            if (extracted == null) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
            return extracted;
        }
    }

    static final class B3SingleInjector<C, K>
    implements TraceContext.Injector<C> {
        final B3SinglePropagation<K> propagation;
        final Propagation.Setter<C, K> setter;

        B3SingleInjector(B3SinglePropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.setter.put(carrier, this.propagation.b3Key, B3SingleFormat.writeB3SingleFormat(traceContext));
        }
    }
}

