/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.RealSpan;
import brave.Span;
import brave.SpanCustomizer;
import brave.SpanCustomizerShield;
import brave.Tracer;
import brave.propagation.TraceContext;

final class LazySpan
extends Span {
    final Tracer tracer;
    final TraceContext context;
    Span delegate;

    LazySpan(Tracer tracer, TraceContext context) {
        this.tracer = tracer;
        this.context = context;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public TraceContext context() {
        return this.context;
    }

    @Override
    public SpanCustomizer customizer() {
        return new SpanCustomizerShield(this);
    }

    @Override
    public Span start() {
        return this.span().start();
    }

    @Override
    public Span start(long timestamp) {
        return this.span().start(timestamp);
    }

    @Override
    public Span name(String name) {
        return this.span().name(name);
    }

    @Override
    public Span kind(Span.Kind kind) {
        return this.span().kind(kind);
    }

    @Override
    public Span annotate(String value) {
        return this.span().annotate(value);
    }

    @Override
    public Span annotate(long timestamp, String value) {
        return this.span().annotate(timestamp, value);
    }

    @Override
    public Span tag(String key, String value) {
        return this.span().tag(key, value);
    }

    @Override
    public Span error(Throwable throwable) {
        return this.span().error(throwable);
    }

    @Override
    public Span remoteServiceName(String remoteServiceName) {
        return this.span().remoteServiceName(remoteServiceName);
    }

    @Override
    public boolean remoteIpAndPort(String remoteIp, int remotePort) {
        return this.span().remoteIpAndPort(remoteIp, remotePort);
    }

    @Override
    public void finish() {
        this.span().finish();
    }

    @Override
    public void finish(long timestamp) {
        this.span().finish(timestamp);
    }

    @Override
    public void abandon() {
        if (this.delegate == null) {
            return;
        }
        this.span().abandon();
    }

    @Override
    public void flush() {
        if (this.delegate == null) {
            return;
        }
        this.span().flush();
    }

    public String toString() {
        return "LazySpan(" + this.context + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return RealSpan.isEqualToRealOrLazySpan(this.context, o);
    }

    Span span() {
        Span result = this.delegate;
        if (result != null) {
            return result;
        }
        this.delegate = this.tracer.toSpan(this.context);
        return this.delegate;
    }

    public int hashCode() {
        return this.context.hashCode();
    }
}

