/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.AutoValue_ThreadLocalSpan;
import brave.propagation.AutoValue_ThreadLocalSpan_SpanAndScope;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.auto.value.AutoValue;
import java.util.ArrayDeque;
import java.util.Deque;

@AutoValue
public abstract class ThreadLocalSpan {
    public static final ThreadLocalSpan CURRENT_TRACER = new ThreadLocalSpan(){

        @Override
        Tracer tracer() {
            return Tracing.currentTracer();
        }
    };
    final ThreadLocal<Deque<SpanAndScope>> currentSpanInScope = new ThreadLocal<Deque<SpanAndScope>>(){

        @Override
        protected Deque<SpanAndScope> initialValue() {
            return new ArrayDeque<SpanAndScope>();
        }
    };

    public static ThreadLocalSpan create(Tracer tracer) {
        return new AutoValue_ThreadLocalSpan(tracer);
    }

    abstract Tracer tracer();

    @Nullable
    public Span next(TraceContextOrSamplingFlags extracted) {
        Tracer tracer = this.tracer();
        if (tracer == null) {
            return null;
        }
        Span next = tracer.nextSpan(extracted);
        SpanAndScope spanAndScope = SpanAndScope.create(next, tracer.withSpanInScope(next));
        this.currentSpanInScope.get().addFirst(spanAndScope);
        return next;
    }

    @Nullable
    public Span next() {
        Tracer tracer = this.tracer();
        if (tracer == null) {
            return null;
        }
        Span next = tracer.nextSpan();
        SpanAndScope spanAndScope = SpanAndScope.create(next, tracer.withSpanInScope(next));
        this.currentSpanInScope.get().addFirst(spanAndScope);
        return next;
    }

    @Nullable
    public Span remove() {
        Tracer tracer = this.tracer();
        Span currentSpan = tracer != null ? tracer.currentSpan() : null;
        SpanAndScope scope = this.currentSpanInScope.get().pollFirst();
        if (scope == null) {
            return currentSpan;
        }
        scope.scope().close();
        assert (scope.span().equals(currentSpan)) : "Misalignment: scoped span " + scope.span() + " !=  current span " + currentSpan;
        return currentSpan;
    }

    ThreadLocalSpan() {
    }

    @AutoValue
    static abstract class SpanAndScope {
        SpanAndScope() {
        }

        static SpanAndScope create(Span span, Tracer.SpanInScope scope) {
            return new AutoValue_ThreadLocalSpan_SpanAndScope(span, scope);
        }

        abstract Span span();

        abstract Tracer.SpanInScope scope();
    }
}

