/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.internal.Nullable;
import brave.internal.recorder.MutableSpan;
import brave.propagation.TraceContext;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

final class MutableSpanMap
extends ReferenceQueue<TraceContext> {
    static final Logger logger = Logger.getLogger(MutableSpanMap.class.getName());
    final ConcurrentMap<Object, MutableSpan> delegate = new ConcurrentHashMap<Object, MutableSpan>(64);
    final Endpoint endpoint;
    final Clock clock;
    final Reporter<Span> reporter;
    final AtomicBoolean noop;

    MutableSpanMap(Endpoint endpoint, Clock clock, Reporter<Span> reporter, AtomicBoolean noop) {
        this.endpoint = endpoint;
        this.clock = clock;
        this.reporter = reporter;
        this.noop = noop;
    }

    @Nullable
    MutableSpan get(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.reportOrphanedSpans();
        return (MutableSpan)this.delegate.get(new LookupKey(context));
    }

    MutableSpan getOrCreate(TraceContext context) {
        MutableSpan newSpan;
        MutableSpan previousSpan;
        MutableSpan result = this.get(context);
        if (result != null) {
            return result;
        }
        Clock clock = this.maybeClockFromParent(context);
        if (clock == null) {
            clock = new TickClock(this.clock.currentTimeMicroseconds(), System.nanoTime());
        }
        if ((previousSpan = this.delegate.putIfAbsent(new RealKey(context, this), newSpan = new MutableSpan(clock, context, this.endpoint))) != null) {
            return previousSpan;
        }
        return newSpan;
    }

    @Nullable
    Clock maybeClockFromParent(TraceContext context) {
        long parentId = context.parentIdAsLong();
        if (parentId == 0L) {
            return null;
        }
        MutableSpan parent = (MutableSpan)this.delegate.get(new LookupKey(context.toBuilder().spanId(parentId).build()));
        return parent != null ? parent.clock : null;
    }

    @Nullable
    MutableSpan remove(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        MutableSpan result = (MutableSpan)this.delegate.remove(new LookupKey(context));
        this.reportOrphanedSpans();
        return result;
    }

    void reportOrphanedSpans() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            TraceContext context = (TraceContext)reference.get();
            MutableSpan value = (MutableSpan)this.delegate.remove(reference);
            if (value == null || this.noop.get()) continue;
            try {
                value.annotate(value.clock.currentTimeMicroseconds(), "brave.flush");
                this.reporter.report((Object)value.toSpan());
            }
            catch (RuntimeException e) {
                if (context == null || !logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "error flushing " + context, e);
            }
        }
    }

    public String toString() {
        return "MutableSpanMap" + this.delegate.keySet();
    }

    static final class TickClock
    implements Clock {
        final long baseEpochMicros;
        final long baseTickNanos;

        TickClock(long baseEpochMicros, long baseTickNanos) {
            this.baseEpochMicros = baseEpochMicros;
            this.baseTickNanos = baseTickNanos;
        }

        @Override
        public long currentTimeMicroseconds() {
            return (System.nanoTime() - this.baseTickNanos) / 1000L + this.baseEpochMicros;
        }

        public String toString() {
            return "TickClock{baseEpochMicros=" + this.baseEpochMicros + ", baseTickNanos=" + this.baseTickNanos + "}";
        }
    }

    static final class LookupKey {
        final TraceContext context;

        LookupKey(TraceContext context) {
            this.context = context;
        }

        public int hashCode() {
            return this.context.hashCode();
        }

        public boolean equals(Object other) {
            return this.context.equals(((RealKey)other).get());
        }
    }

    static final class RealKey
    extends WeakReference<TraceContext> {
        final int hashCode;

        RealKey(TraceContext context, ReferenceQueue<TraceContext> queue) {
            super(context, queue);
            this.hashCode = context.hashCode();
        }

        public String toString() {
            TraceContext context = (TraceContext)this.get();
            return context != null ? "WeakReference(" + context + ")" : "ClearedReference()";
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            TraceContext thisContext = (TraceContext)this.get();
            TraceContext thatContext = (TraceContext)((RealKey)other).get();
            if (thisContext == null) {
                return thatContext == null;
            }
            return thisContext.equals(thatContext);
        }
    }
}

