/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.Clock;
import brave.Tracer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public abstract class Platform {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final Platform PLATFORM = Platform.findPlatform();
    volatile Endpoint endpoint;

    public Reporter<Span> reporter() {
        return LoggingReporter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint endpoint() {
        if (this.endpoint == null) {
            Platform platform = this;
            synchronized (platform) {
                if (this.endpoint == null) {
                    this.endpoint = this.produceEndpoint();
                }
            }
        }
        return this.endpoint;
    }

    Endpoint produceEndpoint() {
        Endpoint.Builder builder;
        block5: {
            builder = Endpoint.newBuilder().serviceName("unknown");
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        Jre9 jre9 = Jre9.buildIfSupported();
        if (jre9 != null) {
            return jre9;
        }
        Jre7 jre7 = Jre7.buildIfSupported();
        if (jre7 != null) {
            return jre7;
        }
        return new Jre6();
    }

    public abstract long randomLong();

    public abstract long nextTraceIdHigh();

    public Clock clock() {
        return new Clock(){

            @Override
            public long currentTimeMicroseconds() {
                return System.currentTimeMillis() * 1000L;
            }

            public String toString() {
                return "System.currentTimeMillis()";
            }
        };
    }

    static long nextTraceIdHigh(int random) {
        long epochSeconds = System.currentTimeMillis() / 1000L;
        return (epochSeconds & 0xFFFFFFFFL) << 32 | (long)random & 0xFFFFFFFFL;
    }

    static class Jre6
    extends Platform {
        final Random prng = new Random(System.nanoTime());

        @Override
        public long randomLong() {
            return this.prng.nextLong();
        }

        @Override
        public long nextTraceIdHigh() {
            return Jre6.nextTraceIdHigh(this.prng.nextInt());
        }

        Jre6() {
        }

        public String toString() {
            return "Jre6{}";
        }
    }

    static class Jre7
    extends Platform {
        Jre7() {
        }

        static Jre7 buildIfSupported() {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new Jre7();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public long randomLong() {
            return ThreadLocalRandom.current().nextLong();
        }

        @Override
        @IgnoreJRERequirement
        public long nextTraceIdHigh() {
            return Jre7.nextTraceIdHigh(ThreadLocalRandom.current().nextInt());
        }

        public String toString() {
            return "Jre7{}";
        }
    }

    static class Jre9
    extends Jre7 {
        Jre9() {
        }

        static Jre9 buildIfSupported() {
            try {
                Class<?> zoneId = Class.forName("java.time.ZoneId");
                Class.forName("java.time.Clock").getMethod("tickMillis", zoneId);
                return new Jre9();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        @Override
        @IgnoreJRERequirement
        public Clock clock() {
            return new Clock(){

                @Override
                public long currentTimeMicroseconds() {
                    Instant instant = java.time.Clock.systemUTC().instant();
                    return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
                }

                public String toString() {
                    return "Clock.systemUTC().instant()";
                }
            };
        }

        @Override
        public String toString() {
            return "Jre9{}";
        }
    }

    static enum LoggingReporter implements Reporter<Span>
    {
        INSTANCE;


        public void report(Span span) {
            if (!logger.isLoggable(Level.INFO)) {
                return;
            }
            if (span == null) {
                throw new NullPointerException("span == null");
            }
            logger.info(span.toString());
        }

        public String toString() {
            return "LoggingReporter{name=" + logger.getName() + "}";
        }
    }
}

