/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.propagation.TraceContext;

public final class HexCodec {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static long lowerHexToUnsignedLong(CharSequence lowerHex) {
        int length = lowerHex.length();
        if (length < 1 || length > 32) {
            throw HexCodec.isntLowerHexLong(lowerHex);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return HexCodec.lowerHexToUnsignedLong(lowerHex, beginIndex);
    }

    public static long lowerHexToUnsignedLong(CharSequence lowerHex, int index) {
        int endIndex = Math.min(index + 16, lowerHex.length());
        long result = HexCodec.lenientLowerHexToUnsignedLong(lowerHex, index, endIndex);
        if (result == 0L) {
            throw HexCodec.isntLowerHexLong(lowerHex);
        }
        return result;
    }

    public static long lenientLowerHexToUnsignedLong(CharSequence lowerHex, int index, int endIndex) {
        long result = 0L;
        while (index < endIndex) {
            char c = lowerHex.charAt(index++);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
                continue;
            }
            return 0L;
        }
        return result;
    }

    static NumberFormatException isntLowerHexLong(CharSequence lowerHex) {
        throw new NumberFormatException(lowerHex + " should be a 1 to 32 character lower-hex string with no prefix");
    }

    public static String toLowerHex(long high, long low) {
        char[] result = new char[high != 0L ? 32 : 16];
        int pos = 0;
        if (high != 0L) {
            HexCodec.writeHexLong(result, pos, high);
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, low);
        return new String(result);
    }

    public static boolean lowerHexEqualsUnsignedLong(CharSequence lowerHex, long unsigned) {
        if (lowerHex == null || lowerHex.length() != 16) {
            return false;
        }
        return HexCodec.lowerHexEqualsUnsignedLong(lowerHex, 0, unsigned);
    }

    public static boolean lowerHexEqualsTraceId(CharSequence lowerHex, TraceContext context) {
        if (lowerHex == null) {
            return false;
        }
        int length = lowerHex.length();
        long high = context.traceIdHigh();
        long low = context.traceId();
        int pos = 0;
        if (length == 32) {
            if (!HexCodec.lowerHexEqualsUnsignedLong(lowerHex, pos, high)) {
                return false;
            }
            pos += 16;
        } else if (length != 16 || high != 0L) {
            return false;
        }
        return HexCodec.lowerHexEqualsUnsignedLong(lowerHex, pos, low);
    }

    public static String toLowerHex(long v) {
        char[] data = new char[16];
        HexCodec.writeHexLong(data, 0, v);
        return new String(data);
    }

    public static void writeHexLong(char[] data, int pos, long v) {
        HexCodec.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    public static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    static boolean lowerHexEqualsUnsignedLong(CharSequence data, int pos, long v) {
        if (!HexCodec.hexEqualsByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL))) {
            return false;
        }
        if (!HexCodec.hexEqualsByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL))) {
            return false;
        }
        return HexCodec.hexEqualsByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static boolean hexEqualsByte(CharSequence data, int pos, byte b) {
        return data.charAt(pos + 0) == HEX_DIGITS[b >> 4 & 0xF] && data.charAt(pos + 1) == HEX_DIGITS[b & 0xF];
    }

    HexCodec() {
    }
}

