/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.grpc;

import com.google.protobuf.ByteString;
import io.weaviate.client.Config;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.grpc.query.Raw;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class GRPC {
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private Config config;
    private HttpClient httpClient;
    private AccessTokenProvider tokenProvider;

    public GRPC(HttpClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        this.config = config;
        this.httpClient = httpClient;
        this.tokenProvider = tokenProvider;
    }

    public Raw raw() {
        return new Raw(this.httpClient, this.config, this.tokenProvider);
    }

    public Arguments arguments() {
        return new Arguments();
    }

    public static ByteString toByteString(Float[] vector) {
        if (vector == null || vector.length == 0) {
            return ByteString.EMPTY;
        }
        ByteBuffer buffer = ByteBuffer.allocate(vector.length * 4).order(BYTE_ORDER);
        Arrays.stream(vector).forEach(buffer::putFloat);
        return ByteString.copyFrom((byte[])buffer.array());
    }

    public static ByteString toByteString(float[] vector) {
        ByteBuffer buffer = ByteBuffer.allocate(vector.length * 4).order(BYTE_ORDER);
        for (float f : vector) {
            buffer.putFloat(f);
        }
        return ByteString.copyFrom((byte[])buffer.array());
    }

    public static ByteString toByteString(Float[][] vectors) {
        if (vectors == null || vectors.length == 0 || vectors[0].length == 0) {
            return ByteString.EMPTY;
        }
        int n = vectors.length;
        short dimensions = (short)vectors[0].length;
        int capacity = 2 + n * dimensions * 4;
        ByteBuffer buffer = ByteBuffer.allocate(capacity).order(BYTE_ORDER).putShort(dimensions);
        Arrays.stream(vectors).forEach(v -> Arrays.stream(v).forEach(buffer::putFloat));
        return ByteString.copyFrom((byte[])buffer.array());
    }

    public static Float[] fromByteString(ByteString bs) {
        if (bs.size() % 4 != 0) {
            throw new IllegalArgumentException("byte string size not a multiple of " + String.valueOf(4) + " (Float.BYTES)");
        }
        float[] vector = new float[bs.size() / 4];
        bs.asReadOnlyByteBuffer().order(BYTE_ORDER).asFloatBuffer().get(vector);
        return ArrayUtils.toObject((float[])vector);
    }

    public static Float[][] fromByteStringMulti(ByteString bs) {
        if (bs == null || bs.size() == 0) {
            return new Float[0][0];
        }
        ByteBuffer buf = bs.asReadOnlyByteBuffer().order(BYTE_ORDER);
        short dimensions = buf.getShort();
        FloatBuffer fbuf = buf.asFloatBuffer();
        int n = fbuf.remaining() / dimensions;
        Float[][] vectors = new Float[n][dimensions];
        for (int i = 0; i < n; ++i) {
            float[] v = new float[dimensions];
            fbuf.get(v, 0, dimensions);
            vectors[i] = ArrayUtils.toObject((float[])v);
        }
        return vectors;
    }

    public static class Arguments {
        public NearVectorArgument.NearVectorArgumentBuilder nearVectorArgBuilder() {
            return NearVectorArgument.builder();
        }
    }
}

