/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.ConnectionManager;
import io.vertx.redis.client.impl.RedisConnectionImpl;
import io.vertx.redis.client.impl.Resolver;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.List;
import java.util.Random;

public class RedisSentinelClient
implements Redis {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelClient.class);
    private final Context context;
    private final ConnectionManager connectionManager;
    private final RedisOptions options;
    private RedisConnection sentinel;

    public RedisSentinelClient(Vertx vertx, RedisOptions options) {
        this.context = vertx.getOrCreateContext();
        this.options = options;
        if (options.getMaxPoolSize() < 2) {
            throw new IllegalStateException("Invalid options: maxPoolSize must be at least 2");
        }
        if (options.getMaxPoolWaiting() < options.getMaxPoolSize()) {
            throw new IllegalStateException("Invalid options: maxPoolWaiting < maxPoolSize");
        }
        this.connectionManager = new ConnectionManager(vertx, options);
        this.connectionManager.start();
    }

    @Override
    public void close() {
        this.connectionManager.close();
    }

    @Override
    public Redis connect(Handler<AsyncResult<RedisConnection>> onCreate) {
        this.createConnectionInternal(this.options, this.options.getRole(), (Handler<AsyncResult<RedisConnection>>)((Handler)createConnection -> {
            if (createConnection.failed()) {
                onCreate.handle((Object)Future.failedFuture((Throwable)createConnection.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)createConnection.result();
            this.createConnectionInternal(this.options, RedisRole.SENTINEL, (Handler<AsyncResult<RedisConnection>>)((Handler)create -> {
                if (create.failed()) {
                    LOG.error((Object)"Redis PUB/SUB wrap failed.", create.cause());
                    return;
                }
                this.sentinel = (RedisConnection)create.result();
                this.sentinel.handler(msg -> {
                    if (msg.type() == ResponseType.MULTI && "MESSAGE".equalsIgnoreCase(msg.get(0).toString())) {
                        if (conn != null) {
                            ((RedisConnectionImpl)conn).fail(ErrorType.create("SWITCH-MASTER Received +switch-master message from Redis Sentinel."));
                        } else {
                            LOG.warn((Object)"Received +switch-master message from Redis Sentinel.");
                        }
                    }
                });
                this.sentinel.send(Request.cmd(Command.SUBSCRIBE).arg("+switch-master"), (Handler<AsyncResult<Response>>)((Handler)send -> {
                    if (send.failed()) {
                        LOG.error((Object)"Unable to subscribe to Sentinel PUBSUB", send.cause());
                    }
                }));
                this.sentinel.exceptionHandler(t -> LOG.error((Object)"Unhandled exception in Sentinel PUBSUB", t));
            }));
            onCreate.handle((Object)Future.succeededFuture((Object)conn));
        }));
        return this;
    }

    private void createConnectionInternal(RedisOptions options, RedisRole role, Handler<AsyncResult<RedisConnection>> onCreate) {
        Handler createAndConnect = resolve -> {
            if (resolve.failed()) {
                onCreate.handle((Object)Future.failedFuture((Throwable)resolve.cause()));
                return;
            }
            this.connectionManager.getConnection(this.context, (String)resolve.result(), null, onCreate);
        };
        switch (role) {
            case SENTINEL: {
                RedisSentinelClient.resolveClient(this::isSentinelOk, options, (Handler<AsyncResult<String>>)createAndConnect);
                break;
            }
            case MASTER: {
                RedisSentinelClient.resolveClient(this::getMasterFromEndpoint, options, (Handler<AsyncResult<String>>)createAndConnect);
                break;
            }
            case SLAVE: {
                RedisSentinelClient.resolveClient(this::getSlaveFromEndpoint, options, (Handler<AsyncResult<String>>)createAndConnect);
            }
        }
    }

    private static void resolveClient(Resolver checkEndpointFn, RedisOptions options, Handler<AsyncResult<String>> callback) {
        RedisSentinelClient.iterate(0, checkEndpointFn, options, (Handler<AsyncResult<Pair<Integer, String>>>)((Handler)iterate -> {
            if (iterate.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)iterate.cause()));
            } else {
                Pair found = (Pair)iterate.result();
                List<String> endpoints = options.getEndpoints();
                String endpoint = endpoints.get((Integer)found.left);
                endpoints.set((Integer)found.left, endpoints.get(0));
                endpoints.set(0, endpoint);
                callback.handle((Object)Future.succeededFuture(found.right));
            }
        }));
    }

    private static void iterate(int idx, Resolver checkEndpointFn, RedisOptions argument, Handler<AsyncResult<Pair<Integer, String>>> resultHandler) {
        List<String> endpoints = argument.getEndpoints();
        if (idx >= endpoints.size()) {
            resultHandler.handle((Object)Future.failedFuture((String)"No more endpoints in chain."));
            return;
        }
        checkEndpointFn.resolve(endpoints.get(idx), argument, (Handler<AsyncResult<String>>)((Handler)res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(new Pair<Integer, Object>(idx, res.result())));
            } else {
                RedisSentinelClient.iterate(idx + 1, checkEndpointFn, argument, resultHandler);
            }
        }));
    }

    private void isSentinelOk(String endpoint, RedisOptions argument, Handler<AsyncResult<String>> handler) {
        this.connectionManager.getConnection(this.context, endpoint, null, (Handler<AsyncResult<RedisConnection>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)onCreate.result();
            conn.send(Request.cmd(Command.PING), (Handler<AsyncResult<Response>>)((Handler)info -> {
                if (info.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)endpoint));
                }
                conn.close();
            }));
        }));
    }

    private void getMasterFromEndpoint(String endpoint, RedisOptions options, Handler<AsyncResult<String>> handler) {
        this.connectionManager.getConnection(this.context, endpoint, null, (Handler<AsyncResult<RedisConnection>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)onCreate.result();
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("GET-MASTER-ADDR-BY-NAME").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)getMasterAddrByName -> {
                if (getMasterAddrByName.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)getMasterAddrByName.cause()));
                } else {
                    Response response = (Response)getMasterAddrByName.result();
                    handler.handle((Object)Future.succeededFuture((Object)("redis://" + response.get(0).toString() + ":" + response.get(1).toInteger())));
                }
                conn.close();
            }));
        }));
    }

    private void getSlaveFromEndpoint(String endpoint, RedisOptions options, Handler<AsyncResult<String>> handler) {
        this.connectionManager.getConnection(this.context, endpoint, null, (Handler<AsyncResult<RedisConnection>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            RedisConnection conn = (RedisConnection)onCreate.result();
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("SLAVES").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)sentinelSlaves -> {
                if (sentinelSlaves.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)sentinelSlaves.cause()));
                } else {
                    Response response = (Response)sentinelSlaves.result();
                    if (response.size() == 0) {
                        handler.handle((Object)Future.failedFuture((String)("No slaves linked to the master: " + masterName)));
                    } else {
                        Response slaveInfoArr = response.get(RANDOM.nextInt(response.size()));
                        if (slaveInfoArr.size() % 2 > 0) {
                            handler.handle((Object)Future.failedFuture((String)"Corrupted response from the sentinel"));
                        } else {
                            int port = 6379;
                            String ip = null;
                            for (int i = 0; i < slaveInfoArr.size(); i += 2) {
                                if ("port".equals(slaveInfoArr.get(i).toString())) {
                                    port = slaveInfoArr.get(i + 1).toInteger();
                                }
                                if (!"ip".equals(slaveInfoArr.get(i).toString())) continue;
                                ip = slaveInfoArr.get(i + 1).toString();
                            }
                            if (ip == null) {
                                handler.handle((Object)Future.failedFuture((String)"No IP found for a SLAVE node!"));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)("redis://" + ip + ":" + port)));
                            }
                        }
                    }
                }
                conn.close();
            }));
        }));
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }
    }
}

