/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import java.util.NoSuchElementException;

final class RangeLongForwardIterator
implements Iterator<Long> {
    private final long start;
    private final long end;
    private final long step;
    private final boolean inclusive;
    private long next;
    private boolean overflow;

    RangeLongForwardIterator(long start, long end, long step, boolean inclusive) {
        this.start = start;
        this.next = start;
        this.end = end;
        this.step = step;
        this.inclusive = inclusive;
    }

    @Override
    public boolean hasNext() {
        if (this.start > this.end) {
            return false;
        }
        if (this.inclusive) {
            return !this.overflow && this.next <= this.end;
        }
        return !this.overflow && this.next < this.end;
    }

    @Override
    public Long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long curr = this.next;
        long r = curr + this.step;
        this.overflow = ((curr ^ r) & (this.step ^ r)) < 0L;
        this.next = r;
        return curr;
    }
}

