/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Iterator;
import java.util.NoSuchElementException;

final class RangeIntForwardIterator
implements Iterator<Integer> {
    private final int start;
    private final int end;
    private final int step;
    private final boolean inclusive;
    private int next;
    private boolean overflow;

    RangeIntForwardIterator(int start, int end, int step, boolean inclusive) {
        this.start = start;
        this.next = start;
        this.end = end;
        this.step = step;
        this.inclusive = inclusive;
    }

    @Override
    public boolean hasNext() {
        if (this.start > this.end) {
            return false;
        }
        if (this.inclusive) {
            return !this.overflow && this.next <= this.end;
        }
        return !this.overflow && this.next < this.end;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int curr = this.next;
        int r = curr + this.step;
        this.overflow = ((curr ^ r) & (this.step ^ r)) < 0;
        this.next = r;
        return curr;
    }
}

