/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.Constant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.NdNode;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldManyToOne;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldOneToOne;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdAnnotationValuePair;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantArray;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantBoolean;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantByte;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantChar;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantDouble;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantFloat;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantInt;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantLong;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantShort;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdVariable;

public abstract class NdConstant
extends NdNode {
    public static final FieldManyToOne<NdConstantArray> PARENT_ARRAY;
    public static final FieldOneToOne<NdAnnotationValuePair> PARENT_ANNOTATION_VALUE;
    public static final FieldOneToOne<NdVariable> PARENT_VARIABLE;
    public static final FieldOneToOne<NdMethod> PARENT_METHOD;
    public static StructDef<NdConstant> type;

    static {
        type = StructDef.createAbstract(NdConstant.class, NdNode.type);
        PARENT_ARRAY = FieldManyToOne.createOwner(type, NdConstantArray.ELEMENTS);
        PARENT_ANNOTATION_VALUE = FieldOneToOne.createOwner(type, NdAnnotationValuePair.type, NdAnnotationValuePair.VALUE);
        PARENT_VARIABLE = FieldOneToOne.createOwner(type, NdVariable.type, NdVariable.CONSTANT);
        PARENT_METHOD = FieldOneToOne.createOwner(type, NdMethod.type, NdMethod.DEFAULT_VALUE);
        type.done();
    }

    protected NdConstant(Nd nd) {
        super(nd);
    }

    public static NdConstant create(Nd nd, Constant constant) {
        if (constant == Constant.NotAConstant) {
            return null;
        }
        switch (constant.typeID()) {
            case 5: {
                return NdConstantBoolean.create(nd, constant.booleanValue());
            }
            case 3: {
                return NdConstantByte.create(nd, constant.byteValue());
            }
            case 2: {
                return NdConstantChar.create(nd, constant.charValue());
            }
            case 8: {
                return NdConstantDouble.create(nd, constant.doubleValue());
            }
            case 9: {
                return NdConstantFloat.create(nd, constant.floatValue());
            }
            case 10: {
                return NdConstantInt.create(nd, constant.intValue());
            }
            case 7: {
                return NdConstantLong.create(nd, constant.longValue());
            }
            case 4: {
                return NdConstantShort.create(nd, constant.shortValue());
            }
            case 11: {
                return NdConstantString.create(nd, constant.stringValue());
            }
        }
        throw new IllegalArgumentException("Unknown typeID() " + constant.typeID());
    }

    public void setParent(NdConstantArray result) {
        PARENT_ARRAY.put(this.getNd(), this.address, result);
    }

    public abstract Constant getConstant();

    public String toString() {
        try {
            return this.getConstant().toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }
}

