/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.NdNode;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.NdNodeTypeRegistry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.ChunkCache;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.Database;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldSearchIndex;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.indexer.FileStateCache;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdComplexTypeSignature;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantArray;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantBoolean;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantByte;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantChar;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantClass;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantDouble;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantEnum;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantFloat;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantInt;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantLong;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantShort;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdConstantString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdMethodAnnotationData;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdResourceFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeArgument;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeId;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeInterface;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeSignature;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdVariable;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdWorkspaceLocation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.util.CharArrayUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JavaIndex {
    static final int CURRENT_VERSION = Nd.version(1, 49);
    static final int MAX_SUPPORTED_VERSION = Nd.version(1, 49);
    static final int MIN_SUPPORTED_VERSION = Nd.version(1, 49);
    public static final FieldSearchIndex<NdResourceFile> FILES;
    public static final FieldSearchIndex<NdTypeId> SIMPLE_INDEX;
    public static final FieldSearchIndex<NdTypeId> TYPES;
    public static final StructDef<JavaIndex> type;
    private static final BestResourceFile bestResourceFile;
    private final long address;
    private Nd nd;
    private FieldSearchIndex.IResultRank anyResult = new FieldSearchIndex.IResultRank(){

        @Override
        public long getRank(Nd dom, long address1) {
            return 1L;
        }
    };
    private static Nd globalNd;
    private static final Object ndMutex;

    static {
        type = StructDef.create(JavaIndex.class);
        FILES = FieldSearchIndex.create(type, NdResourceFile.FILENAME);
        SIMPLE_INDEX = FieldSearchIndex.create(type, NdTypeId.SIMPLE_NAME);
        TYPES = FieldSearchIndex.create(type, NdTypeId.FIELD_DESCRIPTOR);
        type.done();
        assert (type.getFactory().getRecordSize() <= 4096);
        bestResourceFile = new BestResourceFile();
        ndMutex = new Object();
    }

    public JavaIndex(Nd dom, long address) {
        this.address = address;
        this.nd = dom;
    }

    public NdResourceFile getResourceFile(char[] location) {
        return FILES.findBest(this.nd, this.address, FieldSearchIndex.SearchCriteria.create(location), bestResourceFile);
    }

    public boolean isUpToDate(NdResourceFile file) throws CoreException {
        if (file != null && file.isDoneIndexing()) {
            String location = file.getLocation().getString();
            FileStateCache cache = FileStateCache.getCache(this.getNd());
            Boolean cachedResult = cache.isUpToDate(location);
            if (cachedResult != null) {
                return cachedResult;
            }
            Path locationPath = new Path(location);
            boolean result = file.getFingerprint().test((IPath)locationPath, null).matches();
            cache.put(location, result);
            return result;
        }
        return false;
    }

    public List<NdResourceFile> findResourcesWithPath(String thePath) {
        return FILES.findAll(this.nd, this.address, FieldSearchIndex.SearchCriteria.create(thePath.toCharArray()));
    }

    public List<NdResourceFile> getAllResourceFiles() {
        return FILES.asList(this.nd, this.address);
    }

    public NdTypeId findType(char[] fieldDescriptor) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create(fieldDescriptor);
        return TYPES.findBest(this.nd, this.address, searchCriteria, this.anyResult);
    }

    public boolean visitFieldDescriptorsStartingWith(char[] fieldDescriptorPrefix, FieldSearchIndex.Visitor<NdTypeId> visitor) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create(fieldDescriptorPrefix).prefix(true);
        return TYPES.visitAll(this.nd, this.address, searchCriteria, visitor);
    }

    public NdTypeId createTypeId(char[] fieldDescriptor) {
        NdTypeId existingType = this.findType(fieldDescriptor);
        if (existingType != null) {
            return existingType;
        }
        if (fieldDescriptor.length > 1 && fieldDescriptor[0] == 'L' && fieldDescriptor[fieldDescriptor.length - 1] != ';') {
            throw new IllegalStateException(String.valueOf(new String(fieldDescriptor)) + " is not a valid field descriptor");
        }
        NdTypeId result = new NdTypeId(this.nd, fieldDescriptor);
        if (!CharArrayUtils.equals(result.getFieldDescriptor().getChars(), fieldDescriptor)) {
            throw new IllegalStateException("Field descriptor didn't match");
        }
        return result;
    }

    public Nd getNd() {
        return this.nd;
    }

    public static IPath getLocationForElement(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getLocation() == null ? Path.EMPTY : resource.getLocation();
        }
        return next.getPath();
    }

    public static boolean isEnabled() {
        return false;
    }

    public static Nd createNd(File databaseFile, ChunkCache chunkCache) {
        return new Nd(databaseFile, chunkCache, JavaIndex.createTypeRegistry(), MIN_SUPPORTED_VERSION, MAX_SUPPORTED_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Nd getGlobalNd() {
        Nd localNd;
        Object object = ndMutex;
        synchronized (object) {
            localNd = globalNd;
        }
        if (localNd != null) {
            return localNd;
        }
        localNd = JavaIndex.createNd(JavaIndex.getDBFile(), ChunkCache.getSharedInstance());
        object = ndMutex;
        synchronized (object) {
            if (globalNd == null) {
                globalNd = localNd;
            }
            return globalNd;
        }
    }

    public static JavaIndex getIndex(Nd nd) {
        return new JavaIndex(nd, Database.DATA_AREA_OFFSET);
    }

    public static JavaIndex getIndex() {
        return JavaIndex.getIndex(JavaIndex.getGlobalNd());
    }

    static File getDBFile() {
        IPath stateLocation = JavaCore.getPlugin().getStateLocation();
        return stateLocation.append("index.db").toFile();
    }

    static NdNodeTypeRegistry<NdNode> createTypeRegistry() {
        NdNodeTypeRegistry<NdNode> registry = new NdNodeTypeRegistry<NdNode>();
        registry.register(40, NdBinding.type.getFactory());
        registry.register(48, NdComplexTypeSignature.type.getFactory());
        registry.register(56, NdConstant.type.getFactory());
        registry.register(64, NdConstantAnnotation.type.getFactory());
        registry.register(80, NdConstantArray.type.getFactory());
        registry.register(96, NdConstantBoolean.type.getFactory());
        registry.register(112, NdConstantByte.type.getFactory());
        registry.register(128, NdConstantChar.type.getFactory());
        registry.register(144, NdConstantClass.type.getFactory());
        registry.register(160, NdConstantDouble.type.getFactory());
        registry.register(176, NdConstantEnum.type.getFactory());
        registry.register(192, NdConstantFloat.type.getFactory());
        registry.register(208, NdConstantInt.type.getFactory());
        registry.register(224, NdConstantLong.type.getFactory());
        registry.register(240, NdConstantShort.type.getFactory());
        registry.register(256, NdConstantString.type.getFactory());
        registry.register(272, NdMethod.type.getFactory());
        registry.register(280, NdMethodAnnotationData.type.getFactory());
        registry.register(336, NdResourceFile.type.getFactory());
        registry.register(368, NdType.type.getFactory());
        registry.register(400, NdTypeArgument.type.getFactory());
        registry.register(416, NdTypeInterface.type.getFactory());
        registry.register(448, NdTypeSignature.type.getFactory());
        registry.register(464, NdTypeId.type.getFactory());
        registry.register(480, NdTypeInterface.type.getFactory());
        registry.register(496, NdVariable.type.getFactory());
        registry.register(512, NdWorkspaceLocation.type.getFactory());
        return registry;
    }

    private static final class BestResourceFile
    implements FieldSearchIndex.IResultRank {
        @Override
        public long getRank(Nd resourceFileNd, long resourceFileAddress) {
            return NdResourceFile.TIME_LAST_SCANNED.get(resourceFileNd, resourceFileAddress);
        }
    }
}

